/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.util.Arrays;
import java.util.List;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.client.CVSClientConstants;
import oracle.jdevimpl.vcs.cvs.client.CVSMethodSpecifier;
import oracle.jdevimpl.vcs.cvs.client.CVSRootSpecifier;

public class CVSRootString
implements CVSClientConstants {
    public static final String ROOT_ACCESS_LOCAL = "local";
    public static final String ROOT_ACCESS_EXT = "ext";
    public static final String ROOT_ACCESS_PSERVER = "pserver";
    public static final String ROOT_ACCESS_SSPI = "sspi";
    public static final String ROOT_ACCESS_SERVER = "server";
    public static final String ROOT_ACCESS_FORK = "fork";
    public static final String ROOT_ACCESS_SSH2 = "ssh2";
    private final CVSRootSpecifier _spec;

    public CVSRootString(CVSRootSpecifier spec) {
        this._spec = spec;
    }

    public CVSRootString(String root) {
        this._spec = CVSRootSpecifier.parseRootSpec(root != null ? root : "");
    }

    public CVSRootString(CVSMethodSpecifier method, String user, String password, String server, String port, boolean usePortColon, String repos) {
        this._spec = CVSRootSpecifier.createRootSpec(method, user, password, server, port, usePortColon, repos);
    }

    public boolean getUsePortColon() {
        return this._spec.hasPortColon();
    }

    public CVSRootString canonicalize() {
        if (this._spec.getMethod() == null) {
            return this;
        }
        boolean usePortColon = this._spec.hasPortColon();
        String repository = this.getRepository();
        if (CVSActiveClient.isClientCVSNT()) {
            usePortColon = true;
        }
        return new CVSRootString(this.getRootSpecifier().getMethodSpecifier(), this.getUserName(), null, this.getServerLocation(), this.getPort(), usePortColon, repository);
    }

    public CVSRootString removeMethodFields() {
        CVSMethodSpecifier oldMethodSpec = this._spec.getMethodSpecifier();
        CVSMethodSpecifier newMethodSpec = CVSMethodSpecifier.createMethodSpec(oldMethodSpec.getMethod(), null, oldMethodSpec.getDelimiters());
        return new CVSRootString(newMethodSpec, this.getUserName(), this.getPassword(), this.getServerLocation(), this.getPort(), this.getUsePortColon(), this.getRepository());
    }

    public boolean hasKnownAccess() {
        String method = this._spec.getMethod();
        if (method == null) {
            return false;
        }
        List<Object> c = Arrays.asList(ROOT_ACCESS_LOCAL, ROOT_ACCESS_EXT, ROOT_ACCESS_PSERVER, ROOT_ACCESS_SSPI, ROOT_ACCESS_SERVER, ROOT_ACCESS_FORK, ROOT_ACCESS_SSH2);
        return c.contains(method);
    }

    public String getAccessMethod() {
        return this._spec.getMethod() != null ? this._spec.getMethod() : "";
    }

    public String getUserName() {
        return this._spec.getUser();
    }

    public String getPassword() {
        return this._spec.getPassword();
    }

    public String getServerLocation() {
        return this._spec.getHost();
    }

    public String getPort() {
        return this._spec.getPort();
    }

    public String getRepository() {
        return this._spec.getRepository();
    }

    public Integer getIntegerPort() {
        if (this._spec.getPort() == null || this._spec.getPort().equals("")) {
            return null;
        }
        try {
            Integer n = Integer.valueOf(this._spec.getPort());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean isAccessLocal() {
        return this.getAccessMethod().equals(ROOT_ACCESS_LOCAL);
    }

    public boolean isAccessExternal() {
        return this.getAccessMethod().equals(ROOT_ACCESS_EXT);
    }

    public boolean isAccessPServer() {
        return this.getAccessMethod().equals(ROOT_ACCESS_PSERVER);
    }

    public boolean isAccessSspi() {
        return this.getAccessMethod().equals(ROOT_ACCESS_SSPI);
    }

    public boolean isAccessServer() {
        return this.getAccessMethod().equals(ROOT_ACCESS_SERVER);
    }

    public boolean isAccessFork() {
        return this.getAccessMethod().equals(ROOT_ACCESS_FORK);
    }

    public boolean isAccessSsh2() {
        return this.getAccessMethod().equals(ROOT_ACCESS_SSH2);
    }

    public boolean supportsUserName() {
        return this.hasKnownAccess() && (this.isAccessExternal() || this.isAccessPServer() || this.isAccessServer() || this.isAccessSsh2());
    }

    public boolean supportsServerLocation() {
        return this.hasKnownAccess() && !this.isAccessLocal() && !this.isAccessFork();
    }

    public boolean supportsPort() {
        return this.hasKnownAccess() && this.isAccessPServer();
    }

    public boolean supportsRepository() {
        return this.hasKnownAccess();
    }

    public boolean supportsPassword() {
        return this.hasKnownAccess() && this.isAccessPServer();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CVSRootString)) {
            return false;
        }
        CVSRootString root1 = this.canonicalize();
        CVSRootString root2 = ((CVSRootString)other).canonicalize();
        return root1._spec.equals(root2._spec);
    }

    public String toString() {
        return this._spec.toString();
    }

    public static final String canonicalizeCVSNTRoot(String root) {
        return root;
    }

    public CVSRootSpecifier getRootSpecifier() {
        return this._spec;
    }
}

