/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.SortedListModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.error.CVSNavServicesException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSModuleSelectionPanel
extends JPanel {
    private static final String GUI_LIST = "list";
    private static final String GUI_MESSAGE = "message";
    private static final String GUI_BUSY = "busy";
    private final Collection _connectionsWithRecentModuleLists;
    private final ArrayList _moduleNameChangeListeners;
    private final JTextField _moduleNameTextField;
    private final JList _moduleNameList;
    private final JButton _refreshModuleListButton;
    private final Map _moduleFileDataCache;
    private final ListSelectionListener _listSelectionListener;
    private final FocusableLabel _moduleMessageLabel;
    private final JPanel _moduleNameGui;
    private final CardLayout _moduleNameListLayout;
    private Component _parent;
    private String _connectionName;
    private SortedListModel _moduleNameListModel;
    private SearchField _moduleSearchField;

    private void $init$() {
        this._connectionsWithRecentModuleLists = new ArrayList();
        this._moduleNameChangeListeners = new ArrayList();
        this._moduleNameTextField = new JTextField();
        this._moduleNameList = new JList();
        this._refreshModuleListButton = new JButton();
        this._moduleFileDataCache = new WeakHashMap();
        this._moduleMessageLabel = new FocusableLabel(" ");
        this._moduleNameGui = new JPanel();
        this._moduleNameListLayout = new CardLayout();
        this._connectionName = "";
    }

    public CVSModuleSelectionPanel() {
        this((Component)null);
    }

    public CVSModuleSelectionPanel(Component parent) {
        this.$init$();
        this._moduleSearchField = new SearchField();
        this._moduleSearchField.setStyle(SearchField.Style.FILTER);
        this._moduleSearchField.addSearchListener((SearchListener)new 1());
        this._moduleSearchField.getTextField().setColumns(15);
        JLabel busyLabel = new JLabel(CVSArb.getString(385), OracleIcons.getIcon((String)"throbber.gif"), 0);
        busyLabel.setBackground(UIManager.getColor("window"));
        busyLabel.setForeground(UIManager.getColor("textText"));
        busyLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        busyLabel.setOpaque(true);
        this._moduleMessageLabel.setBackground(UIManager.getColor("window"));
        this._moduleMessageLabel.setForeground(UIManager.getColor("textText"));
        this._moduleMessageLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        this._moduleMessageLabel.setOpaque(true);
        this._moduleNameGui.setLayout(this._moduleNameListLayout);
        this._moduleNameGui.add((Component)new JScrollPane(this._moduleNameList), GUI_LIST);
        this._moduleNameGui.add((Component)busyLabel, GUI_BUSY);
        this._moduleNameGui.add((Component)this._moduleMessageLabel, GUI_MESSAGE);
        this._moduleNameListLayout.show(this._moduleNameGui, GUI_LIST);
        Box box = Box.createHorizontalBox();
        JLabel pathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)pathLabel, (Component)this._moduleNameTextField, (String)CVSArb.getString(90));
        box.add(pathLabel);
        box.add(Box.createHorizontalStrut(4));
        box.add(this._moduleNameTextField);
        JPanel center = new JPanel(new BorderLayout(4, 4));
        center.add((Component)this._moduleSearchField, "North");
        center.add((Component)this._moduleNameGui, "Center");
        JPanel center2 = new JPanel(new BorderLayout(4, 4));
        center2.add((Component)center, "Center");
        center2.add((Component)box, "South");
        this.setLayout(new BorderLayout(4, 4));
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this._refreshModuleListButton);
        this.add((Component)center2, "Center");
        this.add((Component)box, "South");
        ResourceUtils.resButton((AbstractButton)this._refreshModuleListButton, (String)CVSArb.getString(247));
        this._parent = parent;
        this._moduleNameListModel = new SortedListModel();
        this._moduleNameList.setModel(this._moduleNameListModel);
        this._moduleNameList.setPrototypeCellValue("just_a_dummy_module_name");
        this._moduleNameList.setCellRenderer(new ModuleNameListCellRenderer(null));
        this._moduleNameList.setSelectionMode(0);
        this._moduleNameList.setVisibleRowCount(5);
        this._moduleNameListModel.setComparator((Comparator)new ModuleNameComparator(null));
        this._listSelectionListener = new 2();
        this._refreshModuleListButton.addActionListener(new 3());
        this._moduleNameList.addListSelectionListener(this._listSelectionListener);
        this._moduleNameTextField.getDocument().addDocumentListener(new 4());
    }

    public void setVisibleRowCount(int rowCount) {
        this._moduleNameList.setVisibleRowCount(rowCount);
    }

    public void setParentComponent(Component parent) {
        this._parent = parent;
    }

    public void connectionNameChanged(String connectionName) {
        this._connectionName = connectionName;
        this.updateModuleComponents();
    }

    public Component getModuleNameComponent() {
        return this._moduleNameTextField;
    }

    public void addModuleNameChangeListener(ChangeListener l) {
        this._moduleNameChangeListeners.add(l);
    }

    public void removeModuleNameChangeListener(ChangeListener l) {
        this._moduleNameChangeListeners.remove(l);
    }

    private void fireModuleNameChanged() {
        ChangeEvent ce = new ChangeEvent(this);
        int i = this._moduleNameChangeListeners.size() - 1;
        while (i >= 0) {
            ((ChangeListener)this._moduleNameChangeListeners.get(i)).stateChanged(ce);
            --i;
        }
    }

    public void setModuleName(String moduleName) {
        this._moduleNameTextField.setText(moduleName);
    }

    public String getModuleName() {
        return this._moduleNameTextField.getText();
    }

    public void requestFocus() {
        this._moduleNameTextField.requestFocus();
    }

    private void _refreshModuleListButton_actionPerformed(ActionEvent e) {
        WaitCursor waitCursor = new WaitCursor(this._parent);
        this._moduleSearchField.setEnabled(false);
        this._moduleSearchField.getTextField().setEnabled(false);
        this._refreshModuleListButton.setEnabled(false);
        waitCursor.show();
        this._moduleNameListLayout.show(this._moduleNameGui, GUI_BUSY);
        try {
            CVSConnectionNodes.getConnectionListNode().open();
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
        new GetModuleListWorker(waitCursor).start();
    }

    private void updateModuleComponents() {
        this.updateModuleListComponents();
        this.updateGetModuleListButton();
    }

    private void updateModuleListComponents() {
        this._moduleNameList.removeListSelectionListener(this._listSelectionListener);
        CVSConnectionData connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(this._connectionName);
        DefaultListModel moduleNameListModel = (DefaultListModel)this._moduleNameList.getModel();
        moduleNameListModel.removeAllElements();
        CVSConnectionFileData[] moduleFileData = null;
        if (connection != null) {
            moduleFileData = connection.getModuleFileData();
        }
        if (moduleFileData == null) {
            moduleFileData = new CVSConnectionFileData[]{};
        }
        int i = 0;
        while (i < moduleFileData.length) {
            this._moduleFileDataCache.put(moduleFileData[i].getFileName(), moduleFileData[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < moduleFileData.length) {
            moduleNameListModel.addElement(moduleFileData[i2].getFileName());
            ++i2;
        }
        this._moduleNameList.setModel(this._moduleNameListModel);
        if (moduleFileData.length > 0) {
            this._moduleNameListLayout.show(this._moduleNameGui, GUI_LIST);
            this._moduleSearchField.setEnabled(true);
            this._moduleSearchField.getTextField().setEnabled(true);
        } else {
            this._moduleMessageLabel.setText(this.isGetModuleListRequired() ? CVSArb.getString(86) : CVSArb.getString(590));
            this._moduleNameListLayout.show(this._moduleNameGui, GUI_MESSAGE);
            this._moduleSearchField.setEnabled(false);
            this._moduleSearchField.getTextField().setEnabled(false);
        }
        this._moduleNameList.setSelectedIndices(new int[0]);
        this._moduleSearchField.clear();
        this._moduleNameList.addListSelectionListener(this._listSelectionListener);
        this._moduleNameList.validate();
        this._moduleNameList.repaint();
    }

    public void setModuleNameFromFirstItem() {
        if (this._moduleNameList.getModel().getSize() > 0) {
            this._moduleNameTextField.setText(this._moduleNameList.getModel().getElementAt(0).toString());
            this._moduleNameList.setSelectedIndex(0);
        }
    }

    private void updateGetModuleListButton() {
        this._refreshModuleListButton.setEnabled(true);
    }

    private boolean isGetModuleListRequired() {
        if (!this._connectionsWithRecentModuleLists.contains(this._connectionName)) {
            return this._moduleNameTextField.isEnabled();
        }
        if (!CVSConnectionNodes.isConnectionListOpen()) {
            return this._moduleNameTextField.isEnabled();
        }
        CVSConnectionData connectionData = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(this._connectionName);
        return connectionData != null && connectionData.getModuleFileData() == null;
    }

    static Map ra$_moduleFileDataCache(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._moduleFileDataCache;
    }

    static Component ra$_parent(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._parent;
    }

    static void mav$updateModuleComponents(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        cVSModuleSelectionPanel.updateModuleComponents();
    }

    static SearchField ra$_moduleSearchField(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._moduleSearchField;
    }

    static JButton ra$_refreshModuleListButton(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._refreshModuleListButton;
    }

    static JTextField ra$_moduleNameTextField(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._moduleNameTextField;
    }

    static String ra$_connectionName(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._connectionName;
    }

    static Collection ra$_connectionsWithRecentModuleLists(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._connectionsWithRecentModuleLists;
    }

    static SortedListModel ra$_moduleNameListModel(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._moduleNameListModel;
    }

    static JList ra$_moduleNameList(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        return cVSModuleSelectionPanel._moduleNameList;
    }

    static void mav$_refreshModuleListButton_actionPerformed(CVSModuleSelectionPanel cVSModuleSelectionPanel, ActionEvent actionEvent) {
        cVSModuleSelectionPanel._refreshModuleListButton_actionPerformed(actionEvent);
    }

    static void mav$fireModuleNameChanged(CVSModuleSelectionPanel cVSModuleSelectionPanel) {
        cVSModuleSelectionPanel.fireModuleNameChanged();
    }

    final class 1
    implements SearchListener {
        public void searchPerformed(SearchEvent event) {
            if (CVSModuleSelectionPanel.ra$_moduleNameListModel(CVSModuleSelectionPanel.this) == null) {
                return;
            }
            String searchText = event.getSearchText();
            if (searchText.equals("")) {
                CVSModuleSelectionPanel.ra$_moduleNameList(CVSModuleSelectionPanel.this).setModel(CVSModuleSelectionPanel.ra$_moduleNameListModel(CVSModuleSelectionPanel.this));
                return;
            }
            SearchMatcher matcher = SearchMatcher.getPrefixMatcher((CharSequence)searchText, (boolean)true, (boolean)true);
            DefaultListModel<Object> model = new DefaultListModel<Object>();
            int i = 0;
            while (i < CVSModuleSelectionPanel.ra$_moduleNameListModel(CVSModuleSelectionPanel.this).getSize()) {
                if (matcher.matches((CharSequence)((String)CVSModuleSelectionPanel.ra$_moduleNameListModel(CVSModuleSelectionPanel.this).getElementAt(i)))) {
                    model.addElement(CVSModuleSelectionPanel.ra$_moduleNameListModel(CVSModuleSelectionPanel.this).getElementAt(i));
                }
                ++i;
            }
            CVSModuleSelectionPanel.ra$_moduleNameList(CVSModuleSelectionPanel.this).setModel(model);
            if (CVSModuleSelectionPanel.ra$_moduleNameListModel(CVSModuleSelectionPanel.this).size() > 0) {
                CVSModuleSelectionPanel.ra$_moduleNameList(CVSModuleSelectionPanel.this).setSelectedIndex(0);
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            Object value = CVSModuleSelectionPanel.ra$_moduleNameList(CVSModuleSelectionPanel.this).getSelectedValue();
            CVSModuleSelectionPanel.ra$_moduleNameTextField(CVSModuleSelectionPanel.this).setText(value != null ? value.toString() : "");
        }
    }

    final class 3
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            CVSModuleSelectionPanel.mav$_refreshModuleListButton_actionPerformed(CVSModuleSelectionPanel.this, e);
        }
    }

    final class 4
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        private void documentUpdate(DocumentEvent e) {
            CVSModuleSelectionPanel.mav$fireModuleNameChanged(CVSModuleSelectionPanel.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModuleNameComparator
    implements Comparator {
        private final Collator _stringCollator;

        private void $init$() {
            this._stringCollator = (Collator)Collator.getInstance().clone();
            this._stringCollator.setStrength(0);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            return this.compareImpl(o1, o2);
        }

        protected int compareImpl(Object o1, Object o2) {
            CVSConnectionFileData fileData1 = (CVSConnectionFileData)CVSModuleSelectionPanel.ra$_moduleFileDataCache(CVSModuleSelectionPanel.this).get(o1);
            CVSConnectionFileData fileData2 = (CVSConnectionFileData)CVSModuleSelectionPanel.ra$_moduleFileDataCache(CVSModuleSelectionPanel.this).get(o2);
            if (fileData1 == null || fileData2 == null) {
                return 0;
            }
            if (!fileData1.isModulesEntry() && fileData2.isModulesEntry()) {
                return -1;
            }
            if (fileData1.isModulesEntry() && !fileData2.isModulesEntry()) {
                return 1;
            }
            return this.getStringCollator().compare(fileData1.getFileName(), fileData2.getFileName());
        }

        protected Collator getStringCollator() {
            return this._stringCollator;
        }

        private ModuleNameComparator() {
            this.$init$();
        }

        ModuleNameComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ModuleNameListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            this.setText("");
            this.setIcon(null);
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            CVSConnectionFileData fileData = (CVSConnectionFileData)CVSModuleSelectionPanel.ra$_moduleFileDataCache(CVSModuleSelectionPanel.this).get(value);
            this.setText(fileData != null ? fileData.getFileName() : value.toString());
            if (fileData != null && fileData.isModulesEntry()) {
                this.setIcon(CVSConnectionElement.MODULE_ICON);
            } else {
                this.setIcon(CVSConnectionElement.DIRECTORY_ICON);
            }
            return this;
        }

        private ModuleNameListCellRenderer() {
        }

        ModuleNameListCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class GetModuleListWorker
    extends SwingWorker {
        private final WaitCursor _waitCursor;

        GetModuleListWorker(WaitCursor waitCursor) {
            this._waitCursor = waitCursor;
        }

        public Object construct() {
            CVSConnectionFileData[] fileData;
            if (!this.ensureConnectionLogin(CVSModuleSelectionPanel.ra$_connectionName(CVSModuleSelectionPanel.this))) {
                return null;
            }
            String connectionRoot = CVSConnectionNodes.getConnectionListAPI().getConnectionRoot(CVSModuleSelectionPanel.ra$_connectionName(CVSModuleSelectionPanel.this));
            if (connectionRoot == null) {
                return null;
            }
            try {
                CVSModuleSelectionPanel.ra$_connectionsWithRecentModuleLists(CVSModuleSelectionPanel.this).add(CVSModuleSelectionPanel.ra$_connectionName(CVSModuleSelectionPanel.this));
                fileData = CVSConnectionNodeUtils.getRootFileList(connectionRoot);
            }
            catch (CVSNavServicesException nse) {
                CVSClient.getInstance().getExceptionHandler().handleException((Exception)((Object)nse), CVSModuleSelectionPanel.ra$_parent(CVSModuleSelectionPanel.this));
                Object var7_4 = null;
                return var7_4;
            }
            catch (VCSCancelException e) {
                CVSModuleSelectionPanel.ra$_connectionsWithRecentModuleLists(CVSModuleSelectionPanel.this).remove(CVSModuleSelectionPanel.ra$_connectionName(CVSModuleSelectionPanel.this));
                Object var8_6 = null;
                return var8_6;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                Object var9_8 = null;
                return var9_8;
            }
            if (!CVSConnectionNodes.isConnectionListOpen()) {
                CVSConnectionNodes.openConnectionList();
            }
            CVSConnectionData connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(CVSModuleSelectionPanel.ra$_connectionName(CVSModuleSelectionPanel.this));
            connection.setModuleFileData(fileData);
            return connection;
        }

        public void finished() {
            try {
                CVSModuleSelectionPanel.mav$updateModuleComponents(CVSModuleSelectionPanel.this);
                if (this.getValue() == null) {
                    return;
                }
                CVSModuleSelectionPanel.this.setModuleNameFromFirstItem();
                CVSModuleSelectionPanel.ra$_moduleNameTextField(CVSModuleSelectionPanel.this).requestFocus();
            }
            finally {
                this._waitCursor.hide();
                CVSModuleSelectionPanel.ra$_moduleSearchField(CVSModuleSelectionPanel.this).setEnabled(true);
                CVSModuleSelectionPanel.ra$_moduleSearchField(CVSModuleSelectionPanel.this).getTextField().setEnabled(true);
                CVSModuleSelectionPanel.ra$_refreshModuleListButton(CVSModuleSelectionPanel.this).setEnabled(true);
            }
        }

        private boolean ensureConnectionLogin(String connectionName) {
            try {
                CVSConnectionNodeUtils.ensureLogin(connectionName, CVSModuleSelectionPanel.ra$_parent(CVSModuleSelectionPanel.this));
                boolean bl = true;
                return bl;
            }
            catch (VCSException vcse) {
                CVSClient.getInstance().getExceptionHandler().handleException((Exception)((Object)vcse), CVSModuleSelectionPanel.ra$_parent(CVSModuleSelectionPanel.this));
                boolean bl = false;
                return bl;
            }
        }
    }
}

