/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.net.URLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSTagCache {
    private static final CVSTagCache _instance = new CVSTagCache();
    private static final Map<URL, Collection<Tag>> _cache = new LinkedHashMap<URL, Collection<Tag>>();

    static CVSTagCache getInstance() {
        return _instance;
    }

    synchronized void cache(URL url, Tag tag) {
        Collection<Tag> tags = _cache.get(url);
        if (tags == null) {
            tags = new HashSet<Tag>();
            _cache.put(url, tags);
        }
        tags.add(tag);
    }

    synchronized Collection<Tag> get(URL url) {
        return _cache.get(url);
    }

    synchronized Collection<Tag> get(URLFilter filter) {
        HashSet<Tag> resultTags = new HashSet<Tag>();
        for (Map.Entry<URL, Collection<Tag>> entry : _cache.entrySet()) {
            if (!filter.accept(entry.getKey())) continue;
            resultTags.addAll(entry.getValue());
        }
        return resultTags;
    }

    synchronized void clear(URLFilter filter) {
        for (URL url : new HashSet<URL>(_cache.keySet())) {
            if (!filter.accept(url)) continue;
            _cache.remove(url);
        }
    }

    synchronized void clear() {
        _cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tag
    implements Comparable<Tag> {
        private String _name;
        private boolean _branch;

        Tag() {
        }

        Tag(String name) {
            this.setName(name);
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public boolean isBranch() {
            return this._branch;
        }

        public void setBranch(boolean branch) {
            this._branch = branch;
        }

        public boolean equals(Object o) {
            return o instanceof Tag && this._name.equals(((Tag)o)._name);
        }

        public int hashCode() {
            return this._name.hashCode();
        }

        @Override
        public int compareTo(Tag other) {
            return this._name.compareTo(other._name);
        }
    }
}

