/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.util.SwingUtils;
import oracle.javatools.util.Version;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSBaseTagView;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagActions;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCache;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCategory;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagListView;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagNode;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagTreeView;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.date.CVSISODateFormat;
import oracle.ocvs.OCVSPrompter;
import oracle.ocvs.OCVSRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSTagChooser {
    private static final String GUI_BUSY = "busy";
    private static final String GUI_TAGS = "tags";
    private static final String DATE_DTCACHE_KEY = "CVS.DateCache";
    private final URL[] _urls;
    private SearchField _tagSearchField;
    private JButton _refreshTagsButton;
    private JButton _findMoreTagsButton;
    private JButton _addDateButton;
    private Collection<URL> _coalesceUrls;
    private Collection<URL> _currentQueryUrls;
    private CVSBaseTagView _view;
    private Collection<CVSTagCategory> _categories;
    private final CVSTagActions _actions;
    private JPanel _panel;
    private Collection<CVSTagNode> _model;
    private boolean _busy;
    private Collection<ChangeListener> _busyStateListeners;
    private Collection<ChangeListener> _selectionListeners;
    private Collection<ActionListener> _closeActionListeners;
    private CardLayout _cardLayout;
    private JPanel _cardLayoutPanel;
    private String _initialTagValue;
    private boolean _stopped;
    private CVSRootString _contextRoot;
    private String _moduleName;
    private String _rcsPath;
    private boolean _recursive;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._actions = new CVSTagActions(this);
        this._busyStateListeners = new ArrayList<ChangeListener>();
        this._selectionListeners = new ArrayList<ChangeListener>();
        this._closeActionListeners = new ArrayList<ActionListener>();
    }

    static final String internalToExternalDate(String internalDate) {
        try {
            Date date = new CVSISODateFormat().parse(internalDate);
            String externalDate = new ExternalDateFormat().format(date);
            String string = externalDate = externalDate + CVSTagChooser.extractTimeZone(internalDate);
            return string;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            String string = "";
            return string;
        }
    }

    static final String externalToInternalDate(String externalDate) {
        try {
            Date date = new ExternalDateFormat().parse(externalDate);
            String internalDate = new CVSISODateFormat().format(date);
            String string = internalDate = internalDate + CVSTagChooser.extractTimeZone(externalDate);
            return string;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            String string = "";
            return string;
        }
    }

    private static final String extractTimeZone(String date) {
        return date.substring(date.lastIndexOf(32));
    }

    public CVSTagChooser(CVSTagCategory[] categories, ViewMode viewMode) {
        this(categories, null, null, null, viewMode);
    }

    public CVSTagChooser(CVSTagCategory[] categories, URL[] urls, ViewMode viewMode) {
        this(categories, urls, null, null, viewMode);
    }

    public CVSTagChooser(CVSTagCategory[] categories, CVSRootString contextRoot, String moduleName, ViewMode viewMode) {
        this(categories, null, contextRoot, moduleName, viewMode);
    }

    private CVSTagChooser(CVSTagCategory[] categories, URL[] urls, CVSRootString contextRoot, String moduleName, ViewMode viewMode) {
        this.$init$();
        this._categories = Arrays.asList(categories);
        this._urls = urls;
        this._contextRoot = contextRoot;
        this._moduleName = moduleName;
        if (contextRoot != null && moduleName != null) {
            String rootRepository = contextRoot.getRepository() != null ? contextRoot.getRepository() : contextRoot.toString();
            this._rcsPath = rootRepository + '/' + moduleName;
        }
        this._view = viewMode == ViewMode.TREE ? new CVSTagTreeView() : new CVSTagListView();
        this._view.setCategories(this._categories);
        this._view.setActions(this._actions);
        this._view.initializeView();
        this._view.setSelectionListener(new 1());
        this.setBusy(true);
    }

    private List<String> getDateCache() {
        ArrayList cache = (ArrayList)Ide.getDTCache().getData(DATE_DTCACHE_KEY);
        if (cache == null) {
            cache = new ArrayList();
            Ide.getDTCache().putData(DATE_DTCACHE_KEY, cache);
        }
        return cache;
    }

    public Component getGUI() {
        if (this._panel != null) {
            return this._panel;
        }
        this._panel = new JPanel(new BorderLayout(4, 4));
        this._tagSearchField = new SearchField();
        this._tagSearchField.setStyle(SearchField.Style.FILTER);
        this._tagSearchField.addSearchListener((SearchListener)new 2());
        this._tagSearchField.getTextField().setColumns(15);
        if (this._urls != null || this._rcsPath != null) {
            this._refreshTagsButton = new JButton();
            this._findMoreTagsButton = new JButton();
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            this._addDateButton = new JButton();
        }
        if (this._refreshTagsButton != null) {
            this._refreshTagsButton.addActionListener(new 3());
        }
        if (this._findMoreTagsButton != null) {
            this._findMoreTagsButton.addActionListener(new 4());
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            this._addDateButton.setAction(this._actions.getAddDateAction());
        }
        if (this._refreshTagsButton != null) {
            ResourceUtils.resButton((AbstractButton)this._refreshTagsButton, (String)CVSArb.getString(143));
        }
        if (this._findMoreTagsButton != null) {
            ResourceUtils.resButton((AbstractButton)this._findMoreTagsButton, (String)CVSArb.getString(259));
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            ResourceUtils.resButton((AbstractButton)this._addDateButton, (String)CVSArb.getString(472));
        }
        Box buttonPanel = Box.createHorizontalBox();
        if (this._refreshTagsButton != null) {
            buttonPanel.add(this._refreshTagsButton);
        }
        if (this._findMoreTagsButton != null) {
            buttonPanel.add(Box.createHorizontalStrut(4));
            buttonPanel.add(this._findMoreTagsButton);
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            buttonPanel.add(Box.createHorizontalStrut(4));
            buttonPanel.add(this._addDateButton);
        }
        JLabel busyLabel = new JLabel(CVSArb.getString(385), OracleIcons.getIcon((String)"throbber.gif"), 0);
        busyLabel.setBackground(UIManager.getColor("window"));
        busyLabel.setForeground(UIManager.getColor("textText"));
        busyLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        busyLabel.setOpaque(true);
        this._cardLayout = new CardLayout();
        this._cardLayoutPanel = new JPanel(this._cardLayout);
        this._cardLayoutPanel.add((Component)busyLabel, GUI_BUSY);
        this._cardLayoutPanel.add(this._view.getGUI(), GUI_TAGS);
        Box north = Box.createHorizontalBox();
        north.add((Component)this._tagSearchField);
        if (buttonPanel.getComponentCount() > 0) {
            north.add(Box.createHorizontalStrut(4));
            north.add(buttonPanel);
        }
        this._panel.add((Component)north, "North");
        this._panel.add((Component)this._cardLayoutPanel, "Center");
        busyLabel.setMinimumSize(this._view.getGUI().getPreferredSize());
        this._setBusy(this._busy);
        this._panel.setAlignmentX(0.0f);
        this._panel.setAlignmentY(0.0f);
        return this._panel;
    }

    public Component getInitialFocusComponent() {
        this.getGUI();
        return this._tagSearchField;
    }

    public void setInitialTagValue(String initialTagValue) {
        this._initialTagValue = initialTagValue;
    }

    public void start() {
        this.findTags();
    }

    public void stop() {
        this._stopped = true;
    }

    public String getTagValue() {
        CVSTagNode node = this.getSelectedNode();
        return node != null && node.getTag() != null ? node.getTag().getName() : null;
    }

    public String getDateValueISO8601() {
        CVSTagNode node = this.getSelectedNode();
        return node != null ? node.getDate() : null;
    }

    private void findTags() {
        if (this._urls != null || this._rcsPath == null) {
            // empty if block
        }
        if (this._urls != null && this._rcsPath != null) {
            this._rcsPath = null;
        }
        if (this._urls == null && this._rcsPath != null) {
            this._currentQueryUrls = Collections.singleton(this.createRemoteURL(this._rcsPath));
        }
        if (this._urls != null && this._rcsPath == null) {
            this._coalesceUrls = Arrays.asList(VCSFileSystemUtils.coalesceURLs((URL[])this._urls));
            ArrayList<URL> urlsToQuery = new ArrayList<URL>();
            block0: for (URL url : this._coalesceUrls) {
                1EntryIterator itr = new 1EntryIterator(url);
                while (itr.hasNext()) {
                    urlsToQuery.add((URL)itr.next());
                    if (urlsToQuery.size() >= 3) break block0;
                }
            }
            this._currentQueryUrls = urlsToQuery;
            if (this.isQueryURLsSameAsCoalesceURLs(this._currentQueryUrls, this._coalesceUrls)) {
                this._currentQueryUrls = this._coalesceUrls;
            }
        }
        this.query();
    }

    private boolean isQueryURLsSameAsCoalesceURLs(Collection<URL> c1, Collection<URL> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        Iterator<URL> itr1 = c1.iterator();
        Iterator<URL> itr2 = c2.iterator();
        while (itr1.hasNext()) {
            URL url1 = itr1.next();
            URL url2 = itr2.next();
            if (url1.toExternalForm().equals(url2.toExternalForm())) continue;
            return false;
        }
        return true;
    }

    private void query() {
        this.setBusy(true);
        5 r = new 5();
        new Thread((Runnable)r, "CVS Tag Chooser").start();
    }

    private void _query() throws Exception {
        HashSet<CVSTagCache.Tag> resultTags = new HashSet<CVSTagCache.Tag>();
        if (this._urls != null || this._rcsPath == null) {
            // empty if block
        }
        if (this._urls != null && this._rcsPath != null) {
            this._rcsPath = null;
        }
        if (this._urls == null && this._rcsPath != null) {
            URL urlToQuery = this._currentQueryUrls.iterator().next();
            Collection<CVSTagCache.Tag> tags = CVSTagCache.getInstance().get(new 6(this, urlToQuery));
            if (tags != null && !tags.isEmpty()) {
                resultTags.addAll(tags);
            } else {
                CVSRunner runner = this.createRunner(null, this._contextRoot);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("rlog");
                cmd.add("-h");
                if (!this._recursive) {
                    cmd.add("-l");
                }
                cmd.add(this._moduleName);
                runner.setCmdList(cmd);
                runner.addOutputMonitor(new 7(this, resultTags));
                runner.exec();
            }
        }
        if (this._urls != null && this._rcsPath == null) {
            for (URL urlToQuery : this._currentQueryUrls) {
                if (this._stopped) {
                    return;
                }
                if (this._currentQueryUrls != this._coalesceUrls && URLFileSystem.isDirectoryPath((URL)urlToQuery)) {
                    resultTags.addAll(CVSTagCache.getInstance().get(VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{urlToQuery})));
                    continue;
                }
                URL directoryUrl = URLFileSystem.isDirectoryPath((URL)urlToQuery) ? urlToQuery : URLFileSystem.getParent((URL)urlToQuery);
                CVSRunner runner = this.createRunner(directoryUrl, null);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("log");
                cmd.add("-h");
                if (!URLFileSystem.isDirectoryPath((URL)urlToQuery)) {
                    cmd.add(URLFileSystem.getFileName((URL)urlToQuery));
                }
                runner.setCmdList(cmd);
                runner.addOutputMonitor(new 8(this, directoryUrl, resultTags));
                runner.exec();
            }
        }
        ArrayList<CVSTagNode> model = new ArrayList<CVSTagNode>();
        if (this._categories.contains((Object)CVSTagCategory.HEAD)) {
            CVSTagNode item = new CVSTagNode(CVSTagCategory.HEAD);
            CVSTagCache.Tag tag = new CVSTagCache.Tag("HEAD");
            item.setTag(tag);
            item.setIcon(OracleIcons.getIcon((String)"package.png"));
            model.add(item);
        }
        if (this._categories.contains((Object)CVSTagCategory.BRANCH)) {
            for (CVSTagCache.Tag tag : resultTags) {
                if (!tag.isBranch()) continue;
                CVSTagNode item = new CVSTagNode(CVSTagCategory.BRANCH);
                item.setTag(tag);
                item.setIcon(OracleIcons.getIcon((String)"package.png"));
                model.add(item);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.VERSION)) {
            for (CVSTagCache.Tag tag : resultTags) {
                if (tag.isBranch()) continue;
                CVSTagNode item = new CVSTagNode(CVSTagCategory.VERSION);
                item.setTag(tag);
                item.setIcon(OracleIcons.getIcon((String)"label.png"));
                model.add(item);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            ArrayList<String> dateCache = new ArrayList<String>(this.getDateCache());
            Collections.sort(dateCache);
            for (String date : dateCache) {
                CVSTagNode item = new CVSTagNode(CVSTagCategory.DATE);
                item.setIcon(OracleIcons.getIcon((String)"history.png"));
                item.setDate(date);
                model.add(item);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.BASE)) {
            CVSTagNode item = new CVSTagNode(CVSTagCategory.BASE);
            CVSTagCache.Tag tag = new CVSTagCache.Tag("BASE");
            item.setTag(tag);
            item.setIcon(OracleIcons.getIcon((String)"label.png"));
            model.add(item);
        }
        Collections.sort((List)model, new NodeComparator(null));
        EventQueue.invokeLater(new 9(this, model));
    }

    private URL createRemoteURL(String rcsPath) {
        return URLFactory.newURL((String)"ide.scm.cvs.,v", (String)rcsPath);
    }

    private CVSRunner createRunner(URL directoryUrl, CVSRootString contextRoot) {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        if (runner instanceof CVSInternalClientRunner) {
            ((CVSInternalClientRunner)runner).setPrompter(new CancelPrompter(null));
        }
        runner.getParameters().setKeepCachedFiles(true);
        if (directoryUrl != null) {
            runner.setDirURL(directoryUrl);
        }
        if (contextRoot != null) {
            runner.getParameters().setRoot(contextRoot.toString());
        }
        return runner;
    }

    private CVSTagCache.Tag createTag(String name, String revision) throws NumberFormatException {
        Version version = new Version(revision);
        int[] parts = version.toIntArray();
        int n = parts.length;
        int[] nArray = parts;
        int n2 = 0;
        while (n2 < nArray.length) {
            int i = nArray[n2];
            if (i == 0) {
                --n;
            }
            ++n2;
        }
        CVSTagCache.Tag tag = new CVSTagCache.Tag();
        tag.setName(name);
        tag.setBranch(n % 2 != 0);
        return tag;
    }

    private void findMoreTags() {
        if (this._rcsPath != null) {
            this._recursive = true;
            this.refreshTags();
        } else {
            this._currentQueryUrls = this._coalesceUrls;
        }
        this.query();
    }

    private void refreshTags() {
        if (this._rcsPath != null) {
            CVSTagCache.getInstance().clear(new 10());
        } else {
            CVSTagCache.getInstance().clear(VCSURLFilters.createBaseURLContentsFilter((URL[])this._currentQueryUrls.toArray(new URL[0])));
        }
        this.query();
    }

    CVSTagNode getSelectedNode() {
        return this._view.getSelectedNode();
    }

    void requestFocusInView() {
        this._view.requestFocus();
    }

    void addDate() {
        JLabel dateLabel = new JLabel();
        JLabel timeZoneLabel = new JLabel();
        JRadioButton localRadioButton = new JRadioButton();
        JRadioButton utcRadioButton = new JRadioButton();
        DateEditor dateEditor = new DateEditor(new Date(), Calendar.getInstance(), (DateFormat)new ExternalDateFormat());
        Box panel = Box.createHorizontalBox();
        panel.add(dateLabel);
        panel.add(Box.createHorizontalStrut(4));
        panel.add((Component)dateEditor);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(localRadioButton);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(utcRadioButton);
        ResourceUtils.resLabel((JLabel)dateLabel, (Component)dateEditor, (String)CVSArb.getString(645));
        ResourceUtils.resLabel((JLabel)timeZoneLabel, (Component)timeZoneLabel, (String)CVSArb.getString(92));
        ResourceUtils.resButton((AbstractButton)localRadioButton, (String)CVSArb.getString(492));
        ResourceUtils.resButton((AbstractButton)utcRadioButton, (String)CVSArb.getString(29));
        ButtonGroup bg = new ButtonGroup();
        bg.add(localRadioButton);
        bg.add(utcRadioButton);
        localRadioButton.setSelected(true);
        JEWTDialog dialog = new JEWTDialog(SwingUtils.getAncestorDialog((Component)this.getGUI()), CVSArb.getString(667));
        dialog.setButtonMask(3);
        dialog.setContent((Component)panel);
        if (!dialog.runDialog()) {
            return;
        }
        String externalDate = dateEditor.getDateString();
        externalDate = utcRadioButton.isSelected() ? externalDate + " GMT" : externalDate + new SimpleDateFormat(" zzz").format(new Date());
        String internalDate = CVSTagChooser.externalToInternalDate(externalDate);
        CVSTagNode item = new CVSTagNode(CVSTagCategory.DATE);
        item.setIcon(OracleIcons.getIcon((String)"history.png"));
        item.setDate(internalDate);
        ArrayList<CVSTagNode> model = new ArrayList<CVSTagNode>(this._model);
        model.add(item);
        Collections.sort((List)model, new NodeComparator(null));
        if (this._tagSearchField != null) {
            this._tagSearchField.clear();
        }
        this._model = model;
        this._view.setModel(this._model);
        this._view.selectNode(item);
        this.getDateCache().add(internalDate);
        Ide.getDTCache().save();
    }

    static {
        $assertionsDisabled = CVSTagChooser.class.desiredAssertionStatus() ^ true;
    }

    void removeSelectedDate() {
        String internalDate;
        CVSTagNode node = this.getSelectedNode();
        String string = internalDate = node != null ? node.getDate() : null;
        if (!$assertionsDisabled && internalDate == null) {
            throw new AssertionError();
        }
        this._model.remove(node);
        this._view.removeSelectedNode();
        this.getDateCache().remove(internalDate);
        Ide.getDTCache().save();
    }

    public void addBusyStateListener(ChangeListener l) {
        this._busyStateListeners.add(l);
    }

    public void removeBusyStateListener(ChangeListener l) {
        this._busyStateListeners.remove(l);
    }

    public void addSelectionListener(ChangeListener l) {
        this._selectionListeners.add(l);
    }

    public void removeSelectionListener(ChangeListener l) {
        this._selectionListeners.remove(l);
    }

    public void addCloseActionListener(ActionListener l) {
        this._closeActionListeners.add(l);
    }

    public void removeCloseActionListener(ActionListener l) {
        this._closeActionListeners.remove(l);
    }

    public boolean isBusy() {
        return this._busy;
    }

    private void setBusy(boolean busy) {
        if (busy == this._busy) {
            return;
        }
        this._busy = busy;
        this._setBusy(busy);
        ChangeListener[] l = this._busyStateListeners.toArray(new ChangeListener[0]);
        int i = l.length - 1;
        while (i >= 0) {
            l[i].stateChanged(new ChangeEvent(this));
            --i;
        }
    }

    private void _setBusy(boolean busy) {
        if (this._panel == null) {
            return;
        }
        this._cardLayout.show(this._cardLayoutPanel, busy ? GUI_BUSY : GUI_TAGS);
        this._view.setBusy(busy);
        this._tagSearchField.setEnabled(busy ^ true);
        this._tagSearchField.getTextField().setEnabled(busy ^ true);
        if (this._refreshTagsButton != null) {
            this._refreshTagsButton.setEnabled(busy ^ true);
        }
        if (this._findMoreTagsButton != null) {
            if (this._rcsPath != null) {
                this._findMoreTagsButton.setEnabled((this._recursive || busy) ^ true);
            } else {
                this._findMoreTagsButton.setEnabled(this._currentQueryUrls != this._coalesceUrls && !busy);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            this._addDateButton.setEnabled(busy ^ true);
        }
    }

    Collection<CVSTagNode> getModel() {
        return new ArrayList<CVSTagNode>(this._model);
    }

    Collection<String> getAvailableTags() {
        ArrayList<String> tags = new ArrayList<String>();
        for (CVSTagNode node : this._model) {
            if (node.getTag() == null) continue;
            tags.add(node.getTag().getName());
        }
        return tags;
    }

    Collection<String> getAvailableDatesISO8601() {
        ArrayList<String> tags = new ArrayList<String>();
        for (CVSTagNode node : this._model) {
            if (node.getDate() == null) continue;
            tags.add(node.getDate());
        }
        return tags;
    }

    static CVSTagCache.Tag mav$createTag(CVSTagChooser cVSTagChooser, String string, String string2) {
        return cVSTagChooser.createTag(string, string2);
    }

    static URL mav$createRemoteURL(CVSTagChooser cVSTagChooser, String string) {
        return cVSTagChooser.createRemoteURL(string);
    }

    static SearchField ra$_tagSearchField(CVSTagChooser cVSTagChooser) {
        return cVSTagChooser._tagSearchField;
    }

    static void wa$_model(CVSTagChooser cVSTagChooser, Collection collection) {
        cVSTagChooser._model = collection;
    }

    static CVSBaseTagView ra$_view(CVSTagChooser cVSTagChooser) {
        return cVSTagChooser._view;
    }

    static Collection ra$_model(CVSTagChooser cVSTagChooser) {
        return cVSTagChooser._model;
    }

    static String ra$_initialTagValue(CVSTagChooser cVSTagChooser) {
        return cVSTagChooser._initialTagValue;
    }

    static void mav$setBusy(CVSTagChooser cVSTagChooser, boolean bl) {
        cVSTagChooser.setBusy(bl);
    }

    static void mav$_query(CVSTagChooser cVSTagChooser) {
        cVSTagChooser._query();
    }

    static void mav$refreshTags(CVSTagChooser cVSTagChooser) {
        cVSTagChooser.refreshTags();
    }

    static void mav$findMoreTags(CVSTagChooser cVSTagChooser) {
        cVSTagChooser.findMoreTags();
    }

    static Collection ra$_selectionListeners(CVSTagChooser cVSTagChooser) {
        return cVSTagChooser._selectionListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ViewMode
    extends Enum<ViewMode> {
        private static final /* synthetic */ ViewMode[] $v;
        public static final /* enum */ ViewMode TREE;
        public static final /* enum */ ViewMode LIST;

        public static ViewMode valueOf(String string) {
            return Enum.valueOf(ViewMode.class, string);
        }

        public static final ViewMode[] values() {
            return (ViewMode[])$v.clone();
        }

        static {
            ViewMode[] viewModeArray = new ViewMode[2];
            viewModeArray[1] = LIST = new ViewMode("LIST", 1);
            viewModeArray[0] = TREE = new ViewMode("TREE", 0);
            $v = viewModeArray;
        }

        private ViewMode(String string2, int n2) {
        }
    }

    private static class ExternalDateFormat
    extends SimpleDateFormat {
        ExternalDateFormat() {
            super("dd MMM yyyy kk:mm");
        }
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            ChangeListener[] l = CVSTagChooser.ra$_selectionListeners(CVSTagChooser.this).toArray(new ChangeListener[0]);
            int i = l.length - 1;
            while (i >= 0) {
                l[i].stateChanged(new ChangeEvent(this));
                --i;
            }
        }
    }

    final class 2
    implements SearchListener {
        public void searchPerformed(SearchEvent event) {
            if (CVSTagChooser.ra$_model(CVSTagChooser.this) == null) {
                return;
            }
            String searchText = event.getSearchText();
            if (searchText.equals("")) {
                CVSTagChooser.ra$_view(CVSTagChooser.this).setModel(CVSTagChooser.ra$_model(CVSTagChooser.this));
                CVSTagChooser.ra$_view(CVSTagChooser.this).selectFirstNode();
                return;
            }
            SearchMatcher matcher = SearchMatcher.getPrefixMatcher((CharSequence)searchText, (boolean)true, (boolean)true);
            ArrayList<CVSTagNode> model = new ArrayList<CVSTagNode>(CVSTagChooser.ra$_model(CVSTagChooser.this));
            Iterator itr = model.iterator();
            while (itr.hasNext()) {
                String tagName;
                CVSTagNode node = (CVSTagNode)itr.next();
                String string = tagName = node.getTag() != null ? node.getTag().getName() : CVSTagChooser.internalToExternalDate(node.getDate());
                if (matcher.matches((CharSequence)tagName)) continue;
                itr.remove();
            }
            CVSTagChooser.ra$_view(CVSTagChooser.this).setModel(model);
            CVSTagChooser.ra$_view(CVSTagChooser.this).selectFirstNode();
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CVSTagChooser.mav$refreshTags(CVSTagChooser.this);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CVSTagChooser.mav$findMoreTags(CVSTagChooser.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class 1EntryIterator
    implements Iterator<URL> {
        private URL _next;
        private LinkedList<URL> _entries;
        private LinkedList<URL> _directoryStack;

        private void $init$() {
            this._entries = new LinkedList();
            this._directoryStack = new LinkedList();
        }

        1EntryIterator(URL url) {
            this.$init$();
            if (URLFileSystem.isDirectoryPath((URL)url)) {
                this._directoryStack.add(url);
            } else {
                try {
                    List entries = CVSEntriesCache.getInstance().getEntries(URLFileSystem.getParent((URL)url));
                    CVSEntry entry = CVSEntriesCache.findEntry(entries, url);
                    if (entry != null && this.isReturnableEntry(entry, url)) {
                        this._entries.addFirst(url);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this._next();
        }

        private boolean isReturnableEntry(CVSEntry entry, URL entryUrl) {
            if (entry.getName().startsWith(".")) {
                return false;
            }
            return !entry.isDirectory() && !entry.isRemoved() && URLFileSystem.exists((URL)entryUrl) && !URLFileSystem.isDirectory((URL)entryUrl);
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public URL next() {
            URL next = this._next;
            this._next();
            return next;
        }

        private void _next() {
            if (!this._entries.isEmpty()) {
                this._next = this._entries.removeFirst();
                return;
            }
            if (this._directoryStack.isEmpty()) {
                this._next = null;
                return;
            }
            URL directoryUrl = this._directoryStack.removeFirst();
            try {
                List entries = CVSEntriesCache.getInstance().getEntries(directoryUrl);
                Collections.sort(entries, new 1());
                for (CVSEntry entry : entries) {
                    if (entry.getName().startsWith(".")) continue;
                    URL entryUrl = URLFactory.newURL((URL)directoryUrl, (String)entry.getName());
                    if (entry.isDirectory() && URLFileSystem.isDirectory((URL)entryUrl)) {
                        this._directoryStack.addFirst(entryUrl);
                    }
                    if (!this.isReturnableEntry(entry, entryUrl)) continue;
                    this._entries.addFirst(entryUrl);
                }
                this._next();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        final class 1
        implements Comparator {
            public int compare(CVSEntry entry1, CVSEntry entry2) {
                return -entry1.getName().compareTo(entry2.getName());
            }
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            try {
                CVSTagChooser.mav$_query(CVSTagChooser.this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    final class 6
    implements URLFilter {
        private final /* synthetic */ URL v$urlToQuery;
        final /* synthetic */ CVSTagChooser this$0;

        public boolean accept(URL url) {
            return url.getProtocol().equals(this.v$urlToQuery.getProtocol()) && url.getPath().startsWith(this.v$urlToQuery.getPath());
        }

        public 6(CVSTagChooser cVSTagChooser, URL uRL) {
            this.v$urlToQuery = uRL;
            this.this$0 = cVSTagChooser;
        }
    }

    final class 7
    extends CVSProcessStreamMonitor {
        private final Pattern _pattern1;
        private final Pattern _pattern2;
        private String _currentRcsFile;
        private final /* synthetic */ Collection v$resultTags;
        final /* synthetic */ CVSTagChooser this$0;

        private void $init$() {
            this._pattern1 = Pattern.compile("RCS file: (.*)");
            this._pattern2 = Pattern.compile("\\t(.+?): (.*)");
        }

        protected void streamLine(String line, CVSProcess process) throws Exception {
            Matcher matcher = this._pattern1.matcher(line);
            if (matcher.matches()) {
                this._currentRcsFile = matcher.group(1);
            }
            if (!(matcher = this._pattern2.matcher(line)).matches()) {
                return;
            }
            if (this._currentRcsFile == null) {
                Assert.fail();
                return;
            }
            CVSTagCache.Tag tag = CVSTagChooser.mav$createTag(this.this$0, matcher.group(1), matcher.group(2));
            this.v$resultTags.add(tag);
            CVSTagCache.getInstance().cache(CVSTagChooser.mav$createRemoteURL(this.this$0, this._currentRcsFile), tag);
        }

        public 7(CVSTagChooser cVSTagChooser, Collection collection) {
            this.v$resultTags = collection;
            this.this$0 = cVSTagChooser;
            this.$init$();
        }
    }

    final class 8
    extends CVSProcessStreamMonitor {
        private final Pattern _pattern1;
        private final Pattern _pattern2;
        private URL _currentUrl;
        private final /* synthetic */ URL v$directoryUrl;
        private final /* synthetic */ Collection v$resultTags;
        final /* synthetic */ CVSTagChooser this$0;

        private void $init$() {
            this._pattern1 = Pattern.compile("Working file: (.*)");
            this._pattern2 = Pattern.compile("\\t(.+?): (.*)");
        }

        protected void streamLine(String line, CVSProcess process) throws Exception {
            Matcher matcher = this._pattern1.matcher(line);
            if (matcher.matches()) {
                this._currentUrl = URLFactory.newURL((URL)this.v$directoryUrl, (String)matcher.group(1));
            }
            if (!(matcher = this._pattern2.matcher(line)).matches()) {
                return;
            }
            if (this._currentUrl == null) {
                Assert.fail();
                return;
            }
            CVSTagCache.Tag tag = CVSTagChooser.mav$createTag(this.this$0, matcher.group(1), matcher.group(2));
            this.v$resultTags.add(tag);
            CVSTagCache.getInstance().cache(this._currentUrl, tag);
        }

        public 8(CVSTagChooser cVSTagChooser, URL uRL, Collection collection) {
            this.v$resultTags = collection;
            this.v$directoryUrl = uRL;
            this.this$0 = cVSTagChooser;
            this.$init$();
        }
    }

    final class 9
    implements Runnable {
        private final /* synthetic */ Collection v$model;
        final /* synthetic */ CVSTagChooser this$0;

        public void run() {
            if (CVSTagChooser.ra$_tagSearchField(this.this$0) != null) {
                CVSTagChooser.ra$_tagSearchField(this.this$0).clear();
            }
            CVSTagChooser.wa$_model(this.this$0, this.v$model);
            CVSTagChooser.ra$_view(this.this$0).setModel(CVSTagChooser.ra$_model(this.this$0));
            if (CVSTagChooser.ra$_initialTagValue(this.this$0) != null) {
                CVSTagCache.Tag tagObject = new CVSTagCache.Tag(CVSTagChooser.ra$_initialTagValue(this.this$0));
                for (CVSTagNode node : CVSTagChooser.ra$_model(this.this$0)) {
                    if (node.getTag() == null || !tagObject.equals(node.getTag())) continue;
                    CVSTagChooser.ra$_view(this.this$0).selectNode(node);
                    break;
                }
            } else {
                CVSTagChooser.ra$_view(this.this$0).selectFirstNode();
            }
            CVSTagChooser.mav$setBusy(this.this$0, false);
            if (CVSTagChooser.ra$_tagSearchField(this.this$0) != null) {
                CVSTagChooser.ra$_tagSearchField(this.this$0).requestFocus();
            }
            if (CVSTagChooser.ra$_tagSearchField(this.this$0) == null && CVSTagChooser.ra$_view(this.this$0) != null) {
                CVSTagChooser.ra$_view(this.this$0).requestFocus();
            }
        }

        public 9(CVSTagChooser cVSTagChooser, Collection collection) {
            this.v$model = collection;
            this.this$0 = cVSTagChooser;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeComparator
    implements Comparator<CVSTagNode> {
        @Override
        public int compare(CVSTagNode node1, CVSTagNode node2) {
            int weight2;
            int weight1 = this.getCategoryWeight(node1.getCategory());
            if (weight1 != (weight2 = this.getCategoryWeight(node2.getCategory()))) {
                return weight1 - weight2;
            }
            if (node1.getTag() != null) {
                return node1.getTag().compareTo(node2.getTag());
            }
            if (node1.getDate() != null) {
                return node1.getDate().compareTo(node2.getDate());
            }
            return 0;
        }

        private int getCategoryWeight(CVSTagCategory category) {
            if (category.equals((Object)CVSTagCategory.HEAD)) {
                return 1;
            }
            if (category.equals((Object)CVSTagCategory.BRANCH)) {
                return 2;
            }
            if (category.equals((Object)CVSTagCategory.VERSION)) {
                return 3;
            }
            if (category.equals((Object)CVSTagCategory.DATE)) {
                return 4;
            }
            if (category.equals((Object)CVSTagCategory.BASE)) {
                return 5;
            }
            return -1;
        }

        private NodeComparator() {
        }

        NodeComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 10
    implements URLFilter {
        public boolean accept(URL url) {
            return url.getProtocol().equals("ide.scm.cvs.,v");
        }
    }

    private class CancelPrompter
    extends OCVSPrompter {
        public String promptPassword(OCVSRoot root, String message) {
            return null;
        }

        public boolean promptSsh2YesNo(String message) {
            return false;
        }

        public String promptSsh2Passphrase(String message) {
            return null;
        }

        public String promptSsh2Password(String message) {
            return null;
        }

        private CancelPrompter() {
        }

        CancelPrompter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

