/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.nulls.NullIcon;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSBaseTagView;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CVSTagListView
extends CVSBaseTagView {
    private JList _list;
    private JScrollPane _scrollPane;

    @Override
    void initializeView() {
        this._list = new JList(new DefaultListModel());
        this._list.setCellRenderer(new ListCellRendererImpl());
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(0);
        this._list.setSelectionModel(selectionModel);
        this._scrollPane = new JScrollPane(this._list);
        this._list.setVisibleRowCount(6);
    }

    @Override
    Component getGUI() {
        return this._scrollPane;
    }

    @Override
    CVSTagNode getSelectedNode() {
        Object o = this._list.getSelectedValue();
        return o instanceof CVSTagNode ? (CVSTagNode)o : null;
    }

    @Override
    void removeSelectedNode() {
        ((DefaultListModel)this._list.getModel()).remove(this._list.getSelectedIndex());
    }

    @Override
    void setSelectionListener(ChangeListener l) {
        this._list.addListSelectionListener(new 1(this, l));
    }

    @Override
    void setModel(Collection<CVSTagNode> model) {
        DefaultListModel<CVSTagNode> listModel = new DefaultListModel<CVSTagNode>();
        for (CVSTagNode node : model) {
            listModel.addElement(node);
        }
        this._list.setModel(listModel);
    }

    @Override
    void selectFirstNode() {
        if (this._list.getModel().getSize() > 0) {
            this._list.setSelectedIndex(0);
        }
    }

    @Override
    void selectNode(CVSTagNode node) {
        this._list.setSelectedValue(node, true);
    }

    @Override
    void requestFocus() {
        if (this._list.isShowing()) {
            this._list.requestFocus();
        }
    }

    @Override
    void setBusy(boolean busy) {
        this._list.setEnabled(busy ^ true);
        super.setBusy(busy);
    }

    CVSTagListView() {
    }

    static class ListCellRendererImpl
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof CVSTagNode) {
                CVSTagNode node = (CVSTagNode)value;
                this.setIcon(node.getIcon() != null ? node.getIcon() : new NullIcon(0, 0));
                this.setDisabledIcon(new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.getIcon()).getImage())));
                if (node.getTag() != null) {
                    this.setText(node.getTag().getName());
                }
                if (node.getDate() != null) {
                    this.setText(CVSTagChooser.internalToExternalDate(node.getDate()));
                }
                return this;
            }
            this.setIcon((Icon)new NullIcon(0, 0));
            this.setDisabledIcon(this.getIcon());
            this.setText(null);
            return this;
        }

        ListCellRendererImpl() {
        }
    }

    final class 1
    implements ListSelectionListener {
        private final /* synthetic */ ChangeListener v$l;
        final /* synthetic */ CVSTagListView this$0;

        public void valueChanged(ListSelectionEvent e) {
            this.v$l.stateChanged(new ChangeEvent(this));
        }

        public 1(CVSTagListView cVSTagListView, ChangeListener changeListener) {
            this.v$l = changeListener;
            this.this$0 = cVSTagListView;
        }
    }
}

