/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSBaseTagView;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCategory;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagNode;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CVSTagTreeView
extends CVSBaseTagView {
    private JTree _tree;
    private JScrollPane _scrollPane;
    private DefaultMutableTreeNode _root;
    private DefaultMutableTreeNode _branchesNode;
    private DefaultMutableTreeNode _versionsNode;
    private DefaultMutableTreeNode _datesNode;

    private void $init$() {
        this._branchesNode = null;
        this._versionsNode = null;
        this._datesNode = null;
    }

    @Override
    void initializeView() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this._tree = new JTree(new DefaultTreeModel(root));
        this._tree.setRootVisible(false);
        this._tree.setEditable(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setDragEnabled(false);
        this._tree.setCellRenderer(new TreeCellRendererImpl(null));
        this._root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this._tree.setSelectionModel(selectionModel);
        this._scrollPane = new JScrollPane(this._tree);
        this._tree.setVisibleRowCount(6);
        this._tree.addMouseListener(new 1());
    }

    @Override
    Component getGUI() {
        return this._scrollPane;
    }

    @Override
    CVSTagNode getSelectedNode() {
        TreePath path = this._tree.getSelectionPath();
        DefaultMutableTreeNode node = path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null;
        Object userObject = node != null ? node.getUserObject() : null;
        return userObject instanceof CVSTagNode ? (CVSTagNode)userObject : null;
    }

    @Override
    void removeSelectedNode() {
        DefaultMutableTreeNode node;
        TreePath path = this._tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = node = path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null;
        if (node == null) {
            return;
        }
        ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent(node);
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this._tree.getModel().getRoot()).children();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof CategoryParentNode) || node.getChildCount() != 0) continue;
            ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent(node);
            break;
        }
    }

    private void addNode(CVSTagNode node, boolean notify) {
        if (!this._categories.contains((Object)node.getCategory())) {
            return;
        }
        if (node.getCategory() == CVSTagCategory.HEAD) {
            this._root.insert(new DefaultMutableTreeNode(node, false), 0);
            if (notify) {
                ((DefaultTreeModel)this._tree.getModel()).reload(this._root);
            }
            return;
        }
        if (node.getCategory() == CVSTagCategory.BRANCH) {
            this._branchesNode.add(new DefaultMutableTreeNode(node, false));
            if (notify) {
                ((DefaultTreeModel)this._tree.getModel()).reload(this._branchesNode);
            }
            return;
        }
        if (node.getCategory() == CVSTagCategory.VERSION) {
            this._versionsNode.add(new DefaultMutableTreeNode(node, false));
            if (notify) {
                ((DefaultTreeModel)this._tree.getModel()).reload(this._versionsNode);
            }
            return;
        }
        if (node.getCategory() == CVSTagCategory.DATE) {
            this._datesNode.add(new DefaultMutableTreeNode(node, false));
            if (notify) {
                ((DefaultTreeModel)this._tree.getModel()).reload(this._datesNode);
            }
            return;
        }
        if (node.getCategory() == CVSTagCategory.BASE) {
            this._root.add(new DefaultMutableTreeNode(node, false));
            if (notify) {
                ((DefaultTreeModel)this._tree.getModel()).reload(this._root);
            }
            return;
        }
        throw new IllegalArgumentException("no node category");
    }

    @Override
    void setSelectionListener(ChangeListener l) {
        this._tree.addTreeSelectionListener(new 2(this, l));
    }

    @Override
    void setModel(Collection<CVSTagNode> model) {
        this._root.removeAllChildren();
        if (this._categories.contains((Object)CVSTagCategory.BRANCH) && this.isCategoryInModel(model, CVSTagCategory.BRANCH)) {
            if (this._branchesNode == null) {
                this._branchesNode = new DefaultMutableTreeNode(new CategoryParentNode(CVSArb.getString(150), OracleIcons.getIcon((String)"tree.png")));
            } else {
                this._branchesNode.removeAllChildren();
            }
            this._root.add(this._branchesNode);
        }
        if (this._categories.contains((Object)CVSTagCategory.VERSION) && this.isCategoryInModel(model, CVSTagCategory.VERSION)) {
            if (this._versionsNode == null) {
                this._versionsNode = new DefaultMutableTreeNode(new CategoryParentNode(CVSArb.getString(314), OracleIcons.getIcon((String)"label.png")));
            } else {
                this._versionsNode.removeAllChildren();
            }
            this._root.add(this._versionsNode);
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE) && this.isCategoryInModel(model, CVSTagCategory.DATE)) {
            if (this._datesNode == null) {
                this._datesNode = new DefaultMutableTreeNode(new CategoryParentNode(CVSArb.getString(598), OracleIcons.getIcon((String)"history.png")));
            } else {
                this._datesNode.removeAllChildren();
            }
            this._root.add(this._datesNode);
        }
        for (CVSTagNode node : model) {
            this.addNode(node, false);
        }
        ((DefaultTreeModel)this._tree.getModel()).reload(this._root);
        this.expandAll();
    }

    private boolean isCategoryInModel(Collection<CVSTagNode> model, CVSTagCategory category) {
        for (CVSTagNode node : model) {
            if (node.getCategory() != category) continue;
            return true;
        }
        return false;
    }

    private void expandAll() {
        LeafNodeIterator itr = new LeafNodeIterator(this._tree.getModel());
        while (itr.hasNext()) {
            TreeNode treeNode = itr.next();
            if (treeNode.getChildCount() != 0) continue;
            this._tree.expandPath(this.getPathForTreeNode(treeNode.getParent()));
        }
    }

    @Override
    void selectFirstNode() {
        block0: {
            LeafNodeIterator itr = new LeafNodeIterator(this._tree.getModel());
            if (!itr.hasNext()) break block0;
            this.selectNode((CVSTagNode)((DefaultMutableTreeNode)itr.next()).getUserObject());
        }
    }

    @Override
    void selectNode(CVSTagNode node) {
        LeafNodeIterator itr = new LeafNodeIterator(this._tree.getModel());
        while (itr.hasNext()) {
            TreeNode treeNode = itr.next();
            if (((DefaultMutableTreeNode)treeNode).getUserObject() != node) continue;
            TreePath path = this.getPathForTreeNode(treeNode);
            this._tree.setSelectionPath(path);
            this._tree.scrollPathToVisible(path);
            break;
        }
    }

    private TreePath getPathForTreeNode(TreeNode node) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        while (node != null) {
            nodes.add(node);
            node = node.getParent();
        }
        Collections.reverse(nodes);
        return new TreePath(nodes.toArray());
    }

    @Override
    void requestFocus() {
        if (this._tree.isShowing()) {
            this._tree.requestFocus();
        }
    }

    @Override
    void setBusy(boolean busy) {
        this._tree.setEnabled(busy ^ true);
        super.setBusy(busy);
    }

    CVSTagTreeView() {
        this.$init$();
    }

    static JTree ra$_tree(CVSTagTreeView cVSTagTreeView) {
        return cVSTagTreeView._tree;
    }

    final class 1
    extends MouseAdapter {
        public void mouseReleased(MouseEvent me) {
            if (!me.isPopupTrigger()) {
                return;
            }
            TreePath path = CVSTagTreeView.ra$_tree(CVSTagTreeView.this).getPathForLocation(me.getX(), me.getY());
            TreePath selectionPath = CVSTagTreeView.ra$_tree(CVSTagTreeView.this).getSelectionPath();
            if (!(path == null || selectionPath != null && path.equals(selectionPath))) {
                CVSTagTreeView.ra$_tree(CVSTagTreeView.this).setSelectionPath(path);
            }
            this.popup(me);
        }

        private void popup(MouseEvent me) {
            if (!me.isPopupTrigger()) {
                return;
            }
            if (!CVSTagTreeView.ra$_tree(CVSTagTreeView.this).isEnabled()) {
                return;
            }
            if (!CVSTagTreeView.this._categories.contains((Object)CVSTagCategory.DATE)) {
                return;
            }
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem();
            menuItem.setAction(CVSTagTreeView.this._actions.getAddDateAction());
            ResourceUtils.resButton((AbstractButton)menuItem, (String)CVSArb.getString(472));
            menu.add(menuItem);
            CVSTagNode node = CVSTagTreeView.this.getSelectedNode();
            if (node != null && node.getDate() != null) {
                menuItem = new JMenuItem();
                menuItem.setAction(CVSTagTreeView.this._actions.getRemoveDateAction());
                ResourceUtils.resButton((AbstractButton)menuItem, (String)CVSArb.getString(263));
                menu.add(menuItem);
            }
            menu.show(CVSTagTreeView.ra$_tree(CVSTagTreeView.this), me.getPoint().x, me.getPoint().y);
        }
    }

    private class TreeCellRendererImpl
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof CVSTagNode) {
                    CVSTagNode node = (CVSTagNode)userObject;
                    this.setIcon(node.getIcon() != null ? node.getIcon() : new NullIcon(0, 0));
                    this.setDisabledIcon(this.createGrayIcon(this.getIcon()));
                    if (node.getTag() != null) {
                        this.setText(node.getTag().getName());
                    }
                    if (node.getDate() != null) {
                        this.setText(CVSTagChooser.internalToExternalDate(node.getDate()));
                    }
                    return this;
                }
                if (userObject instanceof CategoryParentNode) {
                    CategoryParentNode node = (CategoryParentNode)userObject;
                    this.setIcon(node.getIcon());
                    this.setDisabledIcon(this.createGrayIcon(this.getIcon()));
                    this.setText(node.getName());
                    return this;
                }
            }
            this.setIcon((Icon)new NullIcon(0, 0));
            this.setDisabledIcon(this.getIcon());
            this.setText(null);
            return this;
        }

        private Icon createGrayIcon(Icon icon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }

        private TreeCellRendererImpl() {
        }

        TreeCellRendererImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 2
    implements TreeSelectionListener {
        private final /* synthetic */ ChangeListener v$l;
        final /* synthetic */ CVSTagTreeView this$0;

        public void valueChanged(TreeSelectionEvent e) {
            this.v$l.stateChanged(new ChangeEvent(this));
        }

        public 2(CVSTagTreeView cVSTagTreeView, ChangeListener changeListener) {
            this.v$l = changeListener;
            this.this$0 = cVSTagTreeView;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeafNodeIterator
    implements Iterator<TreeNode> {
        private TreeNode _next;
        private LinkedList<TreeNode> _nodes;
        private LinkedList<TreeNode> _containerStack;

        private void $init$() {
            this._nodes = new LinkedList();
            this._containerStack = new LinkedList();
        }

        LeafNodeIterator(TreeModel model) {
            this.$init$();
            this._containerStack.add((TreeNode)model.getRoot());
            this._next();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public TreeNode next() {
            TreeNode next = this._next;
            this._next();
            return next;
        }

        private void _next() {
            if (!this._nodes.isEmpty()) {
                this._next = this._nodes.removeFirst();
                return;
            }
            if (this._containerStack.isEmpty()) {
                this._next = null;
                return;
            }
            TreeNode containerNode = this._containerStack.removeFirst();
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            Enumeration<? extends TreeNode> e = containerNode.children();
            while (e.hasMoreElements()) {
                nodes.add(e.nextElement());
            }
            Collections.reverse(nodes);
            for (TreeNode node : nodes) {
                if (((DefaultMutableTreeNode)node).getUserObject() instanceof CVSTagNode) {
                    this._nodes.addFirst(node);
                    continue;
                }
                this._containerStack.addFirst(node);
            }
            this._next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class CategoryParentNode {
        private final String _name;
        private final Icon _icon;

        CategoryParentNode(String name, Icon icon) {
            this._name = name;
            this._icon = icon;
        }

        String getName() {
            return this._name;
        }

        Icon getIcon() {
            return this._icon;
        }
    }
}

