/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.login;

import java.awt.Component;
import java.awt.Container;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSClientInfo;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSAccessPServer;
import oracle.jdevimpl.vcs.cvs.client.CVSRootConversion;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.error.CVSAccessException;
import oracle.jdevimpl.vcs.cvs.error.CVSLoginException;
import oracle.jdevimpl.vcs.cvs.error.CVSServerException;
import oracle.jdevimpl.vcs.cvs.login.CVSAbstractMethod;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSPasswordDialogUI;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSVersionNumber;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSConnection;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSLogStream;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSPServerConnection;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSScramble;

final class CVSPServerMethod
extends CVSAbstractMethod {
    private CVSAccessPServer _access;

    private void $init$() {
        if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
            OCVSLogStream._clientStream = System.out;
            OCVSLogStream._serverStream = System.err;
        }
    }

    CVSPServerMethod() {
        this.$init$();
    }

    protected void doLoginSpi(CVSRootString root, Component parent, Map connectionModel, VCSExceptionHandler exceptionHandler) throws VCSException {
        this.doPServerLogin(root, parent, connectionModel, exceptionHandler);
    }

    protected void doLogoutSpi(CVSRootString root) throws VCSException {
        if (this._access == null) {
            return;
        }
        this.doPServerLogout(root);
    }

    protected void doLogoutAllSpi() {
        if (this._access == null) {
            return;
        }
        try {
            this.getPServerImplementation().deletePassFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected boolean isLoggedInSpi(CVSRootString root) {
        try {
            boolean bl = this.getPServerImplementation().searchPassFileRoot(root.toString());
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    protected String getLoginPasswordSpi(CVSRootString root) throws Exception {
        return this.getPServerImplementation().readPassFileRoot(root.toString());
    }

    protected void clearCachedObjectsSpi() {
        this._access = null;
    }

    protected final CVSAccessPServer getPServerImplementation() {
        if (this._access != null) {
            return this._access;
        }
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        this._access = CVSAccessPServer.getGenericInstance();
        if (!CVSActiveClient.isClientCVSNT()) {
            return this._access;
        }
        if (VCSOperatingSystem.isWindows()) {
            CVSVersionNumber versionOfCvsntUsingWindowsRegistry = CVSVersionNumber.createVersionNumber("1.11.1.3", ".");
            CVSClientInfo clientInfo = CVSActiveClient.getClientInformation();
            if (clientInfo.getVersion() != null && clientInfo.getVersion().compareTo(versionOfCvsntUsingWindowsRegistry) >= 0) {
                this._access = CVSAccessPServer.getNTInstance();
            }
            return this._access;
        }
        if (VCSOperatingSystem.isOSX()) {
            this._access = CVSAccessPServer.getOSXInstance();
            return this._access;
        }
        return this._access;
    }

    private void doPServerLogin(CVSRootString root, Component parent, Map connectionModel, VCSExceptionHandler exceptionHandler) throws VCSException {
        try {
            if (this.getPServerImplementation().searchPassFileRoot(root.toString())) {
                this.doPServerLoginFinalization(root, true);
                return;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        1 dialog = new 1(this, root, parent, connectionModel);
        dialog.setExceptionHandler(exceptionHandler);
        if (!dialog.runDialog()) {
            throw new VCSCancelException();
        }
    }

    private void _validatePServerPassword(CVSRootString root, String password) throws Exception {
        boolean success = false;
        try {
            try {
                PServerLoginWorker worker = new PServerLoginWorker(root, password, null);
                worker.run();
                PServerLoginWorker.mav$forceException(worker);
                success = true;
            }
            catch (UnknownHostException uhe) {
                throw new CVSAccessException(CVSArb.getString(705));
            }
            catch (InterruptedIOException iioe) {
                iioe.printStackTrace();
                throw new CVSAccessException(CVSArb.getString(379));
            }
            catch (SocketException se) {
                Assert.printStackTrace((Throwable)se);
                throw new CVSAccessException(CVSArb.getString(348), se.toString());
            }
            catch (CVSLoginException le) {
                throw new CVSAccessException(CVSArb.getString(208));
            }
            catch (CVSServerException se) {
                throw new CVSAccessException(CVSArb.getString(208), se.getMessage());
            }
            catch (Exception e) {
                throw e;
            }
        }
        finally {
            this.doPServerLoginFinalization(root, success);
        }
    }

    private final void doPServerLoginFinalization(CVSRootString root, boolean success) {
        this.indicateLoginSuccess(root, success);
        CVSUtil.clearPerformanceCaches();
        CVSConnectionNodes.updateOverlays();
    }

    private final void doPServerLogout(CVSRootString root) throws VCSException {
        boolean success = false;
        try {
            try {
                this.getPServerImplementation().deletePassFileRoot(root.toString());
                success = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.doPServerLogoutFinalization(root, success);
                return;
            }
        }
        finally {
            this.doPServerLogoutFinalization(root, success);
        }
    }

    private final void doPServerLogoutFinalization(CVSRootString root, boolean success) {
        this.indicateLogoutSuccess(root, success);
        CVSUtil.clearPerformanceCaches();
        CVSConnectionNodes.updateOverlays();
    }

    private void indicateLoginSuccess(CVSRootString root, boolean success) {
        if (!success) {
            return;
        }
        String connection = CVSConnectionNodes.getConnectionListAPI().getRootConnection(root.toString());
        if (connection == null) {
            return;
        }
        Ide.getStatusBar().setText(CVSArb.format(2, new Object[]{connection}));
    }

    private void indicateLogoutSuccess(CVSRootString root, boolean success) {
        if (!success) {
            return;
        }
        String connection = CVSConnectionNodes.getConnectionListAPI().getRootConnection(root.toString());
        if (connection == null) {
            return;
        }
        Ide.getStatusBar().setText(CVSArb.format(59, new Object[]{connection}));
    }

    static void mav$_validatePServerPassword(CVSPServerMethod cVSPServerMethod, CVSRootString cVSRootString, String string) {
        cVSPServerMethod._validatePServerPassword(cVSRootString, string);
    }

    final class 1
    extends PServerPasswordDialog {
        protected void validatePServerPassword(CVSRootString root, String password) throws Exception {
            CVSPServerMethod.mav$_validatePServerPassword(CVSPServerMethod.this, root, password);
        }

        public 1(CVSPServerMethod cVSPServerMethod2, CVSRootString cVSRootString, Component component, Map map) {
            super(cVSRootString, component, map, null);
        }
    }

    private abstract class PServerPasswordDialog {
        private final CVSConnectionData _connection;
        private final CVSRootString _root;
        private final Component _parent;
        private final Map _connectionModel;
        private VCSExceptionHandler _exceptionHandler;

        private PServerPasswordDialog(CVSRootString root, Component parent, Map connectionModel) {
            this._connection = CVSUtil.getRootConnection(root);
            this._root = root;
            this._parent = parent;
            this._connectionModel = connectionModel;
        }

        void setExceptionHandler(VCSExceptionHandler exceptionHandler) {
            this._exceptionHandler = exceptionHandler;
        }

        boolean runDialog() {
            String password = this.getRootPassword();
            if (password != null) {
                try {
                    if (this.isEmpty(this._root.getUserName()) || this.isEmpty(this._root.getRepository()) || this.isEmpty(this._root.getServerLocation())) {
                        throw new CVSAccessException(CVSArb.getString(44));
                    }
                    this.validatePServerPassword(this._root, password);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    VCSExceptionHandler exceptionHandler = this._exceptionHandler != null ? this._exceptionHandler : new VCSExceptionHandler();
                    exceptionHandler.handleException(e, this._parent);
                }
            }
            CVSPasswordDialogUI ui = new CVSPasswordDialogUI();
            CVSResourcePicker.getPicker(this).start((Container)ui);
            MessageFormat formatter = new MessageFormat(CVSArb.getString(289));
            ui.getPromptLabel().setText(formatter.format(new Object[]{this._root.getServerLocation()}));
            ui.getUserNameField().setText(this._root.getUserName());
            ui.getUserNameField().setEditable(false);
            ui.getRepositoryField().setText(this._root.getRepository());
            ui.getRepositoryField().setEditable(false);
            ui.getUserNameLabel().setLabelFor(ui.getUserNameField());
            ui.getRepositoryLabel().setLabelFor(ui.getRepositoryField());
            ui.getPasswordLabel().setLabelFor(ui.getPasswordField());
            ui.getAutoConnectCheckBox().setSelected(this.isConnectionAutoConnect());
            HelpSystem.getHelpSystem().registerTopic((JComponent)ui, "f1_cvslogin_html");
            JEWTDialog dialog = CVSUtil.createJEWTDialog(this._parent, ui, CVSArb.getString(564), 7);
            dialog.setInitialFocus((Component)ui.getPasswordField());
            dialog.setResizable(false);
            dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 1(this, ui)));
            return CVSDialogRunner.runDialog((JDialog)dialog);
        }

        protected abstract void validatePServerPassword(CVSRootString var1, String var2) throws Exception;

        private boolean isEmpty(String s) {
            return s == null || s.equals("");
        }

        private boolean isConnectionAutoConnect() {
            boolean autoConnect = false;
            if (this._connectionModel != null) {
                Object value = this._connectionModel.get(CVSConnectionDetailsKey.KEY_CONNECTION_AUTO_CONNECT);
                boolean bl = autoConnect = value != null && (Boolean)value != false;
            }
            if (this._connectionModel == null && this._connection != null) {
                autoConnect = this._connection.getAutoConnect();
            }
            return autoConnect;
        }

        private void setConnectionAutoConnect(boolean autoConnect) {
            if (this._connectionModel != null) {
                this._connectionModel.put(CVSConnectionDetailsKey.KEY_CONNECTION_AUTO_CONNECT, autoConnect);
            }
            if (this._connectionModel == null && this._connection != null) {
                this._connection.setAutoConnect(autoConnect);
                CVSConnectionNodes.saveConnectionList();
            }
        }

        private String getRootPassword() {
            if (this._connection != null && this._connection.getPassword() != null) {
                return this._connection.getPassword();
            }
            if (this._root.getPassword() != null) {
                return this._root.getPassword();
            }
            return null;
        }

        private boolean _doCommitOperation(CVSPasswordDialogUI ui) throws Exception {
            this.setConnectionAutoConnect(ui.getAutoConnectCheckBox().isSelected());
            String password = new String(ui.getPasswordField().getPassword());
            try {
                this.validatePServerPassword(this._root, password);
            }
            catch (Exception e) {
                ui.getPasswordField().setText("");
                throw e;
            }
            return true;
        }

        PServerPasswordDialog(CVSRootString cVSRootString, Component component, Map map, oracle.jdevimpl.vcs.cvs.login.CVSPServerMethod$1 var5_5) {
            this(cVSRootString, component, map);
        }

        static VCSExceptionHandler ra$_exceptionHandler(PServerPasswordDialog pServerPasswordDialog) {
            return pServerPasswordDialog._exceptionHandler;
        }

        static boolean mav$_doCommitOperation(PServerPasswordDialog pServerPasswordDialog, CVSPasswordDialogUI cVSPasswordDialogUI) {
            return pServerPasswordDialog._doCommitOperation(cVSPasswordDialogUI);
        }

        final class 1
        extends VCSDialogCommitter {
            private final /* synthetic */ CVSPasswordDialogUI v$ui;
            final /* synthetic */ PServerPasswordDialog this$0;

            protected boolean doCommitOperation() throws Exception {
                return PServerPasswordDialog.mav$_doCommitOperation(this.this$0, this.v$ui);
            }

            protected VCSExceptionHandler getExceptionHandler() {
                return PServerPasswordDialog.ra$_exceptionHandler(this.this$0) != null ? PServerPasswordDialog.ra$_exceptionHandler(this.this$0) : super.getExceptionHandler();
            }

            public 1(PServerPasswordDialog pServerPasswordDialog, CVSPasswordDialogUI cVSPasswordDialogUI) {
                this.v$ui = cVSPasswordDialogUI;
                this.this$0 = pServerPasswordDialog;
            }
        }
    }

    private class PServerLoginWorker
    implements Runnable {
        private CVSRootString _root;
        private String _password;
        private Exception _exception;

        private PServerLoginWorker(CVSRootString root, String password) {
            this._root = root;
            this._password = password;
            this._exception = null;
        }

        public final void run() {
            try {
                this.connectAndAuthorize(this._root, this._password);
            }
            catch (Exception e) {
                this._exception = e.getMessage() != null && e.getMessage().indexOf("unknown host") >= 0 ? new UnknownHostException(e.getMessage()) : e;
            }
        }

        private void connectAndAuthorize(CVSRootString rootString, String password) throws Exception {
            String spw = OCVSScramble.scramble((String)password);
            OCVSRoot clientRoot = CVSRootConversion.convertExtensionToClientRootPServer(rootString);
            1 command = new 1(this, null, spw);
            HashMap<OCVSOption, String> options = new HashMap<OCVSOption, String>();
            options.put(OCVSCommand.OPTION_OVERRIDE_CVSROOT, clientRoot.toString());
            options.put(OCVSCommand.OPTION_DO_NOT_EXEC_DISK, null);
            OCVSProcessIO io = new OCVSProcessIO(null, new PrintStream(new PipedOutputStream()), new PrintStream(new PipedOutputStream()));
            try {
                command.executeCommand(io, null, options, new String[0]);
            }
            catch (OCVSException ocvse) {
                throw new CVSServerException(ocvse.getMessage());
            }
            CVSPServerMethod.this.getPServerImplementation().writePassFileRoot(rootString.toString(), spw);
        }

        private void forceException() throws Exception {
            if (this._exception != null) {
                throw this._exception;
            }
        }

        PServerLoginWorker(CVSRootString cVSRootString, String string, 1 var4_4) {
            this(cVSRootString, string);
        }

        static void mav$forceException(PServerLoginWorker pServerLoginWorker) {
            pServerLoginWorker.forceException();
        }

        final class 1
        extends OCVSCommand {
            private final /* synthetic */ String v$spw;
            final /* synthetic */ PServerLoginWorker this$0;

            public String getCommandId() {
                return null;
            }

            public int executeCommand(OCVSProcessIO io, File dir, Map options, String[] arguments) throws Exception {
                OCVSRoot root = this.constructRoot(dir, options);
                if (!root.isAccessPServer()) {
                    throw new IllegalStateException();
                }
                OCVSPServerConnection connection = (OCVSPServerConnection)this.createRootConnection(root, null);
                this.openConnection((OCVSConnection)connection, root);
                if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                    connection.startLogging();
                }
                try {
                    this.authenticateUserForPServer(connection, root, true, this.v$spw);
                    int n = 0;
                    return n;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    connection.close();
                }
            }

            public 1(PServerLoginWorker pServerLoginWorker, String string, String string2) {
                this.v$spw = string2;
                this.this$0 = pServerLoginWorker;
                super(string);
            }
        }
    }
}

