/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.macro;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.util.VCSStreamUtils;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionUtils;

public class CVSMacroRevisionFile
extends MacroExpander {
    public String getMacro() {
        return "cvs.revision.file";
    }

    public String getSampleExpansion(Context context) {
        return CVSMacroRevisionFile.createSampleExpansion();
    }

    static final String createSampleExpansion() {
        try {
            File tempFile = File.createTempFile("Class1", ".java");
            String path = tempFile.getAbsolutePath();
            tempFile.delete();
            String string = path;
            return string;
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            String string = "";
            return string;
        }
    }

    public String expand(Context context) {
        if (!(context.getView() instanceof HistoryViewer)) {
            return null;
        }
        HistoryEntry historyEntry = ((HistoryViewer)context.getView()).getLeftHistoryComponent().getSingleSelection();
        return CVSMacroRevisionFile.createTemporaryRevisionFile(context, historyEntry);
    }

    static final String createTemporaryRevisionFile(Context context, HistoryEntry historyEntry) {
        if (historyEntry == null) {
            return null;
        }
        String revision = ((RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty())).getLabel();
        URL url = HistoryContext.getRealURL((Context)context);
        if (url == null) {
            return null;
        }
        try {
            CVSRevisionInfo info = CVSRevisionUtils.downloadContents(url, revision, null, true);
            File tempFile = File.createTempFile(URLFileSystem.getFileName((URL)url), URLFileSystem.getSuffix((URL)url));
            VCSStreamUtils.pipeStreamData((InputStream)new ByteArrayInputStream(info.getContents()), (OutputStream)new FileOutputStream(tempFile));
            tempFile.deleteOnExit();
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            String string = null;
            return string;
        }
    }

    public String getShortLabel() {
        return CVSArb.getString(344);
    }

    public String getLongLabel() {
        return CVSArb.getString(591);
    }
}

