/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.migration;

import java.io.File;
import oracle.ide.migration.XMLMigrator;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileConstants;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public final class CVSConnectionsMigrator
extends XMLMigrator
implements CVSConnectionFileConstants {
    static final String CVS_EXTENSION_DIRECTORY_RE = "oracle.jdeveloper.cvs.[\\.\\d]+";
    static final String JDEVELOPER_EXTENSION_DIRECTORY_RE = "oracle.jdeveloper.[\\.\\d]+";
    private static final int CVS_CONNECTIONS = 0;

    public CVSConnectionsMigrator() {
        super(new int[]{0});
    }

    public String getDescription(int category) {
        return CVSArb.getString(226);
    }

    protected String getFileName() {
        return "cvs_connect.xml";
    }

    protected String getNamespaceURI() {
        return CVSConnectionFileConstants.NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "connection_list";
    }

    public boolean canMigrate(int category, File sourceDir) {
        return super.canMigrate(category, this.getActualSourceDir(sourceDir));
    }

    protected File getSourceFile(File sourceDir, File destDir) {
        return super.getSourceFile(this.getActualSourceDir(sourceDir), destDir);
    }

    protected File getDestFile(File sourceDir, File destDir) {
        return super.getDestFile(sourceDir, this.getActualDestDir(destDir));
    }

    private File getActualSourceDir(File sourceDir) {
        File file = new File(sourceDir, "cvs_connect.xml");
        if (file.exists() && !file.isDirectory()) {
            return sourceDir;
        }
        File systemDir = sourceDir;
        if (systemDir.getName().matches(CVS_EXTENSION_DIRECTORY_RE)) {
            systemDir = systemDir.getParentFile();
        }
        File[] contents = systemDir.listFiles();
        int i = 0;
        while (i < contents.length) {
            if (contents[i].getName().matches(JDEVELOPER_EXTENSION_DIRECTORY_RE) && (file = new File(contents[i], "cvs_connect.xml")).exists() && !file.isDirectory()) {
                return contents[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < contents.length) {
            if (contents[i2].getName().matches(CVS_EXTENSION_DIRECTORY_RE) && (file = new File(contents[i2], "cvs_connect.xml")).exists() && !file.isDirectory()) {
                return contents[i2];
            }
            ++i2;
        }
        return sourceDir;
    }

    private File getActualDestDir(File destDir) {
        if (destDir.getName().matches(CVS_EXTENSION_DIRECTORY_RE)) {
            return destDir;
        }
        File systemDir = destDir;
        if (systemDir.getName().matches(JDEVELOPER_EXTENSION_DIRECTORY_RE)) {
            systemDir = systemDir.getParentFile();
        }
        File[] contents = systemDir.listFiles();
        int i = 0;
        while (i < contents.length) {
            if (contents[i].getName().matches(CVS_EXTENSION_DIRECTORY_RE) && contents[i].isDirectory()) {
                return contents[i];
            }
            ++i;
        }
        return destDir;
    }
}

