/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.migration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import oracle.ide.config.ClientSetting;
import oracle.ide.migration.ExtensionMigrator;

public class CVSExtensionMigrator
extends ExtensionMigrator {
    protected String getExtensionID() {
        return "oracle.jdeveloper.cvs";
    }

    public boolean canMigrate(int category, File sourceDir) {
        return super.canMigrate(category, sourceDir);
    }

    protected File getSourceFile(File sourceDir) {
        return super.getSourceFile(this.getActualSourceDir(sourceDir));
    }

    protected List getSettingKeys() {
        Object[] keys = new Object[]{"cvs_versioning_properties", "cvs_system_properties", "cvs_version_tool_properties", "cvs_command_options", "cvs_label_decorations"};
        return Arrays.asList(keys);
    }

    public String[] migrate(File sourceDir, File destDir) {
        String[] errors = super.migrate(sourceDir, destDir);
        if (errors == null || errors.length <= 0) {
            try {
                ClientSetting.findOrCreate((String)this.getExtensionID()).save();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return errors;
    }

    private File getActualSourceDir(File sourceDir) {
        File file = new File(sourceDir, "preferences.xml");
        if (file.exists() && !file.isDirectory()) {
            return sourceDir;
        }
        File systemDir = sourceDir;
        if (systemDir.getName().matches("oracle.jdeveloper.cvs.[\\.\\d]+")) {
            systemDir = systemDir.getParentFile();
        }
        File[] contents = systemDir.listFiles();
        int i = 0;
        while (i < contents.length) {
            if (contents[i].getName().matches("oracle.jdeveloper.[\\.\\d]+") && (file = new File(contents[i], "preferences.xml")).exists() && !file.isDirectory()) {
                return contents[i];
            }
            ++i;
        }
        return sourceDir;
    }
}

