/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.util.Map;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListModel;

public final class CVSConnectionData
implements CVSConnectionDetailsKey {
    public static final String IDE_ENCODING = "ide-encoding";
    private String _name;
    private CVSConnectionListModel _model;
    private CVSConnectionFileData[] _moduleFileData;

    CVSConnectionData(String name, CVSConnectionListModel model) {
        this._name = name;
        this._model = model;
    }

    void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name != null ? this._name : "";
    }

    public String getRoot() {
        Object o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT);
        return o != null ? o.toString() : "";
    }

    public String getCVSRsh() {
        Object o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_SET_RSH);
        if (o == null || !((Boolean)o).booleanValue()) {
            return "";
        }
        o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_RSH);
        return o != null ? o.toString() : "";
    }

    public String getCVSServer() {
        Object o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_SET_SERVER);
        if (o == null || !((Boolean)o).booleanValue()) {
            return "";
        }
        o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_SERVER);
        return o != null ? o.toString() : "";
    }

    public boolean isEditable() {
        Object o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_EDITABLE);
        return o != null ? (Boolean)o : true;
    }

    public String getPassword() {
        Object o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_PASSWORD);
        return o != null ? o.toString() : null;
    }

    public Map getDetails() {
        return this._model.getValues(this._name);
    }

    public void setAutoConnect(boolean autoConnect) {
        Map details = this.getDetails();
        details.put(CVSConnectionDetailsKey.KEY_CONNECTION_AUTO_CONNECT, new Boolean(autoConnect));
        this._model.setValues(this._name, details);
    }

    public boolean getAutoConnect() {
        Object o = this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_AUTO_CONNECT);
        return o != null && (Boolean)o != false;
    }

    public void setEncoding(String charsetName) {
        Map details = this.getDetails();
        if (charsetName == null) {
            details.remove(CVSConnectionDetailsKey.KEY_CONNECTION_ENCODING);
        } else {
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_ENCODING, charsetName);
        }
        this._model.setValues(this._name, details);
    }

    public String getEncoding() {
        String charsetName = (String)this.getDetails().get(CVSConnectionDetailsKey.KEY_CONNECTION_ENCODING);
        return charsetName != null && charsetName.equals(IDE_ENCODING) ? IdeUtil.getIdeEncoding() : charsetName;
    }

    public void setModuleFileData(CVSConnectionFileData[] moduleFileData) {
        this._moduleFileData = moduleFileData;
    }

    public CVSConnectionFileData[] getModuleFileData() {
        return this._moduleFileData;
    }
}

