/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilePathUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionLsSupportCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServices;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

class CVSConnectionDefaultServices
extends CVSConnectionServices {
    CVSConnectionDirectoryData[] getRootDirectoryList(String root) throws Exception {
        CVSConnectionFileData[] lsFileData = this.ls(root, ".", false);
        if (lsFileData != null) {
            return (CVSConnectionDirectoryData[])VCSCollectionUtils.toArrayType(Arrays.asList(lsFileData), CVSConnectionDirectoryData.class);
        }
        throw new UnsupportedOperationException();
    }

    CVSConnectionModuleData[] getModuleList(String root) throws Exception {
        ArrayList moduleData = new ArrayList();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        runner.setCmdArray(new String[]{"co", "-c"});
        runner.getParameters().setRoot(root);
        runner.addOutputMonitor(new 1(this, moduleData));
        JSchAuthFailStreamMonitor jschAuthFailStreamMonitor = new JSchAuthFailStreamMonitor();
        runner.addErrorMonitor(jschAuthFailStreamMonitor);
        this.debugCommand(runner.getCmdList());
        runner.exec();
        if (jschAuthFailStreamMonitor.isAuthFailed()) {
            throw new JSchAuthFailException();
        }
        this.debugEOF();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            if (runner.getErrorText() != null) {
                Assert.println((String)"CVS:");
                Assert.println((String)runner.getErrorText());
            }
            throw new VCSCancelException();
        }
        return moduleData.toArray(new CVSConnectionModuleData[0]);
    }

    CVSConnectionFileData[] getDirectoryList(String root, String path) throws Exception {
        CVSConnectionFileData[] lsFileData = this.ls(root, path, true);
        if (lsFileData != null) {
            return lsFileData;
        }
        ArrayList fileData = new ArrayList();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        runner.setCmdArray(new String[]{"rdiff", "-D", "1970-01-01", "-s", path});
        runner.getParameters().setRoot(root);
        runner.addOutputMonitor(new 2(this, fileData));
        runner.addErrorMonitor(new 3(this, fileData));
        this.debugCommand(runner.getCmdList());
        runner.exec();
        this.debugEOF();
        return fileData.toArray(new CVSConnectionFileData[0]);
    }

    byte[] getRevisionContents(CVSConnectionFileURL url) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList("rdiff", "-D", "1970-01-01"));
        String revision = url.getRevision();
        if (revision != null) {
            cmd.addAll(Arrays.asList("-r", revision));
        }
        cmd.add(url.getPath());
        runner.getParameters().setQuiet(true);
        runner.setCmdList(cmd);
        runner.getParameters().setRoot(url.getRoot());
        StringBuffer stringBuffer = new StringBuffer();
        runner.addOutputMonitor(new 4(this, stringBuffer));
        this.debugCommand(runner.getCmdList());
        runner.exec();
        this.debugEOF();
        return stringBuffer.toString().getBytes();
    }

    protected CVSConnectionFileData[] ls(String root, String path, boolean recursive) throws Exception {
        if (!CVSActiveClient.isClientLsSupported()) {
            return null;
        }
        if (CVSConnectionLsSupportCache.has(root) && !CVSConnectionLsSupportCache.get(root)) {
            return null;
        }
        ArrayList fileData = new ArrayList();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("ls");
        cmd.add("-e");
        if (recursive) {
            cmd.add("-R");
        }
        cmd.add(path);
        runner.setCmdList(cmd);
        runner.getParameters().setRoot(root);
        runner.addOutputMonitor(new 5(this, path, fileData));
        JSchAuthFailStreamMonitor jschAuthFailStreamMonitor = new JSchAuthFailStreamMonitor();
        runner.addErrorMonitor(jschAuthFailStreamMonitor);
        this.debugCommand(runner.getCmdList());
        runner.exec();
        if (jschAuthFailStreamMonitor.isAuthFailed()) {
            throw new JSchAuthFailException();
        }
        this.debugEOF();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            if (runner.getErrorText() != null) {
                Assert.println((String)runner.getErrorText());
            }
            if (!CVSConnectionLsSupportCache.has(root)) {
                CVSConnectionLsSupportCache.cache(root, false);
            }
            return null;
        }
        CVSConnectionLsSupportCache.cache(root, true);
        return fileData.toArray(new CVSConnectionFileData[0]);
    }

    private void debugCommand(Collection cmd) {
        this.debug("> " + cmd);
    }

    private void debugSystemOut(String s) {
        this.debug("out> " + s);
    }

    private void debugSystemErr(String s) {
        this.debug("err> " + s);
    }

    private void debugEOF() {
        this.debug("EOF");
    }

    private void debug(String s) {
        if (Boolean.getBoolean("jdev.cvs.debugbrowser")) {
            Assert.println((String)s);
        }
    }

    CVSConnectionDefaultServices() {
    }

    static void mav$debugSystemOut(CVSConnectionDefaultServices cVSConnectionDefaultServices, String string) {
        cVSConnectionDefaultServices.debugSystemOut(string);
    }

    static void mav$debugSystemErr(CVSConnectionDefaultServices cVSConnectionDefaultServices, String string) {
        cVSConnectionDefaultServices.debugSystemErr(string);
    }

    final class 1
    extends CVSProcessStreamMonitor {
        private final Pattern _pattern;
        private final /* synthetic */ Collection v$moduleData;
        final /* synthetic */ CVSConnectionDefaultServices this$0;

        private void $init$() {
            this._pattern = Pattern.compile("^([\\S&&[^\\&]]\\S*).*");
        }

        protected void streamLine(String line, CVSProcess process) throws Exception {
            CVSConnectionDefaultServices.mav$debugSystemOut(this.this$0, line);
            Matcher matcher = this._pattern.matcher(line);
            if (!matcher.matches()) {
                return;
            }
            this.v$moduleData.add(new CVSConnectionModuleData(matcher.group(1)));
        }

        public 1(CVSConnectionDefaultServices cVSConnectionDefaultServices, Collection collection) {
            this.v$moduleData = collection;
            this.this$0 = cVSConnectionDefaultServices;
            this.$init$();
        }
    }

    final class 2
    extends CVSProcessStreamMonitor {
        private final Pattern _pattern;
        private final /* synthetic */ Collection v$fileData;
        final /* synthetic */ CVSConnectionDefaultServices this$0;

        private void $init$() {
            this._pattern = Pattern.compile("File (.*) is new; current revision (.*)");
        }

        protected void streamLine(String line, CVSProcess process) throws Exception {
            CVSConnectionDefaultServices.mav$debugSystemOut(this.this$0, line);
            Matcher matcher = this._pattern.matcher(line);
            if (!matcher.matches()) {
                return;
            }
            String path = CVSConnectionFilePathUtils.canonicalizePath(matcher.group(1));
            this.v$fileData.add(new CVSConnectionFileData(path, matcher.group(2)));
        }

        public 2(CVSConnectionDefaultServices cVSConnectionDefaultServices, Collection collection) {
            this.v$fileData = collection;
            this.this$0 = cVSConnectionDefaultServices;
            this.$init$();
        }
    }

    final class 3
    extends CVSProcessStreamMonitor {
        private final Pattern _pattern;
        private final /* synthetic */ Collection v$fileData;
        final /* synthetic */ CVSConnectionDefaultServices this$0;

        private void $init$() {
            this._pattern = Pattern.compile(".*\\p{Alpha}+: Diffing (.*)");
        }

        protected void streamLine(String line, CVSProcess process) throws Exception {
            CVSConnectionDefaultServices.mav$debugSystemErr(this.this$0, line);
            Matcher matcher = this._pattern.matcher(line);
            if (!matcher.matches()) {
                return;
            }
            String path = CVSConnectionFilePathUtils.canonicalizePath(matcher.group(1));
            this.v$fileData.add(new CVSConnectionDirectoryData(path));
        }

        public 3(CVSConnectionDefaultServices cVSConnectionDefaultServices, Collection collection) {
            this.v$fileData = collection;
            this.this$0 = cVSConnectionDefaultServices;
            this.$init$();
        }
    }

    final class 4
    extends CVSProcessStreamMonitor {
        private final /* synthetic */ StringBuffer v$stringBuffer;
        final /* synthetic */ CVSConnectionDefaultServices this$0;

        protected void streamLine(String line, CVSProcess process) throws Exception {
            CVSConnectionDefaultServices.mav$debugSystemOut(this.this$0, line);
            if (!line.startsWith("+")) {
                return;
            }
            if (line.length() > 2) {
                this.v$stringBuffer.append(line.substring(2));
            }
            this.v$stringBuffer.append('\n');
        }

        public 4(CVSConnectionDefaultServices cVSConnectionDefaultServices, StringBuffer stringBuffer) {
            this.v$stringBuffer = stringBuffer;
            this.this$0 = cVSConnectionDefaultServices;
        }
    }

    final class 5
    extends CVSProcessStreamMonitor {
        private final Pattern _pattern;
        private final /* synthetic */ String v$path;
        private String _path;
        private final /* synthetic */ Collection v$fileData;
        final /* synthetic */ CVSConnectionDefaultServices this$0;

        private void $init$() {
            this._pattern = Pattern.compile("Directory (.+)");
            this._path = this.v$path;
        }

        protected void streamLine(String line, CVSProcess process) throws Exception {
            CVSConnectionDefaultServices.mav$debugSystemOut(this.this$0, line);
            Matcher matcher = this._pattern.matcher(line);
            if (matcher.matches()) {
                this._path = matcher.group(1).trim();
                return;
            }
            CVSEntry entry = CVSEntry.parseEntrySpec(line);
            if (entry == null) {
                return;
            }
            String path0 = CVSConnectionFilePathUtils.canonicalizePath(this._path.equals(".") ? entry.getName() : this._path + '/' + entry.getName());
            if (entry.isDirectory()) {
                this.v$fileData.add(new CVSConnectionDirectoryData(path0));
            } else {
                this.v$fileData.add(new CVSConnectionFileData(path0, entry.getRevision()));
            }
        }

        public 5(CVSConnectionDefaultServices cVSConnectionDefaultServices, String string, Collection collection) {
            this.v$fileData = collection;
            this.v$path = string;
            this.this$0 = cVSConnectionDefaultServices;
            this.$init$();
        }
    }

    protected class JSchAuthFailException
    extends Exception {
        JSchAuthFailException() {
        }
    }

    protected class JSchAuthFailStreamMonitor
    extends CVSProcessStreamMonitor {
        private boolean _authFailed;

        JSchAuthFailStreamMonitor() {
        }

        protected void streamLine(String line, CVSProcess process) throws Exception {
            if (line.indexOf("JSch: Auth fail") >= 0 || line.indexOf("JSch: Auth cancel") >= 0) {
                this._authFailed = true;
            }
        }

        boolean isAuthFailed() {
            return this._authFailed;
        }
    }
}

