/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionContext;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDefaultServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilePathUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilterableContainer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServicesFactory;

class CVSConnectionDirectoryNode
extends CVSConnectionFilterableContainer
implements CVSConnectionElement,
CVSConnectionContext {
    private final CVSConnectionNodeCache _cache;
    private final CVSConnectionDirectoryData _data;

    CVSConnectionDirectoryNode(CVSConnectionNodeCache cache, CVSConnectionDirectoryData data, URL url) {
        super(url);
        this._cache = cache;
        this._data = data;
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    public Object getData() {
        return this._data;
    }

    public Icon getIcon() {
        return CVSConnectionElement.DIRECTORY_ICON;
    }

    public String getToolTipText() {
        return this._data.getPath();
    }

    public String getShortLabel() {
        return this._data.getFileName();
    }

    protected void openImpl() throws IOException {
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        if (!client.isClientAvailable()) {
            UpdateMessage.fireObjectClosed((Subject)this);
            throw new CVSConnectionListNode.ClientIOException();
        }
        if (this._cache.find(this._data.getPath()) == null) {
            try {
                this.requeryChildren();
            }
            catch (CVSConnectionDefaultServices.JSchAuthFailException jschafe) {
                this.forceConnectionNodeToCollapse();
                return;
            }
            catch (Exception e) {
                CVSClient.getInstance().getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
                this.forceConnectionNodeToCollapse();
                return;
            }
        }
        super.openImpl();
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._cache.uncache(this._data.getPath());
        this.uncacheAllChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                Iterator iterator = this.createFilteredChildIterator(new ArrayList(this._children).iterator());
                return iterator;
            }
        }
        catch (CVSConnectionListNode.ClientIOException clientIOException) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public CVSConnectionData getConnection() {
        return this._cache.getConnectionNode().getConnection();
    }

    protected final CVSConnectionNodeCache getNodeCache() {
        return this._cache;
    }

    protected final String getRoot() {
        return this.getConnection().getRoot();
    }

    protected final CVSConnectionDirectoryNode createDirectoryNode(CVSConnectionDirectoryData directoryData) {
        URL url = this.createConnectionFileURL(directoryData.getPath(), null);
        CVSConnectionDirectoryNode directoryNode = new CVSConnectionDirectoryNode(this._cache, directoryData, url);
        return directoryNode;
    }

    private void forceConnectionNodeToCollapse() {
        CVSConnectionNode connectionNode = this._cache.getConnectionNode();
        UpdateMessage.fireObjectClosed((Subject)this);
        EventQueue.invokeLater(new 1());
        connectionNode.forceNodeToCollapse();
    }

    private void requeryChildren() throws Exception {
        this.uncacheAllChildren();
        this._cache.cache(this._data.getPath(), (Element)this);
        try {
            this.performQuery();
        }
        catch (Exception e) {
            this._cache.uncache(this._data.getPath());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncacheAllChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
        }
        Iterator itr = this._cache.iterator();
        while (itr.hasNext()) {
            String path = (String)itr.next();
            if (!CVSConnectionFilePathUtils.isBasePathFor(this._data.getPath(), path) || this._data.getPath().equals(path)) continue;
            this._cache.uncache(path);
        }
    }

    protected void performQuery() throws Exception {
        CVSConnectionServices services = CVSConnectionServicesFactory.createServices(this.getRoot());
        CVSConnectionFileData[] fileData = null;
        try {
            fileData = services.getDirectoryList(this.getRoot(), this._data.getPath());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        for (CVSConnectionFileData fileDataItem : Arrays.asList(fileData)) {
            if (fileDataItem.isDirectory()) {
                this.createCachedDirectoryNode((CVSConnectionDirectoryData)fileDataItem);
                continue;
            }
            this.createCachedFileNode(fileDataItem);
        }
    }

    private void createCachedFileNode(CVSConnectionFileData fileData) {
        String path = fileData.getPath();
        URL url = this.createConnectionFileURL(path, fileData.getRevision());
        CVSConnectionFileNode fileNode = new CVSConnectionFileNode(this._cache, fileData, url);
        this._cache.cache(path, (Element)fileNode);
        this.addNodeToParent((Element)fileNode);
    }

    private void createCachedDirectoryNode(CVSConnectionDirectoryData directoryData) {
        this.findOrCreateDirectoryNode(directoryData);
    }

    private CVSConnectionDirectoryNode findOrCreateDirectoryNode(CVSConnectionDirectoryData directoryData) {
        String path = directoryData.getPath();
        Element e = this._cache.find(path);
        if (e != null) {
            Assert.check((boolean)(e instanceof CVSConnectionDirectoryNode));
            return (CVSConnectionDirectoryNode)e;
        }
        CVSConnectionDirectoryNode moduleNode = this.createDirectoryNode(directoryData);
        this._cache.cache(path, (Element)moduleNode);
        this.addNodeToParent((Element)moduleNode);
        return moduleNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeToParent(Element e) {
        String path = ((CVSConnectionFileData)e.getData()).getPath();
        String parent = CVSConnectionFilePathUtils.getParent(path);
        CVSConnectionDirectoryNode parentDirectoryNode = this.findOrCreateDirectoryNode(new CVSConnectionDirectoryData(parent));
        if (parentDirectoryNode != null) {
            ArrayList arrayList = parentDirectoryNode._children;
            synchronized (arrayList) {
                parentDirectoryNode._children.add(e);
            }
        }
    }

    private URL createConnectionFileURL(String path, String revision) {
        try {
            URL uRL = CVSConnectionFileURL.toURL(this.getRoot(), path, revision);
            return uRL;
        }
        catch (MalformedURLException murle) {
            Assert.printStackTrace((Throwable)murle);
            URL uRL = null;
            return uRL;
        }
    }

    static void mav$setOpen(CVSConnectionDirectoryNode cVSConnectionDirectoryNode, boolean bl) {
        cVSConnectionDirectoryNode.setOpen(bl);
    }

    final class 1
    implements Runnable {
        public void run() {
            CVSConnectionDirectoryNode.mav$setOpen(CVSConnectionDirectoryNode.this, false);
        }
    }
}

