/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.Component;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.view.View;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionExplorerCellRenderer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSConnectionExplorer
extends Explorer
implements Observer {
    private JTree _tree;
    private JScrollPane _scrollPane;
    private boolean _observing;
    private Node _node;

    public Component getGUI() {
        if (this._tree == null) {
            this.createTree();
            this._scrollPane = new JScrollPane(this._tree);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    public void updateTree() {
        if (this._tree == null) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = this.buildTree();
        if (root != null) {
            treeModel.setRoot(root);
        }
        treeModel.reload();
        int numRows = this._tree.getRowCount();
        int i = numRows - 1;
        while (i >= 0) {
            this._tree.expandRow(i);
            --i;
        }
    }

    public Context getContext(EventObject event) {
        Context ctx = null;
        ctx = this._node != null ? Context.newIdeContext((Node)this._node) : Context.newIdeContext();
        ctx.setView((View)this);
        return ctx;
    }

    public void setContext(Context context) {
        Node node = context.getNode();
        if (node != null && this.isValidNode(node)) {
            this._node = node;
            this._tree = null;
        }
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                if (this._node == null) break;
                this.updateTree();
                this.startObserving();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.stopObserving();
                break;
            }
        }
    }

    private boolean isObserving() {
        return this._observing;
    }

    private void startObserving() {
        if (!this._observing && this._node != null) {
            this._node.attach((Observer)this);
            this._observing = true;
        }
    }

    private void stopObserving() {
        if (this._observing && this._node != null) {
            this._node.detach((Observer)this);
            this._observing = false;
        }
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID;
        if (this.isObserving() && this._node != null && observed == this._node && (messageID = change.getMessageID()) != UpdateMessage.CHILD_REMOVED && messageID != UpdateMessage.CHILD_ADDED && messageID != UpdateMessage.PROPERTY_SET && messageID != UpdateMessage.OBJECT_RENAMED && messageID != UpdateMessage.CHILD_RENAMED && messageID != UpdateMessage.OBJECT_OPENED && messageID != UpdateMessage.OBJECT_CLOSED && messageID != UpdateMessage.ATTRIBUTE_CHANGED) {
            this.updateTree();
        }
    }

    protected final Node getNode() {
        return this._node;
    }

    protected boolean isValidNode(Node node) {
        return node.getData() != null && node.getData() instanceof CVSConnectionData;
    }

    protected DefaultMutableTreeNode buildTree() {
        Node node = this.getNode();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(node);
        if (!this.isValidNode(node)) {
            return null;
        }
        CVSConnectionData connectionData = ((CVSConnectionNode)node).getConnection();
        if (connectionData == null) {
            return null;
        }
        this.addNode(root, CVSArb.format(334, connectionData.getName()));
        String cvsroot = connectionData.getRoot();
        if (cvsroot == null) {
            return root;
        }
        CVSRootString rootString = new CVSRootString(cvsroot);
        if (rootString.getAccessMethod() != null && !rootString.getAccessMethod().equals("")) {
            this.addNode(root, CVSArb.format(683, rootString.getAccessMethod()));
        }
        if (rootString.getUserName() != null) {
            this.addNode(root, CVSArb.format(350, rootString.getUserName()));
        }
        if (rootString.getServerLocation() != null) {
            this.addNode(root, CVSArb.format(750, rootString.getServerLocation()));
        }
        if (rootString.getPort() != null) {
            this.addNode(root, CVSArb.format(581, rootString.getPort()));
        }
        if (rootString.getRepository() != null) {
            this.addNode(root, CVSArb.format(389, rootString.getRepository()));
        }
        if (!cvsroot.equals(connectionData.getName())) {
            this.addNode(root, CVSArb.format(21, cvsroot));
        }
        return root;
    }

    protected String getAccessibleTitle(String nodeName) {
        return this.getAccessibleName();
    }

    protected String getAccessibleName() {
        Node node = this.getNode();
        if (node instanceof CVSConnectionNode) {
            return node != null ? CVSArb.format(688, node.getShortLabel()) : null;
        }
        return CVSArb.getString(55);
    }

    protected TreeCellRenderer getCellRenderer() {
        return new CVSConnectionExplorerCellRenderer();
    }

    private void createTree() {
        String accessibleName;
        this._tree = new JTree();
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        TreeCellRenderer renderer = this.getCellRenderer();
        if (renderer != null) {
            this._tree.setCellRenderer(renderer);
        }
        if ((accessibleName = this.getAccessibleName()) != null) {
            AccessibleUtils.updateAccessibleName((Accessible)this._tree, (String)accessibleName, (boolean)true);
        }
    }

    private void addNode(DefaultMutableTreeNode parent, String text) {
        parent.add(new DefaultMutableTreeNode(text));
    }
}

