/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.util.VCSStreamUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionContext;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.util.browser.DefaultBrowsable;

public class CVSConnectionFileNode
extends DefaultBrowsable
implements CVSConnectionElement,
CVSConnectionContext {
    private CVSConnectionNodeCache _cache;
    private CVSConnectionFileData _data;

    public CVSConnectionFileNode() {
    }

    CVSConnectionFileNode(CVSConnectionNodeCache cache, CVSConnectionFileData data, URL url) {
        super(url);
        this._cache = cache;
        this._data = data;
    }

    public void writeFileContents(OutputStream outputStream) throws IOException {
        VCSStreamUtils.pipeStreamData((InputStream)URLFileSystem.openInputStream((URL)this.getURL()), (OutputStream)outputStream);
    }

    public void setURL(URL newUrl) {
        super.setURL(newUrl);
        if (this._data != null) {
            return;
        }
        this._cache = null;
        try {
            CVSConnectionFileURL fileUrl = new CVSConnectionFileURL(newUrl);
            this._data = new CVSConnectionFileData(fileUrl.getPath(), fileUrl.getRevision());
        }
        catch (ParseException pe) {
            Assert.printStackTrace((Throwable)pe);
        }
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    public Object getData() {
        return this._data;
    }

    public String getToolTipText() {
        return this._data.getPath();
    }

    public String getShortLabel() {
        return CVSArb.format(538, new Object[]{this._data.getFileName(), this._data.getRevision()});
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public boolean isReadOnly() {
        return true;
    }

    public CVSConnectionData getConnection() {
        return this._cache.getConnectionNode().getConnection();
    }

    protected final CVSConnectionNodeCache getNodeCache() {
        if (this._cache != null) {
            return this._cache;
        }
        try {
            this._cache = this.getNodeCacheImpl();
        }
        catch (ParseException pe) {
            Assert.printStackTrace((Throwable)pe);
        }
        return this._cache;
    }

    protected final String getRoot() {
        return this.getConnection().getRoot();
    }

    private final CVSConnectionNodeCache getNodeCacheImpl() throws ParseException {
        CVSConnectionFileURL fileUrl = new CVSConnectionFileURL(this.getURL());
        CVSConnectionListData list = CVSConnectionNodes.getConnectionListData();
        String connectionName = list.getRootConnection(fileUrl.getRoot());
        if (connectionName == null) {
            return null;
        }
        CVSConnectionNode connectionNode = list.getConnectionNode(connectionName);
        if (connectionNode == null) {
            return null;
        }
        return connectionNode.getNodeCache();
    }
}

