/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;

public class CVSConnectionFileURL {
    private final String _root;
    private final String _path;
    private final String _revision;

    CVSConnectionFileURL(String root, String path, String revision) {
        this._root = root;
        this._path = path;
        this._revision = revision;
    }

    public CVSConnectionFileURL(URL url) throws ParseException {
        this._root = (String)new MessageFormat("[{0}]").parse(url.getHost())[0];
        this._path = url.getFile();
        this._revision = url.getRef();
    }

    public String getRoot() {
        return this._root;
    }

    public String getPath() {
        return this._path;
    }

    public String getRevision() {
        return this._revision;
    }

    URL toURL() throws MalformedURLException {
        String host = '[' + this._root + ']';
        String file = this._path;
        if (this._revision != null && !this._revision.equals("")) {
            file = file + '#' + this._revision;
        }
        return new URL("ide.scm.cvs.,v", host, file);
    }

    static final URL toURL(String root, String path, String revision) throws MalformedURLException {
        return new CVSConnectionFileURL(root, path, revision).toURL();
    }
}

