/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListModel;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectAccessMethod;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRoot;
import oracle.ocvs.OCVSRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSConnectionListAPI
extends CVSConnectionListData {
    CVSConnectionListAPI(CVSConnectionListNode owner, CVSConnectionListModel model) {
        super(owner, model);
    }

    @Override
    public Collection<String> getConnectionNames() {
        ArrayList connectionNames = new ArrayList(super.getConnectionNames());
        Iterator itr = connectionNames.iterator();
        while (itr.hasNext()) {
            if (this.isSupportedName((String)itr.next())) continue;
            itr.remove();
        }
        return Collections.unmodifiableCollection(connectionNames);
    }

    @Override
    public boolean hasConnection(String name) {
        return this.isSupportedName(name) && super.hasConnection(name);
    }

    @Override
    public Map getConnectionDetails(String name) {
        return this.isSupportedName(name) ? super.getConnectionDetails(name) : null;
    }

    @Override
    public String getConnectionRoot(String name) {
        return this.isSupportedName(name) ? super.getConnectionRoot(name) : null;
    }

    @Override
    public String getRootConnection(String root) {
        String connectionName = super.getRootConnection(root);
        return connectionName != null && this.isSupportedName(connectionName) ? connectionName : null;
    }

    @Override
    public int getConnectionCount() {
        return this.getConnectionNames().size();
    }

    @Override
    public CVSConnectionData getConnectionAPI(String name) {
        return this.isSupportedName(name) ? super.getConnectionAPI(name) : null;
    }

    public static final boolean isSupportedConnection(CVSConnectionData connection) {
        return CVSConnectionListAPI.isSupportedRoot(connection.getRoot());
    }

    public static final boolean isSupportedDetails(Map connectionDetails) {
        return connectionDetails != null && CVSConnectionListAPI.isSupportedRoot((String)connectionDetails.get(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT));
    }

    public static final boolean isSupportedRoot(String connectionRoot) {
        String accessMethodName = CVSConnectRoot.getAccessMethodName(new CVSRootString(connectionRoot).getAccessMethod());
        if (accessMethodName == null || accessMethodName.equals("")) {
            if (!CVSClient.getInstance().isUsingInternalClient()) {
                return true;
            }
            try {
                boolean bl = OCVSRoot.parseRootSpec((String)connectionRoot).isAccessFork() ^ true;
                return bl;
            }
            catch (ParseException pe) {
                boolean bl = false;
                return bl;
            }
        }
        return CVSConnectAccessMethod.getAccessOptions().contains(accessMethodName);
    }

    private boolean isSupportedName(String connectionName) {
        Map connectionDetails = super.getConnectionDetails(connectionName);
        return connectionDetails != null && CVSConnectionListAPI.isSupportedRoot((String)connectionDetails.get(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT));
    }
}

