/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListModel;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;

public class CVSConnectionListData
implements CVSConnectionDetailsKey {
    private final CVSConnectionListNode _owner;
    private final CVSConnectionListModel _model;

    CVSConnectionListData(CVSConnectionListNode owner, CVSConnectionListModel model) {
        this._owner = owner;
        this._model = model;
    }

    public CVSConnectionNode getConnectionNode(String name) {
        return this._owner.getConnectionNode(name);
    }

    public Collection getConnectionNames() {
        return Collections.unmodifiableSet(this._model.getData().keySet());
    }

    public boolean hasConnection(String name) {
        return this._model.getData().containsKey(name);
    }

    public void addConnection(CVSConnectionData data) {
        this._owner.addConnection(data);
    }

    public void addConnection(Map details) {
        this._owner.addConnection(details);
    }

    public void updateConnection(String name, CVSConnectionData update) {
        this._owner.updateConnection(name, update);
    }

    public void updateConnection(String name, Map update) {
        this._owner.updateConnection(name, update);
    }

    public void removeConnection(String name) {
        this._owner.removeConnection(name);
    }

    public Map getConnectionDetails(String name) {
        return this._model.getValues(name);
    }

    public String getConnectionRoot(String name) {
        return (String)this.getConnectionDetails(name).get(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT);
    }

    public String getRootConnection(String root) {
        CVSRootString rootstr = new CVSRootString(root);
        Iterator itr = this.getConnectionNames().iterator();
        while (itr.hasNext()) {
            String name = itr.next().toString();
            String s = this.getConnectionRoot(name);
            if (s == null || !rootstr.equals(new CVSRootString(s))) continue;
            return name;
        }
        return null;
    }

    public int getConnectionCount() {
        return this._model.size();
    }

    public CVSConnectionData getConnectionAPI(String name) {
        if (!this.hasConnection(name)) {
            return null;
        }
        CVSConnectionNode node = this.getConnectionNode(name);
        return node != null ? node.getConnection() : new CVSConnectionData(name, this._model);
    }

    CVSConnectionListAPI createConnectionListAPI() {
        return new CVSConnectionListAPI(this._owner, this._model);
    }
}

