/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileConstants;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListModel;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionObservable;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.CVSFileConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public class CVSConnectionListNode
extends DefaultContainer
implements CVSConnectionElement,
CVSConnectionDetailsKey,
CVSConnectionFileConstants {
    private URL _file;
    private final CVSConnectionListModel _model;
    private final CVSConnectionListData _data;

    private void $init$() {
        this._file = URLFactory.newFileURL((String)(ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.jdeveloper.cvs").getPath() + CVSFileConstants.separator + "cvs_connect.xml"));
        this._model = new CVSConnectionListModel();
    }

    public CVSConnectionListNode() {
        this(true);
    }

    public CVSConnectionListNode(boolean load) {
        this.$init$();
        this._data = new CVSConnectionListData(this, this._model);
        if (load) {
            this.load();
        }
    }

    public Object getData() {
        return this._data;
    }

    public Icon getIcon() {
        return CVSArb.getIcon(45);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return CVSArb.getString(117);
    }

    protected void openImpl() throws IOException {
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        if (!client.isClientAvailable()) {
            UpdateMessage.fireObjectClosed((Subject)this);
            throw new ClientIOException();
        }
        super.openImpl();
        this.createConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                Iterator iterator = new ArrayList(this._children).iterator();
                return iterator;
            }
        }
        catch (ClientIOException clientIOException) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public void saveListNode() {
        try {
            this.save(this._file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean hasConnection(String name) {
        return this._model.getData().containsKey(name);
    }

    public boolean hasConnection() {
        return this._children.size() > 0;
    }

    public void addConnection(CVSConnectionData data) {
        this.addConnection(data.getDetails());
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void addConnection(Map details) {
        this.addConnectionImpl(details, true);
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void updateConnection(String name, CVSConnectionData update) {
        this.updateConnection(name, update.getDetails());
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void updateConnection(String name, Map update) {
        this.updateConnectionImpl(name, update);
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void removeConnection(String name) {
        this.removeConnectionImpl(name);
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public final void load(URL f) throws IOException {
        if (f == null || !URLFileSystem.exists((URL)f)) {
            return;
        }
        Object2Dom o2d = Object2Dom.newInstance();
        o2d.setLogger(0, (Object2DomLogger)new 1());
        HashMap m = (HashMap)o2d.toObject(f);
        if (m == null) {
            m = new HashMap();
        }
        this._model.setData(m);
    }

    public final void save(URL f) throws IOException {
        if (f == null) {
            return;
        }
        Map m = this._model.getData();
        Object2Dom o2d = Object2Dom.newInstance();
        o2d.setNamespaceURI(CVSConnectionFileConstants.NAMESPACE_URI);
        o2d.toDocument((Object)m, "connection_list", f);
    }

    CVSConnectionListModel getListModel() {
        return this._model;
    }

    final void addConnectionImpl(Map details) {
        this.addConnectionImpl(details, true);
    }

    final void addConnectionImpl(Map details, boolean save) {
        this.addConnectionImpl(details, save, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addConnectionImpl(Map details, boolean save, boolean notify) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new 2(this, details, save));
            return;
        }
        String name = (String)details.get(CVSConnectionDetailsKey.KEY_CONNECTION_NAME);
        if (name == null || name.equals("")) {
            return;
        }
        CVSConnectionData data = new CVSConnectionData(name, this._model);
        CVSConnectionNode n = new CVSConnectionNode(data);
        this._model.setValues(name, new HashMap(details));
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.add(n);
        }
        if (notify) {
            EventQueue.invokeLater(new 3(this, n));
        }
        if (save) {
            this.saveListNode();
        }
    }

    final void updateConnectionImpl(String name, Map update) {
        this.updateConnectionImpl(name, update, true);
    }

    final void updateConnectionImpl(String name, Map update, boolean save) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new 4(this, name, update, save));
            return;
        }
        Map details = this._model.getValues(name);
        if (this.areMapsEqual(details, update)) {
            return;
        }
        String name2 = (String)update.get(CVSConnectionDetailsKey.KEY_CONNECTION_NAME);
        CVSConnectionNode n = this.getConnectionNode(name);
        if (name.equals(name2)) {
            if (n != null) {
                this.closeConnectionNode(n);
                this._model.setValues(name, update);
                UpdateMessage.fireObjectClosed((Subject)n);
            }
        } else {
            this.removeConnectionImpl(name, false, false);
            if (n != null) {
                n.getConnection().setName(name2);
            }
            this.addConnectionImpl(update, false, false);
        }
        EventQueue.invokeLater(new 5());
        if (save) {
            this.saveListNode();
        }
    }

    final void removeConnectionImpl(String name) {
        this.removeConnectionImpl(name, true);
    }

    final void removeConnectionImpl(String name, boolean save) {
        this.removeConnectionImpl(name, save, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeConnectionImpl(String name, boolean save, boolean notify) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new 6(this, name, save));
            return;
        }
        this._model.clearValues(name);
        CVSConnectionNode n = this.getConnectionNode(name);
        if (n == null) {
            return;
        }
        this.closeConnectionNode(n);
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.remove(n);
        }
        if (notify) {
            EventQueue.invokeLater(new 7(this, n));
        }
        if (save) {
            this.saveListNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CVSConnectionNode getConnectionNode(String name) {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            int i = 0;
            while (i < this._children.size()) {
                CVSConnectionNode n = (CVSConnectionNode)this._children.get(i);
                if (n.getConnection().getName().equals(name)) {
                    CVSConnectionNode cVSConnectionNode = n;
                    return cVSConnectionNode;
                }
                ++i;
            }
            CVSConnectionNode cVSConnectionNode = null;
            return cVSConnectionNode;
        }
    }

    private final void load() {
        try {
            this.load(this._file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createConnections() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
        }
        Iterator itr = this._model.getKeys();
        while (itr.hasNext()) {
            Map details = this._model.getValues((String)itr.next());
            this.addConnectionImpl(details, false);
        }
    }

    private final void closeConnectionNode(CVSConnectionNode n) {
        try {
            n.close();
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
    }

    private final boolean areMapsEqual(Map m1, Map m2) {
        if (!m1.equals(m2)) {
            return false;
        }
        for (Object key : m1.keySet()) {
            Object o = m1.get(key);
            Object o2 = m1.get(key);
            if (!(o == null || o2 == null ? o != null || o2 != null : !o.equals(o2))) continue;
            return false;
        }
        return true;
    }

    final class 1
    implements Object2DomLogger {
        public void logXMLParseException(XMLParseException e) {
        }

        public void logSAXParseException(SAXParseException e) {
        }

        public void logUnmarshalException(int line, int col, Throwable t) {
        }

        public void logOtherException(Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }

        public void logMessage(String mesg) {
        }

        public void logXMLDocument(XMLDocument document) {
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Map v$details;
        private final /* synthetic */ boolean v$save;
        final /* synthetic */ CVSConnectionListNode this$0;

        public void run() {
            this.this$0.addConnectionImpl(this.v$details, this.v$save);
        }

        public 2(CVSConnectionListNode cVSConnectionListNode, Map map, boolean bl) {
            this.v$save = bl;
            this.v$details = map;
            this.this$0 = cVSConnectionListNode;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ CVSConnectionNode v$n;
        final /* synthetic */ CVSConnectionListNode this$0;

        public void run() {
            UpdateMessage.fireChildAdded((Subject)this.this$0, (Element)this.v$n);
        }

        public 3(CVSConnectionListNode cVSConnectionListNode, CVSConnectionNode cVSConnectionNode) {
            this.v$n = cVSConnectionNode;
            this.this$0 = cVSConnectionListNode;
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ String v$name;
        private final /* synthetic */ Map v$update;
        private final /* synthetic */ boolean v$save;
        final /* synthetic */ CVSConnectionListNode this$0;

        public void run() {
            this.this$0.updateConnectionImpl(this.v$name, this.v$update, this.v$save);
        }

        public 4(CVSConnectionListNode cVSConnectionListNode, String string, Map map, boolean bl) {
            this.v$save = bl;
            this.v$update = map;
            this.v$name = string;
            this.this$0 = cVSConnectionListNode;
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            UpdateMessage.fireStructureChanged((Subject)CVSConnectionListNode.this);
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ String v$name;
        private final /* synthetic */ boolean v$save;
        final /* synthetic */ CVSConnectionListNode this$0;

        public void run() {
            this.this$0.removeConnectionImpl(this.v$name, this.v$save);
        }

        public 6(CVSConnectionListNode cVSConnectionListNode, String string, boolean bl) {
            this.v$save = bl;
            this.v$name = string;
            this.this$0 = cVSConnectionListNode;
        }
    }

    final class 7
    implements Runnable {
        private final /* synthetic */ CVSConnectionNode v$n;
        final /* synthetic */ CVSConnectionListNode this$0;

        public void run() {
            UpdateMessage.fireChildRemoved((Subject)this.this$0, (Element)this.v$n);
        }

        public 7(CVSConnectionListNode cVSConnectionListNode, CVSConnectionNode cVSConnectionNode) {
            this.v$n = cVSConnectionNode;
            this.this$0 = cVSConnectionListNode;
        }
    }

    static class ClientIOException
    extends IOException {
        ClientIOException() {
        }
    }
}

