/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.Assert;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilePathUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServicesFactory;

class CVSConnectionURLFileSystemHelper
extends URLFileSystemHelper {
    public InputStream openInputStream(URL url) throws IOException {
        CVSConnectionFileURL url2 = CVSConnectionURLFileSystemHelper.createConnectionFileURL(url);
        if (url2 == null) {
            throw new FileNotFoundException();
        }
        CVSConnectionServices services = CVSConnectionServicesFactory.createServices(url2.getRoot());
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(services.getRevisionContents(url2));
            return byteArrayInputStream;
        }
        catch (UnsupportedOperationException uoe) {
            Assert.printStackTrace((Throwable)uoe);
            throw new FileNotFoundException();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            throw new FileNotFoundException();
        }
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public String getName(URL url) {
        String filename = this.getFileName(url);
        int i = filename.indexOf(46);
        return i < 0 ? filename : filename.substring(0, i);
    }

    public String getFileName(URL url) {
        CVSConnectionFileURL url2 = CVSConnectionURLFileSystemHelper.createConnectionFileURL(url);
        return url2 != null ? CVSConnectionFilePathUtils.getFileName(url2.getPath()) : "";
    }

    public String getSuffix(URL url) {
        String fileName = this.getPath(url);
        int i = fileName.lastIndexOf(46);
        return i >= 0 ? fileName.substring(i) : "";
    }

    public String getPlatformPathName(URL url) {
        return this.getPath(url);
    }

    public String getPath(URL url) {
        CVSConnectionFileURL url2 = CVSConnectionURLFileSystemHelper.createConnectionFileURL(url);
        return url2 != null ? url2.getPath() : "";
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public boolean exists(URL url) {
        return false;
    }

    static final CVSConnectionFileURL createConnectionFileURL(URL url) {
        try {
            CVSConnectionFileURL cVSConnectionFileURL = new CVSConnectionFileURL(url);
            return cVSConnectionFileURL;
        }
        catch (ParseException pe) {
            Assert.printStackTrace((Throwable)pe);
            CVSConnectionFileURL cVSConnectionFileURL = null;
            return cVSConnectionFileURL;
        }
    }

    CVSConnectionURLFileSystemHelper() {
    }
}

