/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav.cmd;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionMenuHandler;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleNameCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.cmd.CVSAbstractConnectionCmd;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

public class CVSOpenDirectoryCmd
extends CVSAbstractConnectionCmd {
    public CVSOpenDirectoryCmd() {
        super(CVSConnectionMenuHandler.CVS_OPEN_DIRECTORY_CMD_ID);
    }

    public int doitImpl() throws Exception {
        CVSConnectionNode node = this.getContextConnectionNode();
        if (node == null) {
            return -1;
        }
        if (!node.ensureConnectionLogin()) {
            return 1;
        }
        String directoryName = this.obtainDirectoryNameFromUser();
        if (directoryName == null) {
            return 1;
        }
        IdeUtil.invokeAfterRepaint((Runnable)new 1(this, directoryName));
        return 0;
    }

    private int _doitImpl(String directoryName) throws Exception {
        TNode nodeTNode;
        TreeExplorer navigatorTreeExplorer;
        TNode directoryTNode;
        CVSConnectionNode node = this.getContextConnectionNode();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setKeepCachedFiles(true);
        runner.getParameters().setQuiet(true);
        runner.setCmdArray(new String[]{"-nq", "rdiff", "-l", "-s", "-rHEAD", directoryName});
        runner.getParameters().setRoot(node.getConnection().getRoot());
        try {
            runner.exec();
            if (runner.getExitCode() == null) {
                int n = -1;
                return n;
            }
            if (runner.getExitCode() != 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CVSArb.format(700, new Object[]{directoryName}), (String)CVSArb.getString(276), null);
                int n = -1;
                return n;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            int n = -1;
            return n;
        }
        if (!node.isOpen()) {
            node.open();
            if (!node.isOpen()) {
                return 1;
            }
        }
        Node directoryNode = null;
        Iterator itr = node.getChildren();
        while (itr.hasNext()) {
            Node c = (Node)itr.next();
            CVSConnectionFileData data = (CVSConnectionFileData)c.getData();
            if (!data.getFileName().equals(directoryName)) continue;
            directoryNode = c;
            break;
        }
        if (directoryNode != null) {
            node.remove((Element)directoryNode);
            UpdateMessage.fireChildRemoved((Subject)node, (Element)directoryNode);
        } else {
            directoryNode = node.createDirectoryNode(directoryName);
        }
        node.add((Element)directoryNode);
        UpdateMessage.fireChildAdded((Subject)node, (Element)directoryNode);
        if (this.context.getView() instanceof NavigatorWindow && (directoryTNode = navigatorTreeExplorer.searchTNodeBreadthFirst((Element)directoryNode, (nodeTNode = (navigatorTreeExplorer = ((NavigatorWindow)this.context.getView()).getTreeExplorer()).searchTNodeBreadthFirst((Element)node, navigatorTreeExplorer.getRoot())) != null ? nodeTNode : navigatorTreeExplorer.getRoot())) != null) {
            navigatorTreeExplorer.setSelected(directoryTNode);
        }
        this.putModuleNameCacheName(node.getConnection().getRoot(), directoryName);
        node.updateModuleFileData();
        return 0;
    }

    private String obtainDirectoryNameFromUser() {
        2 dialog = new 2();
        if (!dialog.show(CVSArb.getString(333), CVSArb.getString(179), "f1_cvsopenmodule_html")) {
            return null;
        }
        return dialog.getInputValue().trim();
    }

    private void putModuleNameCacheName(String root, String directoryName) {
        String[] cachedDirectoryNames = CVSConnectionModuleNameCache.getNames(root);
        if (cachedDirectoryNames != null) {
            ArrayList<String> cachedDirectoryNames0 = new ArrayList<String>(Arrays.asList(cachedDirectoryNames));
            if (!cachedDirectoryNames0.contains(directoryName)) {
                cachedDirectoryNames0.add(directoryName);
            }
            cachedDirectoryNames = cachedDirectoryNames0.toArray(new String[0]);
        } else {
            cachedDirectoryNames = new String[]{directoryName};
        }
        CVSConnectionModuleNameCache.putNames(root, cachedDirectoryNames);
    }

    static int mav$_doitImpl(CVSOpenDirectoryCmd cVSOpenDirectoryCmd, String string) {
        return cVSOpenDirectoryCmd._doitImpl(string);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ String v$directoryName;
        final /* synthetic */ CVSOpenDirectoryCmd this$0;

        public void run() {
            try {
                CVSOpenDirectoryCmd.mav$_doitImpl(this.this$0, this.v$directoryName);
            }
            catch (Exception e) {
                CVSClient.getInstance().getExceptionHandler().handleException(e);
            }
        }

        public 1(CVSOpenDirectoryCmd cVSOpenDirectoryCmd, String string) {
            this.v$directoryName = string;
            this.this$0 = cVSOpenDirectoryCmd;
        }
    }

    final class 2
    extends SimpleInputDialog {
        protected boolean validate(String input) {
            if (!(input = input.trim()).equals("") && input.indexOf(47) < 0 && input.indexOf(92) < 0) {
                return true;
            }
            MessageDialog.error((Component)this.getDialog(), (Object)CVSArb.format(353, new Object[]{input}), (String)CVSArb.getString(70), null);
            return false;
        }
    }
}

