/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.model.ContentType;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.spi.VCSWaitRunnable;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.util.SimpleChoiceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSOperationAdd
extends CVSAbstractCommand
implements CVSCommandConstants {
    private static final String CREATED_URLS_PROPERTY = "CVSOperationAdd.CREATED_URLS";

    public CVSOperationAdd() {
        super(CVSCommandConstants.OPERATION_ADD_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected CVSOperationAdd(int id) {
        super(id, VCSCommandStyle.MULTI);
    }

    protected Locatable[] getLocatablesToAdd() throws Exception {
        return this.getContextLocatables();
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToAdd();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        VCSStatus status = CVSClient.getInstance().getStatusCache().get(url);
        if (status != CVSFileStatus.STATUS_REMOVED && !URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectoryPath((URL)url)) {
            return true;
        }
        return status.isCandidate();
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToAdd();
        if (!CVSUtil.saveDirtyNodes(Arrays.asList(locatables))) {
            return 1;
        }
        VCSStatus[] statuses = new VCSStatus[]{CVSFileStatus.STATUS_UNADDED, CVSFileStatus.STATUS_REMOVED};
        Collection nodes = this.getFilteredSelection(locatables, statuses);
        if (nodes.size() <= 0) {
            return 9;
        }
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        VCSCommandState state = new VCSCommandState(invokableState, null);
        Node[] affectedNodes = null;
        if (this.getContext().getView() instanceof CVSChangeListWindow && this.isActionLocal()) {
            VCSOptionsCustomizer customizer = CVSClient.getInstance().getChangeListOptionsCustomizer();
            return this.addSilently(nodes, affectedNodes, state, customizer);
        }
        VCSOptionsCustomizer customizer = null;
        return this.add(nodes, affectedNodes, state, customizer);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.getString(174), CVSArb.getString(386));
    }

    private int addSilently(Collection nodes, Node[] affectedNodes, VCSCommandState state, VCSOptionsCustomizer customizer) {
        1 r = new 1(this, this.getExceptionHandler(), customizer, state, affectedNodes);
        Thread t = new Thread((Runnable)((Object)r), "CVS Add");
        t.start();
        return 0;
    }

    private int add(Collection nodes, Node[] affectedNodes, VCSCommandState state, VCSOptionsCustomizer customizer) throws Exception {
        JEWTDialog dialog = this.createOperationDialog(nodes);
        dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 2(this, customizer, dialog, state)));
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        this.postAdd(state, affectedNodes);
        return !dialogSuccessful ? 1 : 0;
    }

    private void postAdd(VCSCommandState state, Node[] affectedNodes) throws Exception {
        HashSet processedUrls = state.getInvokableState().getProcessedURLs();
        HashSet processedUrls2 = new HashSet();
        processedUrls2.addAll(processedUrls);
        Iterator itr = processedUrls.iterator();
        while (itr.hasNext()) {
            processedUrls2.addAll(Arrays.asList(VCSFileSystemUtils.getParentURLs((URL)((URL)itr.next()))));
        }
        processedUrls = processedUrls2;
        URL[] processedUrlArray = processedUrls.toArray(new URL[0]);
        Collection createdUrls = (Collection)state.getProperty(CREATED_URLS_PROPERTY);
        if (createdUrls != null) {
            this.fireSomeFilesCreated(createdUrls.toArray(new URL[0]));
        }
        URLFilter filter = VCSURLFilters.createSpecificURLFilter((URL[])processedUrlArray);
        CVSClient.getInstance().getStatusCache().clear(filter);
    }

    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        ArrayList<URL> existingUrls = new ArrayList<URL>(Arrays.asList(state.getInvokableState().getURLs()));
        Iterator itr = existingUrls.iterator();
        while (itr.hasNext()) {
            if (URLFileSystem.exists((URL)((URL)itr.next()))) continue;
            itr.remove();
        }
        state.setProperty(CREATED_URLS_PROPERTY, Collections.emptySet());
        if (optionsMap != null) {
            optionsMap = new HashMap(optionsMap);
        }
        DeterminateProgressMonitor monitor = this.createProgressMonitor(dialog);
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand("add");
        runner.getParameters().setQuiet(false);
        if (optionsMap != null) {
            optionsMap.keySet().retainAll(Arrays.asList(new Object[0]));
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        ArrayList<URL> urls = new ArrayList<URL>(Arrays.asList(state.getInvokableState().getURLs()));
        ArrayList<URL> ignoredUrls = new ArrayList<URL>(urls);
        CVSIgnorePatternList.filterIgnored(urls);
        ignoredUrls.removeAll(urls);
        if (!ignoredUrls.isEmpty()) {
            if (!MessageDialog.confirm((Component)IdeUtil.getMainWindow(), (Object)CVSArb.getString(686), (String)CVSArb.getString(67), null, (boolean)false)) {
                throw new VCSCancelException();
            }
            CVSIgnorePatternList.removeIgnorePatterns(ignoredUrls);
            CVSClient.getInstance().getStatusCache().clear();
        }
        3 invokable = new 3(this, state.getInvokableState(), monitor, runner);
        invokable.setProgressMonitor(monitor);
        boolean success = invokable.runInvokable();
        ArrayList createdUrls = new ArrayList(state.getInvokableState().getProcessedURLs());
        createdUrls.removeAll(existingUrls);
        state.setProperty(CREATED_URLS_PROPERTY, createdUrls);
        if (!success) {
            return false;
        }
        URL[] urls2 = state.getInvokableState().getURLs();
        int i = 0;
        while (i < urls2.length) {
            if (!URLFileSystem.isDirectoryPath((URL)urls2[i])) {
                EventQueue.invokeLater(new 4());
                break;
            }
            ++i;
        }
        return true;
    }

    protected boolean doCommitOperationImpl2(CVSRunner runner, Collection invokeUrls2) throws Exception {
        if (!CVSOperationAdd.registerUnrecognizedFileTypesUI(invokeUrls2.toArray(new URL[0]))) {
            return false;
        }
        ArrayList<URL> contentTypeUrls = new ArrayList<URL>();
        contentTypeUrls.addAll(Arrays.asList(VCSFileSystemUtils.getContentTypeURLs((URL[])invokeUrls2.toArray(new URL[0]), (ContentType)ContentType.TEXT)));
        contentTypeUrls.addAll(Arrays.asList(VCSFileSystemUtils.getContentTypeURLs((URL[])invokeUrls2.toArray(new URL[0]), null)));
        if (!contentTypeUrls.isEmpty()) {
            runner.getParameters().setOptions(this.getTextFileKeywordOptions());
            runner.getParameters().setFiles(Arrays.asList(VCSFileSystemUtils.getURLFileNames((URL[])contentTypeUrls.toArray(new URL[0]))));
            this.doInvocationImpl(runner);
        }
        contentTypeUrls.clear();
        contentTypeUrls.addAll(Arrays.asList(VCSFileSystemUtils.getContentTypeURLs((URL[])invokeUrls2.toArray(new URL[0]), (ContentType)ContentType.BINARY)));
        if (!contentTypeUrls.isEmpty()) {
            runner.getParameters().setOptions(Arrays.asList("-k", "b"));
            runner.getParameters().setFiles(Arrays.asList(VCSFileSystemUtils.getURLFileNames((URL[])contentTypeUrls.toArray(new URL[0]))));
            this.doInvocationImpl(runner);
        }
        return true;
    }

    private Collection<String> getTextFileKeywordOptions() {
        String keywordSubstitutionOption = CVSUtil.getKeywordSubtitutionOption();
        if (keywordSubstitutionOption != null) {
            return Collections.singleton(CVSUtil.prefixKeywordOption(keywordSubstitutionOption));
        }
        return Collections.emptySet();
    }

    public static final boolean registerUnrecognizedFileTypesUI(URL[] urls) {
        Map urlsByContentType = VCSFileSystemUtils.organizeURLsByContentType((URL[])urls);
        Collection unrecognizedUrls = (Collection)urlsByContentType.get(null);
        if (unrecognizedUrls == null || unrecognizedUrls.isEmpty()) {
            return true;
        }
        LinkedHashSet<String> unrecognizedExtensions = new LinkedHashSet<String>();
        Iterator itr = unrecognizedUrls.iterator();
        while (itr.hasNext()) {
            String extension = URLFileSystem.getSuffix((URL)((URL)itr.next()));
            if (extension.equals("")) continue;
            unrecognizedExtensions.add(extension);
        }
        for (String extension : unrecognizedExtensions) {
            SimpleChoiceDialog choiceDialog = new SimpleChoiceDialog(CVSArb.getString(569), CVSArb.format(410, extension), new String[]{CVSArb.getString(752), CVSArb.getString(358)}, null);
            choiceDialog.setButtonAxis(0);
            if (!choiceDialog.show()) {
                return false;
            }
            ContentType contentType = choiceDialog.getChoice() == 0 ? ContentType.TEXT : ContentType.BINARY;
            VCSFileSystemUtils.registerFileType((String)extension, (ContentType)contentType);
        }
        return true;
    }

    protected void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec();
        if (runner.getExitCode() != null && runner.getExitCode() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.getString(196), runner.getErrorText());
    }

    protected Collection createCommandOptions() {
        return null;
    }

    protected JEWTDialog createOperationDialog(Collection nodes) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.getString(125), (String)CVSArb.getString(325), (Component)CVSComponents.createFileListerComponent(nodes, false), null, (String)"f1_cvsadd_html");
    }

    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.getString(445), (Object)CVSArb.getString(730), "", 0, -1);
    }

    static final boolean ensureVersionedDir(URL dir, DeterminateProgressMonitor monitor) throws Exception {
        if (dir == null) {
            throw new CVSOperationException(CVSArb.getString(535));
        }
        if (!CVSUtil.isUnderCVS(dir)) {
            URL parent = URLFileSystem.getParent((URL)dir);
            if (parent == null) {
                throw new CVSOperationException(CVSArb.getString(535));
            }
            if (!CVSOperationAdd.ensureVersionedDir(parent, monitor)) {
                return false;
            }
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            ArrayList<String> files = new ArrayList<String>();
            files.add(URLFileSystem.getFileName((URL)dir));
            runner.setCommand("add");
            runner.getParameters().setFiles(files);
            runner.setDirURL(parent);
            runner.getParameters().setQuiet(false);
            runner.exec();
            CVSRootCache.getInstance().clear();
            CVSClient.getInstance().getStatusCache().clear(dir);
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                throw new CVSProcessException(CVSArb.getString(196), runner.getErrorText());
            }
        }
        return monitor == null || !monitor.isCanceled();
    }

    static boolean mav$doCommitOperationImpl(CVSOperationAdd cVSOperationAdd, Component component, Map map, VCSCommandState vCSCommandState) {
        return cVSOperationAdd.doCommitOperationImpl(component, map, vCSCommandState);
    }

    static void mav$postAdd(CVSOperationAdd cVSOperationAdd, VCSCommandState vCSCommandState, Node[] nodeArray) {
        cVSOperationAdd.postAdd(vCSCommandState, nodeArray);
    }

    final class 1
    extends VCSWaitRunnable {
        private final /* synthetic */ VCSCommandState v$state;
        private final /* synthetic */ Node[] v$affectedNodes;
        final /* synthetic */ CVSOperationAdd this$0;

        protected final void runImpl() throws Exception {
            CVSOperationAdd.mav$doCommitOperationImpl(this.this$0, (Component)Ide.getMainWindow(), this.getOptions(), this.v$state);
        }

        protected final void runPostOperationAWT() throws Exception {
            CVSOperationAdd.mav$postAdd(this.this$0, this.v$state, this.v$affectedNodes);
        }

        public 1(CVSOperationAdd cVSOperationAdd, VCSExceptionHandler vCSExceptionHandler, VCSOptionsCustomizer vCSOptionsCustomizer, VCSCommandState vCSCommandState, Node[] nodeArray) {
            this.v$affectedNodes = nodeArray;
            this.v$state = vCSCommandState;
            this.this$0 = cVSOperationAdd;
            super(vCSExceptionHandler, vCSOptionsCustomizer);
        }
    }

    final class 2
    extends VCSDialogCommitter {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ VCSCommandState v$state;
        final /* synthetic */ CVSOperationAdd this$0;

        protected final boolean doCommitOperation(Map options) throws Exception {
            return CVSOperationAdd.mav$doCommitOperationImpl(this.this$0, (Component)this.v$dialog, options, this.v$state);
        }

        public 2(CVSOperationAdd cVSOperationAdd, VCSOptionsCustomizer vCSOptionsCustomizer, JEWTDialog jEWTDialog, VCSCommandState vCSCommandState) {
            this.v$state = vCSCommandState;
            this.v$dialog = jEWTDialog;
            this.this$0 = cVSOperationAdd;
            super(vCSOptionsCustomizer);
        }
    }

    final class 3
    extends CVSDirectoryInvokable {
        private final /* synthetic */ DeterminateProgressMonitor v$monitor;
        private final /* synthetic */ CVSRunner v$runner;
        final /* synthetic */ CVSOperationAdd this$0;

        protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
            if (!CVSOperationAdd.ensureVersionedDir(parent, this.v$monitor)) {
                return false;
            }
            ArrayList<URL> invokeUrls2 = new ArrayList<URL>(Arrays.asList(invokeUrls));
            Iterator itr = invokeUrls2.iterator();
            while (itr.hasNext()) {
                URL url = (URL)itr.next();
                if (!URLFileSystem.isDirectoryPath((URL)url)) continue;
                if (!CVSOperationAdd.ensureVersionedDir(url, this.v$monitor)) {
                    return false;
                }
                itr.remove();
            }
            if (invokeUrls2.size() <= 0) {
                return true;
            }
            this.v$runner.setDirURL(parent);
            return this.this$0.doCommitOperationImpl2(this.v$runner, invokeUrls2);
        }

        public 3(CVSOperationAdd cVSOperationAdd, VCSDirectoryInvokableState vCSDirectoryInvokableState, DeterminateProgressMonitor determinateProgressMonitor, CVSRunner cVSRunner) {
            this.v$runner = cVSRunner;
            this.v$monitor = determinateProgressMonitor;
            this.this$0 = cVSOperationAdd;
            super(vCSDirectoryInvokableState);
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            CVSClient.invokePendingChanges();
        }
    }
}

