/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageUtil;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.spi.VCSWaitRunnable;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFileSystemAPI;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.op.CVSOperationAdd;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;
import oracle.jdevimpl.vcs.cvs.vop.CVSDisplayableTableCellRenderer;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;

public class CVSOperationCommit
extends CVSAbstractCommand {
    private static final String PREFIX_TEMP_COMMENTS = ".jdevcvs_cmt";
    private static final String SKIP_AUTO_ADD_FILES_PERSISTENCE_KEY = "CVS.AutoAddFilesOnCommitConfirm";

    public CVSOperationCommit() {
        super(CVSCommandConstants.OPERATION_COMMIT_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected CVSOperationCommit(int cmdId) {
        super(cmdId, VCSCommandStyle.MULTI);
    }

    protected Locatable[] getLocatablesToCommit() throws Exception {
        return this.getContextLocatables();
    }

    protected boolean isOpenSessionCommitSelection(Locatable[] locatables) {
        return super.isOpenSessionSelection(locatables);
    }

    protected VCSStatusFilter getStatusFilter() {
        return this.createStatusFilter(new VCSStatus[]{CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_ADDED, CVSFileStatus.STATUS_REMOVED, CVSFileStatus.STATUS_SANDBOX});
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToCommit();
        if (!this.isOpenSessionCommitSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(Locatable locatable) throws Exception {
        if (!super.isAvailableImpl(locatable)) {
            return false;
        }
        return this.isAvailableImpl(locatable, locatable.getURL());
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        return true;
    }

    private boolean isAvailableImpl(Locatable locatable, URL url) throws Exception {
        VCSStatus status = this.getStatusCache().get(url);
        if (status != CVSFileStatus.STATUS_REMOVED && !URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (locatable instanceof Node && status.isVersioned() && ((Node)locatable).isDirty()) {
            return true;
        }
        return this.getStatusFilter().accept(status);
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToCommit();
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        if (!CVSUtil.saveDirtyNodes(Arrays.asList(affectedNodes))) {
            return 1;
        }
        1 callback = new 1(this, locatables, affectedNodes);
        return this.autoAddFilesOnCommit(VCSModelUtils.convertNodesToURLs((Locatable[])locatables), callback);
    }

    private int _doitImpl(Locatable[] locatables, Node[] affectedNodes) throws Exception {
        Collection nodesPreCoalesce = this.getFilteredSelection(locatables);
        Collection nodes = this.coalesceNodesForCommit(nodesPreCoalesce);
        if (nodes.size() <= 0) {
            this.noOp();
            return 9;
        }
        Map timestampMap = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        VCSCommandState state = new VCSCommandState(invokableState, timestampMap);
        if (this.getContext().getView() instanceof CVSChangeListWindow && (this.isActionLocal() && !((CVSChangeListWindow)this.getContext().getView()).isUsingCommitDialog() || this.getContext().getBoolean("CVSClient.localActionSource"))) {
            this.getContext().setBoolean("CVSClient.localActionSource", true);
            VCSOptionsCustomizer customizer = CVSClient.getInstance().getChangeListOptionsCustomizer();
            return this.commitSilently(nodes, affectedNodes, state, customizer);
        }
        CVSOptionsCustomizer dynamicCustomizer = this.createOptionsCustomizer(nodes.toArray(new Locatable[0]));
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer((VCSOptionsCustomizer)dynamicCustomizer);
        return this.commit(nodes, affectedNodes, state, (VCSOptionsCustomizer)customizer, dynamicCustomizer);
    }

    protected Collection coalesceNodesForCommit(Collection nodes) {
        return this.coalesceNodesForFolderOperation(nodes);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.getString(668), CVSArb.getString(694));
    }

    private int commitSilently(Collection nodes, Node[] affectedNodes, VCSCommandState state, VCSOptionsCustomizer customizer) {
        2 r = new 2(this, this.getExceptionHandler(), customizer, state, affectedNodes);
        Thread t = new Thread((Runnable)((Object)r), "CVS Commit");
        t.start();
        return 0;
    }

    private int commit(Collection nodes, Node[] affectedNodes, VCSCommandState state, VCSOptionsCustomizer customizer, CVSOptionsCustomizer dynamicCustomizer) throws Exception {
        ((VCSCommentsCustomizer)customizer).setRecentCommentsModel(CVSClient.getInstance().getRecentCommentsModel());
        if (this.getContext().getView() instanceof CVSChangeListWindow && this.isActionLocal()) {
            customizer.setOptions(CVSClient.getInstance().getChangeListOptionsCustomizer().getOptions());
        } else {
            this.initializeCommentsTemplate(customizer, nodes);
        }
        JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.getString(669), (String)CVSArb.getString(78), (Component)this.createFileListerComponent(nodes), (Component)customizer.getComponent(), (String)"f1_cvscommit_html", (Component)customizer.getInitialFocusComponent());
        dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 3(this, customizer, dialog, state)));
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        if (dynamicCustomizer != null) {
            dynamicCustomizer.dispose();
        }
        this.postCommit(state, affectedNodes);
        return !dialogSuccessful ? 1 : 0;
    }

    private void postCommit(VCSCommandState state, Node[] affectedNodes) throws Exception {
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[0]);
        this.fireFileStructureChanged(processedUrlArray);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
        URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])processedUrlArray);
        CVSClient.getInstance().getStatusCache().clear(filter);
        this.fireSomeFilesDeleted(processedUrlArray);
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.COMMIT_FORCE_COMMIT, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY});
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[]{CVSOptionId.COMMON_USE_REVISION, CVSOptionId.COMMON_NO_MODULE_PROGRAMS});
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        CVSOptionsCustomizer optionsCustomizer = new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
        HashMap defaultOptionsValues = new HashMap();
        optionsCustomizer.setDefaultOptionValues(defaultOptionsValues);
        optionsCustomizer.disableUnsupportedComponents("commit", CVSOptionId.COMMIT_FORCE_COMMIT);
        return optionsCustomizer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        boolean bl;
        block13: {
            if (optionsMap != null) {
                optionsMap = new HashMap(optionsMap);
            }
            DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(dialog, CVSArb.getString(217), (Object)CVSArb.getString(39), "", 0, -1);
            String s = (String)optionsMap.get("setting_comments");
            if (s == null || s.equals("")) {
                s = CVSArb.getString(351);
            }
            URL commentFile = URLFactory.newFileURL((File)File.createTempFile(PREFIX_TEMP_COMMENTS, null));
            CVSUtil.writeFileBytes(commentFile, s.getBytes("UTF-8"));
            ArrayList<String> opts = new ArrayList<String>();
            opts.add("-F");
            opts.add(URLFileSystem.getPlatformPathName((URL)commentFile));
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            runner.setCommand("commit");
            runner.getParameters().setQuiet(false);
            if (optionsMap != null) {
                optionsMap.keySet().retainAll(Arrays.asList(new Object[]{CVSOptionId.COMMIT_FORCE_COMMIT, CVSOptionId.COMMON_USE_REVISION, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY, CVSOptionId.COMMON_NO_MODULE_PROGRAMS, CVSOptionArgument.REVISION_NAME}));
                runner.getParameters().setBuilderOptions(optionsMap);
            }
            runner.getParameters().setOptions(opts);
            state.setInvokableState(this.coalesceStateForFolderOperation(optionsMap, state.getInvokableState()));
            4 invokable = new 4(this, state.getInvokableState(), runner);
            invokable.setProgressMonitor(monitor);
            try {
                try {
                    if (invokable.runInvokable()) return true;
                    bl = false;
                    return bl;
                }
                finally {
                    if (commentFile == null) break block13;
                    URLFileSystem.delete((URL)commentFile);
                }
            }
            catch (UpToDateCheckFailedException utdcfe) {
                boolean bl2;
                block14: {
                    if (EventQueue.isDispatchThread()) {
                        EventQueue.invokeLater(new 5());
                    } else {
                        Thread commitThread = Thread.currentThread();
                        6 r = new 6(this, commitThread);
                        Thread t = new Thread((Runnable)r, "CVS Commit");
                        t.start();
                    }
                    bl2 = true;
                    if (commentFile == null) break block14;
                    URLFileSystem.delete((URL)commentFile);
                }
                return bl2;
            }
        }
        return bl;
    }

    private void upToDateCheckFailed() {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CVSArb.getString(38), (String)CVSArb.getString(219), null)) {
            return;
        }
        try {
            this.getContext().setBoolean("CVSClient.updateFromCommit", true);
            IdeAction.get((int)CVSCommandConstants.OPERATION_UPDATE_CMD_ID).performAction(this.getContext());
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec();
        if (runner.getExitCode() != null && runner.getExitCode() == 0) {
            return;
        }
        if (runner.getErrorText() != null && runner.getErrorText().indexOf("Up-to-date check failed") >= 0) {
            throw new UpToDateCheckFailedException();
        }
        throw new CVSProcessException(CVSArb.getString(159), runner.getErrorText());
    }

    private void initializeCommentsTemplate(VCSOptionsCustomizer customizer, Collection nodes) {
        String template = CVSUtil.createCommentsTemplate(nodes);
        if (template == null) {
            return;
        }
        Map options = customizer.getOptions();
        options.put("setting_comments", template);
        customizer.setOptions(options);
    }

    private Component createFileListerComponent(Collection nodes) throws Exception {
        ClientDisplayProperty statusProperty = new ClientDisplayProperty(CVSArb.getString(238), (Object)"an example outgoing status string", String.class);
        MutableVersionOperationModel opModel = VCSComponents.createFileListerModel((Collection)nodes, (DisplayProperty[])new DisplayProperty[]{statusProperty});
        URL[] urls = VCSModelUtils.convertNodesToURLs((Collection)nodes);
        VCSStatus[] statuses = CVSClient.getInstance().getStatusCache().get(urls);
        int i = 0;
        for (Object o : nodes) {
            String statusText = statuses[i] instanceof CVSFileStatus ? ((CVSFileStatus)statuses[i]).getLabel() : null;
            opModel.setProperty(i, (DisplayProperty)statusProperty, (Object)statusText);
            ++i;
        }
        VersionOperationPanel panel = new VersionOperationPanel();
        panel.getTable().setDefaultRenderer(Displayable.class, (TableCellRenderer)((Object)new CVSDisplayableTableCellRenderer(true)));
        panel.installModel((VersionOperationModel)opModel);
        return panel;
    }

    protected Collection collectAutoAddFilesURLs(URL[] urls) throws Exception {
        ArrayList<URL> urls0 = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            if (URLFileSystem.isDirectoryPath((URL)urls[i])) {
                urls0.addAll(CVSListFilesUtil.listFiles(urls[i], 5));
            } else {
                urls0.add(urls[i]);
            }
            ++i;
        }
        return urls0;
    }

    private int autoAddFilesOnCommit(URL[] urls, Runnable callback) throws Exception {
        URL[] confirmedUrls;
        Boolean automaticallyAddFiles = (Boolean)CVSClient.getInstance().getProperties().get("automatically_add_on_commit");
        if (automaticallyAddFiles != null && !automaticallyAddFiles.booleanValue()) {
            callback.run();
            return 0;
        }
        ArrayList<URL> candidateUrls = new ArrayList<URL>(this.collectAutoAddFilesURLs(urls));
        CVSIgnorePatternList.filterIgnored(candidateUrls);
        VCSStatus[] statuses = CVSClient.getInstance().getStatusCache().get(candidateUrls.toArray(new URL[0]));
        Iterator itr = candidateUrls.iterator();
        Iterator<VCSStatus> itr2 = Arrays.asList(statuses).iterator();
        while (itr.hasNext()) {
            itr.next();
            if (itr2.next() == CVSFileStatus.STATUS_UNADDED) continue;
            itr.remove();
        }
        if (candidateUrls.size() <= 0) {
            callback.run();
            return 0;
        }
        boolean showAutoAddPromptOneTime = Ide.getDTCache().getBoolean("CVS.AutomaticAddPromptOnCommit", true);
        if (showAutoAddPromptOneTime) {
            int result = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)CVSArb.getString(153), (String)CVSArb.getString(275), null, (boolean)false);
            if (result == -1) {
                return 1;
            }
            Ide.getDTCache().putBoolean("CVS.AutomaticAddPromptOnCommit", false);
            automaticallyAddFiles = result == 1;
            HashMap<String, Boolean> commandOptionsPropertyMap = new HashMap<String, Boolean>(CVSClient.getInstance().getCommandOptionsPropertyData().getMap());
            commandOptionsPropertyMap.put("automatically_add_on_commit", automaticallyAddFiles);
            CVSClient.getInstance().getCommandOptionsPropertyData().setMap(commandOptionsPropertyMap);
            if (!automaticallyAddFiles.booleanValue()) {
                callback.run();
                return 0;
            }
        }
        if (MessageDialog.getPersistence().isHidden(SKIP_AUTO_ADD_FILES_PERSISTENCE_KEY)) {
            confirmedUrls = candidateUrls.toArray(new URL[0]);
        } else {
            confirmedUrls = this.autoAddFilesOnCommitConfirm(urls, candidateUrls);
            if (confirmedUrls == null) {
                return 1;
            }
        }
        if (!CVSOperationAdd.registerUnrecognizedFileTypesUI(confirmedUrls)) {
            return 1;
        }
        return this._autoAddFilesOnCommit(confirmedUrls, callback);
    }

    private URL[] autoAddFilesOnCommitConfirm(URL[] urls, Collection candidateUrls) {
        String title = CVSArb.getString(711);
        URL[] confirmedUrls = null;
        JCheckBox optionalCheckBox = new JCheckBox();
        if (candidateUrls.size() == 1) {
            URL[] uRLArray;
            URL url = (URL)candidateUrls.iterator().next();
            String message = CVSArb.format(131, URLFileSystem.getPlatformPathName((URL)((URL)candidateUrls.iterator().next())));
            int result = MessageDialog.confirmOrCancel((Component)VCSWindowUtils.getCurrentWindow(), (Object)MessageUtil.createOptionalMessage((Object)message, (JCheckBox)optionalCheckBox), (String)title, null, (boolean)false);
            if (result == -1) {
                return null;
            }
            if (result == 1) {
                URL[] uRLArray2 = new URL[1];
                uRLArray = uRLArray2;
                uRLArray2[0] = url;
            } else {
                uRLArray = new URL[]{};
            }
            confirmedUrls = uRLArray;
        } else {
            String messageSubstring = null;
            Element[] selection = this.getContext().getSelection();
            if (messageSubstring == null && selection != null && selection.length == 1 && selection[0] instanceof Project) {
                messageSubstring = CVSArb.getString(549);
            }
            if (messageSubstring == null && urls.length == 1 && URLFileSystem.isDirectory((URL)urls[0])) {
                messageSubstring = CVSArb.format(561, URLFileSystem.getFileName((URL)urls[0]));
            }
            if (messageSubstring == null) {
                messageSubstring = CVSArb.getString(162);
            }
            String message = CVSArb.format(302, messageSubstring);
            CheckBoxListModel listModel = VCSComponents.createCheckBoxListModel((Object[])VCSModelUtils.findOrCreateNodes((URL[])candidateUrls.toArray(new URL[0])), (boolean)true);
            AutoAddFilesPanel autoAddFilesPanel = new AutoAddFilesPanel(listModel, message);
            if (AutoAddFilesPanel.showDialog(VCSWindowUtils.getCurrentWindow(), title, MessageUtil.createOptionalMessage((Object)((Object)autoAddFilesPanel), (JCheckBox)optionalCheckBox), "f1_cvsaddfilestocvs_html") == 1) {
                return null;
            }
            List selectionList = listModel.getSelectionList();
            confirmedUrls = selectionList != null ? VCSModelUtils.convertNodesToURLs((Collection)selectionList) : new URL[]{};
        }
        MessageDialog.getPersistence().setHidden(SKIP_AUTO_ADD_FILES_PERSISTENCE_KEY, optionalCheckBox.isSelected());
        return confirmedUrls;
    }

    private int _autoAddFilesOnCommit(URL[] confirmedUrls, Runnable callback) {
        7 r = new 7(this, this.getExceptionHandler(), null, confirmedUrls, callback);
        Thread t = new Thread((Runnable)((Object)r), "CVS Add on Commit");
        t.start();
        return 0;
    }

    static void mav$doInvocationImpl(CVSOperationCommit cVSOperationCommit, CVSRunner cVSRunner) {
        cVSOperationCommit.doInvocationImpl(cVSRunner);
    }

    static void mav$upToDateCheckFailed(CVSOperationCommit cVSOperationCommit) {
        cVSOperationCommit.upToDateCheckFailed();
    }

    static boolean mav$doCommitOperationImpl(CVSOperationCommit cVSOperationCommit, Component component, Map map, VCSCommandState vCSCommandState) {
        return cVSOperationCommit.doCommitOperationImpl(component, map, vCSCommandState);
    }

    static void mav$postCommit(CVSOperationCommit cVSOperationCommit, VCSCommandState vCSCommandState, Node[] nodeArray) {
        cVSOperationCommit.postCommit(vCSCommandState, nodeArray);
    }

    static int mav$_doitImpl(CVSOperationCommit cVSOperationCommit, Locatable[] locatableArray, Node[] nodeArray) {
        return cVSOperationCommit._doitImpl(locatableArray, nodeArray);
    }

    static VCSExceptionHandler mav$getExceptionHandler(CVSOperationCommit cVSOperationCommit) {
        return cVSOperationCommit.getExceptionHandler();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Locatable[] v$locatables;
        private final /* synthetic */ Node[] v$affectedNodes;
        final /* synthetic */ CVSOperationCommit this$0;

        public void run() {
            try {
                CVSOperationCommit.mav$_doitImpl(this.this$0, this.v$locatables, this.v$affectedNodes);
            }
            catch (Exception e) {
                CVSOperationCommit.mav$getExceptionHandler(this.this$0).handleException(e);
            }
        }

        public 1(CVSOperationCommit cVSOperationCommit, Locatable[] locatableArray, Node[] nodeArray) {
            this.v$affectedNodes = nodeArray;
            this.v$locatables = locatableArray;
            this.this$0 = cVSOperationCommit;
        }
    }

    final class 2
    extends VCSWaitRunnable {
        private final /* synthetic */ VCSCommandState v$state;
        private final /* synthetic */ Node[] v$affectedNodes;
        final /* synthetic */ CVSOperationCommit this$0;

        protected final void runImpl() throws Exception {
            CVSOperationCommit.mav$doCommitOperationImpl(this.this$0, (Component)Ide.getMainWindow(), this.getOptions(), this.v$state);
        }

        protected final void runPostOperationAWT() throws Exception {
            CVSOperationCommit.mav$postCommit(this.this$0, this.v$state, this.v$affectedNodes);
        }

        public 2(CVSOperationCommit cVSOperationCommit, VCSExceptionHandler vCSExceptionHandler, VCSOptionsCustomizer vCSOptionsCustomizer, VCSCommandState vCSCommandState, Node[] nodeArray) {
            this.v$affectedNodes = nodeArray;
            this.v$state = vCSCommandState;
            this.this$0 = cVSOperationCommit;
            super(vCSExceptionHandler, vCSOptionsCustomizer);
        }
    }

    final class 3
    extends VCSDialogCommitter {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ VCSCommandState v$state;
        final /* synthetic */ CVSOperationCommit this$0;

        protected final boolean doCommitOperation(Map options) throws Exception {
            return CVSOperationCommit.mav$doCommitOperationImpl(this.this$0, (Component)this.v$dialog, options, this.v$state);
        }

        public 3(CVSOperationCommit cVSOperationCommit, VCSOptionsCustomizer vCSOptionsCustomizer, JEWTDialog jEWTDialog, VCSCommandState vCSCommandState) {
            this.v$state = vCSCommandState;
            this.v$dialog = jEWTDialog;
            this.this$0 = cVSOperationCommit;
            super(vCSOptionsCustomizer);
        }
    }

    final class 4
    extends CVSDirectoryInvokable {
        private final /* synthetic */ CVSRunner v$runner;
        final /* synthetic */ CVSOperationCommit this$0;

        protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
            String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
            this.v$runner.setDirURL(parent);
            this.v$runner.getParameters().setFiles(Arrays.asList(filenames));
            CVSOperationCommit.mav$doInvocationImpl(this.this$0, this.v$runner);
            return true;
        }

        public 4(CVSOperationCommit cVSOperationCommit, VCSDirectoryInvokableState vCSDirectoryInvokableState, CVSRunner cVSRunner) {
            this.v$runner = cVSRunner;
            this.this$0 = cVSOperationCommit;
            super(vCSDirectoryInvokableState);
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            CVSOperationCommit.mav$upToDateCheckFailed(CVSOperationCommit.this);
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ Thread v$commitThread;
        final /* synthetic */ CVSOperationCommit this$0;

        public void run() {
            try {
                this.v$commitThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EventQueue.invokeLater(new 1());
        }

        public 6(CVSOperationCommit cVSOperationCommit, Thread thread) {
            this.v$commitThread = thread;
            this.this$0 = cVSOperationCommit;
        }

        final class 1
        implements Runnable {
            public void run() {
                CVSOperationCommit.mav$upToDateCheckFailed(6.this.this$0);
            }
        }
    }

    private class UpToDateCheckFailedException
    extends Exception {
        UpToDateCheckFailedException() {
        }
    }

    final class 7
    extends VCSWaitRunnable {
        private final /* synthetic */ URL[] v$confirmedUrls;
        private final /* synthetic */ Runnable v$callback;
        final /* synthetic */ CVSOperationCommit this$0;

        protected final void runImpl() throws Exception {
            int i = 0;
            while (i < this.v$confirmedUrls.length) {
                URL parentDirectoryUrl = URLFileSystem.getParent((URL)this.v$confirmedUrls[i]);
                if (!CVSOperationAdd.ensureVersionedDir(parentDirectoryUrl, null)) {
                    throw new CVSOperationException(CVSArb.format(397, URLFileSystem.getPlatformPathName((URL)parentDirectoryUrl)));
                }
                if (!CVSFileSystemAPI.executeAddRegularFile(this.v$confirmedUrls[i])) {
                    throw new CVSOperationException(CVSArb.format(397, URLFileSystem.getPlatformPathName((URL)this.v$confirmedUrls[i])));
                }
                ++i;
            }
        }

        protected final void runPostOperationAWT() throws Exception {
            this.v$callback.run();
        }

        public 7(CVSOperationCommit cVSOperationCommit, VCSExceptionHandler vCSExceptionHandler, VCSOptionsCustomizer vCSOptionsCustomizer, URL[] uRLArray, Runnable runnable) {
            this.v$callback = runnable;
            this.v$confirmedUrls = uRLArray;
            this.this$0 = cVSOperationCommit;
            super(vCSExceptionHandler, vCSOptionsCustomizer);
        }
    }

    private static class AutoAddFilesPanel
    extends SelectFilesPanel {
        public static final int OK_BUTTON = 0;
        public static final int CANCEL_BUTTON = 1;
        public static final int DLG_MAX_WIDTH = 800;
        public static final int DLG_MAX_HEIGHT = 600;
        public static final int DLG_MIN_WIDTH = 400;
        public static final int DLG_MIN_HEIGHT = 300;

        AutoAddFilesPanel(CheckBoxListModel listModel, String prompt) {
            super(listModel, true, prompt);
        }

        public static final int showDialog(Component parent, String title, Component pnl, String helpTopic) {
            int displayButtons = 3;
            if (helpTopic != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)pnl, helpTopic);
                displayButtons += 4;
            }
            JEWTDialog dialog = AutoAddFilesPanel.newDialog(parent, title, pnl, displayButtons);
            dialog.setDefaultButton(1);
            return CVSDialogRunner.runDialog((JDialog)dialog) ? 0 : 1;
        }

        private static JEWTDialog newDialog(Component parent, String title, Component pnl, int buttons) {
            JEWTDialog dlg = JEWTDialog.createDialog((Component)parent, (String)title, (int)buttons);
            dlg.setMinimumSize(400, 300);
            dlg.setMaximumInitialSize(800, 600);
            dlg.setContent(pnl);
            dlg.setResizable(true);
            return dlg;
        }
    }
}

