/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.error.CVSValidationException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSExternalClientRunner;
import oracle.jdevimpl.vcs.cvs.ui.CVSCreateRepositoryUI;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;

public class CVSOperationCreateRepository
extends CVSAbstractCommand {
    public CVSOperationCreateRepository() {
        super(CVSCommandConstants.OPERATION_CREATE_REPOSITORY_CMD_ID);
    }

    protected boolean isAvailableImpl() {
        if (CVSClient.getInstance() == null) {
            return false;
        }
        if (CVSClient.getInstance().isClientStateVerified() && !CVSClient.getInstance().isExecutableInstalled()) {
            return false;
        }
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedCommand("init");
    }

    protected int doitImpl() throws Exception {
        if (!CVSClient.getInstance().isExecutableInstalled()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)CVSArb.getString(391), (String)CVSArb.getString(380), null);
            return -1;
        }
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), CVSArb.getString(82), 7);
        CVSCreateRepositoryUI ui = new CVSCreateRepositoryUI();
        CVSResourcePicker.get().start((Container)ui);
        ui.getChooserPanel().setURL(CVSUtil.FILESYSTEM_ROOT);
        ui.getChooserPanel().setChooseFolders(true);
        ui.getCreateConnectionCheckBox().setSelected(true);
        dialog.setResizable(false);
        dialog.setContent((Component)ui);
        HelpSystem.getHelpSystem().registerTopic((JComponent)ui, "f1_cvscreatelocalrepository_html");
        dialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, ui));
        if (!CVSDialogRunner.runDialog((JDialog)dialog)) {
            return 1;
        }
        CVSExternalClientRunner runner = new CVSExternalClientRunner();
        URL url = ui.getChooserPanel().getURL();
        String repositoryPath = URLFileSystem.getPlatformPathName((URL)URLFileSystem.canonicalize((URL)url));
        runner.setDirURL(url);
        runner.getParameters().setRoot(repositoryPath);
        runner.setCommand("init");
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            throw new CVSProcessException(CVSArb.getString(296), CVSArb.getString(354), runner.getErrorText());
        }
        if (ui.getCreateConnectionCheckBox().isSelected()) {
            this.createLocalConnection(repositoryPath);
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)CVSArb.format(127, repositoryPath), (String)CVSArb.getString(286), null);
        return 0;
    }

    private void createLocalConnection(String repositoryPath) {
        repositoryPath = CVSUtil.removeTrailingFileSeparators(repositoryPath);
        CVSRootString rootstr = new CVSRootString(":local:" + repositoryPath).canonicalize();
        CVSConnectionData connection = CVSUtil.getRootConnection(rootstr);
        if (connection != null) {
            return;
        }
        String root = rootstr.toString();
        CVSConnectionListAPI list = CVSConnectionNodes.getConnectionListAPI();
        HashMap<Object, String> props = new HashMap<Object, String>();
        props.put(CVSConnectionDetailsKey.KEY_CONNECTION_NAME, root);
        props.put(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT, root);
        list.addConnection(props);
        CVSClient.getInstance().getStatusCache().clear();
        CVSConnectionNodes.updateOverlays();
        IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
        if (showNavigatorAction == null) {
            return;
        }
        EventQueue.invokeLater(new 2(this, showNavigatorAction));
    }

    static VCSExceptionHandler mav$getExceptionHandler(CVSOperationCreateRepository cVSOperationCreateRepository) {
        return cVSOperationCreateRepository.getExceptionHandler();
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ CVSCreateRepositoryUI v$ui;
        final /* synthetic */ CVSOperationCreateRepository this$0;

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            URL url;
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                return;
            }
            if (!new File(this.v$ui.getChooserPanel().getPath()).isAbsolute()) {
                this.validationFailed(543, e);
            }
            if (URLFileSystem.exists((URL)(url = VCSFileSystemUtils.getDirectoryPathURL((URL)this.v$ui.getChooserPanel().getURL())))) {
                URL[] contentsUrls;
                if (!URLFileSystem.isDirectory((URL)url)) {
                    this.validationFailed(462, e);
                }
                if ((contentsUrls = URLFileSystem.list((URL)url)) != null && contentsUrls.length > 0) {
                    this.validationFailed(470, e);
                }
            } else if (!URLFileSystem.mkdirs((URL)url)) {
                this.validationFailed(490, e);
            }
        }

        private void validationFailed(int messageResource, PropertyChangeEvent e) throws PropertyVetoException {
            CVSValidationException exception = new CVSValidationException(CVSArb.getString(messageResource));
            CVSOperationCreateRepository.mav$getExceptionHandler(this.this$0).handleException((Exception)((Object)exception));
            throw new PropertyVetoException("", e);
        }

        public 1(CVSOperationCreateRepository cVSOperationCreateRepository, CVSCreateRepositoryUI cVSCreateRepositoryUI) {
            this.v$ui = cVSCreateRepositoryUI;
            this.this$0 = cVSOperationCreateRepository;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ IdeAction v$showNavigatorAction;
        final /* synthetic */ CVSOperationCreateRepository this$0;

        public void run() {
            try {
                this.v$showNavigatorAction.performAction();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }

        public 2(CVSOperationCreateRepository cVSOperationCreateRepository, IdeAction ideAction) {
            this.v$showNavigatorAction = ideAction;
            this.this$0 = cVSOperationCreateRepository;
        }
    }
}

