/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSWaitRunnable;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSValidationException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;

public class CVSOperationGenerateKeyPair
extends CVSAbstractCommand {
    public static final URL DEFAULT_KEYFILE_URL = CVSOperationGenerateKeyPair.createDefaultKeyURL();
    private static final String DEFAULT_COMMENT = CVSArb.format(341, new Object[]{System.getProperty("user.name"), IdeUtil.getProgramName()});
    private static final URL USER_HOME_URL = URLFactory.newURL((String)System.getProperty("user.home"));
    private URL _privateKeyUrl;

    public CVSOperationGenerateKeyPair() {
        super(CVSCommandConstants.OPERATION_GENERATE_KEY_PAIR_CMD_ID);
    }

    protected boolean isAvailableImpl() throws Exception {
        return CVSClient.getInstance().isAdvancedModeSet() && CVSClient.getInstance().isUsingInternalClient();
    }

    protected int doitImpl() throws Exception {
        this._privateKeyUrl = null;
        if (!EventQueue.isDispatchThread()) {
            return this._doitImpl();
        }
        1 r = new 1(this.getExceptionHandler());
        new Thread((Runnable)((Object)r)).start();
        return 0;
    }

    private int _doitImpl() throws Exception {
        OperationGenerateKeyPairUI ui = new OperationGenerateKeyPairUI();
        ui.getRSARadioButton().setSelected(true);
        ui.getCommentTextField().setText(DEFAULT_COMMENT);
        ui.getOutputKeyfileTextField().setText(URLFileSystem.getFileName((URL)DEFAULT_KEYFILE_URL));
        JEWTDialog dialog = CVSUtil.createJEWTDialog(VCSWindowUtils.getCurrentWindow(), this.createMinimumWidthComponent(ui, 400), CVSArb.getString(323), 3);
        HelpSystem.getHelpSystem().registerTopic((JComponent)dialog.getContent(), "f1_cvsgeneratessh2keypair_html");
        dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 2(this, ui)));
        if (!CVSDialogRunner.runDialog((JDialog)dialog)) {
            return 1;
        }
        String keyName = ui.getOutputKeyfileTextField().getText();
        String comment = ui.getCommentTextField().getText();
        if (comment.equals("")) {
            comment = DEFAULT_COMMENT;
        }
        this._privateKeyUrl = CVSOperationGenerateKeyPair.createKeyURL(keyName);
        CVSInternalClientRunner runner = new CVSInternalClientRunner();
        runner.setPrompter(new 3());
        ArrayList<String> options = new ArrayList<String>();
        options.add(ui.getRSARadioButton().isSelected() ? "rsa" : "dsa");
        options.add(keyName);
        options.add(comment);
        runner.setDirURL(USER_HOME_URL);
        runner.setCommand("keygen");
        runner.getParameters().setOptions(options);
        runner.exec();
        URL publicKeyUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)this._privateKeyUrl), (String)(URLFileSystem.getFileName((URL)this._privateKeyUrl) + ".pub"));
        MessageDialog.information((Component)VCSWindowUtils.getCurrentWindow(), (Object)CVSArb.format(152, new Object[]{URLFileSystem.getPlatformPathName((URL)this._privateKeyUrl), URLFileSystem.getPlatformPathName((URL)publicKeyUrl)}), (String)CVSArb.getString(622), null);
        return 0;
    }

    public URL getGeneratedPrivateKeyURL() {
        return this._privateKeyUrl;
    }

    private static final URL createDefaultKeyURL() {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append("id_");
        nameBuffer.append(System.getProperty("user.name"));
        return CVSOperationGenerateKeyPair.createKeyURL(nameBuffer.toString().toLowerCase());
    }

    private static final URL createKeyURL(String name) {
        return URLFactory.newURL((URL)URLFactory.newFileURL((String)System.getProperty("user.home")), (String)name);
    }

    private Component createMinimumWidthComponent(Component c, int width) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(Box.createHorizontalStrut(width), "North");
        panel.add(c, "Center");
        return panel;
    }

    static URL maS$createKeyURL(String string) {
        return CVSOperationGenerateKeyPair.createKeyURL(string);
    }

    static int mav$_doitImpl(CVSOperationGenerateKeyPair cVSOperationGenerateKeyPair) {
        return cVSOperationGenerateKeyPair._doitImpl();
    }

    final class 1
    extends VCSWaitRunnable {
        protected void runImpl() throws Exception {
            CVSOperationGenerateKeyPair.mav$_doitImpl(CVSOperationGenerateKeyPair.this);
        }

        public 1(VCSExceptionHandler vCSExceptionHandler) {
            super(vCSExceptionHandler);
        }
    }

    final class 2
    extends VCSDialogCommitter {
        private final /* synthetic */ OperationGenerateKeyPairUI v$ui;
        final /* synthetic */ CVSOperationGenerateKeyPair this$0;

        protected boolean doCommitOperation() throws Exception {
            String keyName = this.v$ui.getOutputKeyfileTextField().getText();
            if (keyName.equals("")) {
                throw new CVSValidationException(CVSArb.getString(459));
            }
            File privateKeyFile = new File(keyName);
            if (privateKeyFile.getParentFile() != null) {
                throw new CVSValidationException(CVSArb.getString(557));
            }
            try {
                new File(URLFileSystem.getPlatformPathName((URL)CVSOperationGenerateKeyPair.maS$createKeyURL(keyName))).getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new CVSValidationException(CVSArb.getString(557));
            }
            return true;
        }

        public 2(CVSOperationGenerateKeyPair cVSOperationGenerateKeyPair, OperationGenerateKeyPairUI operationGenerateKeyPairUI) {
            this.v$ui = operationGenerateKeyPairUI;
            this.this$0 = cVSOperationGenerateKeyPair;
        }
    }

    final class 3
    extends CVSInternalClientRunner.Ssh2Prompter {
        protected String promptSsh2PassphraseImpl(String message, SimpleInputDialog inputDialog) {
            inputDialog.setButtonMask(1);
            return super.promptSsh2PassphraseImpl(message, inputDialog);
        }
    }

    private class OperationGenerateKeyPairUI
    extends JPanel {
        private final JLabel _keyAlgorithmLabel = new JLabel();
        private final JRadioButton _rsaRadioButton = new JRadioButton();
        private final JRadioButton _dsaRadioButton = new JRadioButton();
        private final JLabel _outputKeyfileLabel = new JLabel();
        private final JTextField _outputKeyfileTextField = new JTextField();
        private final JLabel _commentLabel = new JLabel();
        private final JTextField _commentTextField = new JTextField();

        OperationGenerateKeyPairUI() {
            Insets i = new Insets(2, 2, 2, 2);
            LayoutBuilder layoutBuilder = new LayoutBuilder();
            layoutBuilder.add((Component)this._outputKeyfileLabel, i, 4, false, true);
            layoutBuilder.nl();
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._outputKeyfileTextField, i, 2, false, false);
            layoutBuilder.addHFiller();
            layoutBuilder.nl();
            layoutBuilder.add((Component)this._keyAlgorithmLabel, i, 4, false, true);
            layoutBuilder.nl();
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._rsaRadioButton, i, 1, false, false);
            layoutBuilder.add((Component)this._dsaRadioButton, i, 1, false, false);
            layoutBuilder.addHFiller();
            layoutBuilder.nl();
            layoutBuilder.add((Component)this._commentLabel, i, 4, false, true);
            layoutBuilder.nl();
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._commentTextField, i, 3, false, true);
            layoutBuilder.nl();
            layoutBuilder.addToPanel((Container)this);
            this._outputKeyfileTextField.setColumns(20);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this._rsaRadioButton);
            bg.add(this._dsaRadioButton);
            bg = null;
            ResourceUtils.resLabel((JLabel)this._keyAlgorithmLabel, (Component)this._keyAlgorithmLabel, (String)CVSArb.getString(431));
            ResourceUtils.resButton((AbstractButton)this._rsaRadioButton, (String)CVSArb.getString(661));
            ResourceUtils.resButton((AbstractButton)this._dsaRadioButton, (String)CVSArb.getString(475));
            ResourceUtils.resLabel((JLabel)this._outputKeyfileLabel, (Component)this._outputKeyfileTextField, (String)CVSArb.getString(183));
            ResourceUtils.resLabel((JLabel)this._commentLabel, (Component)this._commentTextField, (String)CVSArb.getString(58));
        }

        public JRadioButton getRSARadioButton() {
            return this._rsaRadioButton;
        }

        public JRadioButton getDSARadioButton() {
            return this._dsaRadioButton;
        }

        public JTextField getOutputKeyfileTextField() {
            return this._outputKeyfileTextField;
        }

        public JTextField getCommentTextField() {
            return this._commentTextField;
        }
    }
}

