/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.patch.AbstractPatchCommand;
import oracle.jdeveloper.vcs.patch.CreatePatchCommand;
import oracle.jdeveloper.vcs.patch.CreatePatchDialogVetoer;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.error.CVSValidationException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCommandLine;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.ui.CVSGeneratePatchUI;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogEntry;

public class CVSOperationGeneratePatch
extends AbstractPatchCommand {
    public CVSOperationGeneratePatch() {
        super(CVSCommandConstants.OPERATION_GENERATE_PATCH_CMD_ID);
    }

    protected Locatable[] getLocatablesToGeneratePatch() throws Exception {
        Project contextProject = this.getContextProject();
        if (contextProject != null) {
            if (this.getContext().getView() instanceof HistoryViewer) {
                return new Locatable[]{contextProject};
            }
            return this.getProjectFolderNodes(contextProject);
        }
        return this.getContextLocatables();
    }

    protected VCSStatusFilter getStatusFilter() {
        return this.createStatusFilter(new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_REMOVED, CVSFileStatus.STATUS_UNMODIFIED_READWRITE, CVSFileStatus.STATUS_UNMODIFIED_READONLY, CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_SANDBOX});
    }

    protected boolean isAvailableImpl() throws Exception {
        if (this.getContext().getView() instanceof CompareEditor) {
            return false;
        }
        if (this.getContext().getView() instanceof HistoryViewer && this.getHistoryLogEntryLHS() == null) {
            return false;
        }
        Locatable[] locatables = this.getLocatablesToGeneratePatch();
        if (this.getContextProject() != null) {
            int i = 0;
            while (i < locatables.length) {
                if (this.isAvailableImpl(locatables[i].getURL())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return locatables.length == 1 && this.isAvailableImpl(locatables[0].getURL());
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url) || !CVSUtil.isOpenSessionFile(url)) {
            return false;
        }
        return super.isAvailableImpl(url);
    }

    protected int doitImpl() throws Exception {
        GeneratePatchUI ui;
        URL[] urls;
        block9: {
            Locatable[] locatables = this.getLocatablesToGeneratePatch();
            Collection nodes = this.getFilteredSelection(locatables);
            if (nodes.size() <= 0) {
                return 0;
            }
            if (this.getContextProject() != null) {
                nodes = this.processNodesForProjectOperation(this.getContextProject(), nodes);
            }
            if (nodes == null) {
                return 1;
            }
            Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs((Collection)nodes));
            if (!CVSUtil.saveDirtyNodes(Arrays.asList(affectedNodes))) {
                return 1;
            }
            urls = VCSModelUtils.convertNodesToURLs((Collection)nodes);
            URL operationWorkingDirectoryUrl = this.getOperationWorkingDirectoryURL(urls);
            if (operationWorkingDirectoryUrl == null || !CVSUtil.isUnderCVS(operationWorkingDirectoryUrl)) {
                return 9;
            }
            ui = this.createUI(nodes.toArray(new Locatable[0]));
            JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CreatePatchCommand.createDialogTitle((String)this.createDialogTitlePostfix()), null, (Component)CVSComponents.createFileListerComponent(nodes), (Component)ui.getComponent(), (String)"f1_cvsgeneratepatch_html", (Component)ui.getPatchOptionsUI().getClipboardRadioButton());
            dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 1(this, ui.getComponent(), ui)));
            try {
                if (CVSDialogRunner.runDialog((JDialog)dialog)) break block9;
                int n = 1;
                return n;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ui.getCustomizer().dispose();
            }
        }
        return this.doOperation(urls, ui);
    }

    private String createDialogTitlePostfix() {
        String revisionNameRhs;
        if (!(this.getContext().getView() instanceof HistoryViewer)) {
            return null;
        }
        CVSLogEntry logEntryLhs = this.getHistoryLogEntryLHS();
        CVSLogEntry logEntryRhs = this.getHistoryLogEntryRHS();
        String revisionNameLhs = logEntryLhs != null ? this.getRevisionName(logEntryLhs) : null;
        String string = revisionNameRhs = logEntryRhs != null ? this.getRevisionName(logEntryRhs) : null;
        if (revisionNameLhs == null) {
            return null;
        }
        String postfixSubstringLhs = CVSArb.format(440, revisionNameLhs);
        String postfixSubstringRhs = revisionNameRhs;
        if (revisionNameRhs == null) {
            postfixSubstringRhs = CVSArb.getString(304);
        }
        return CVSArb.format(320, postfixSubstringLhs, postfixSubstringRhs);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.getString(83), CVSArb.getString(419));
    }

    protected URL[] getOperationURLs(URL[] urls) {
        if (urls.length == 1 && URLFileSystem.isDirectoryPath((URL)urls[0])) {
            return new URL[0];
        }
        return urls;
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        ArrayList basOptions = new ArrayList();
        ArrayList<CVSOptionId> advOptions = new ArrayList<CVSOptionId>();
        if (this.getHistoryLogEntryLHS() == null) {
            advOptions.add(CVSOptionId.COMMON_USE_REVISION_OR_DATE);
        }
        advOptions.add(CVSOptionId.COMMON_LOCAL_FOLDER_ONLY);
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, basOptions.toArray(new CVSOptionId[0]));
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, advOptions.toArray(new CVSOptionId[0]));
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        return new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
    }

    private CVSLogEntry getHistoryLogEntryLHS() {
        View view = this.getContext().getView();
        if (view != null && view instanceof HistoryViewer) {
            return this.getHistoryLogEntry((Element[])((HistoryViewer)view).getSelectionLHS());
        }
        return null;
    }

    private CVSLogEntry getHistoryLogEntryRHS() {
        View view = this.getContext().getView();
        if (view != null && view instanceof HistoryViewer) {
            return this.getHistoryLogEntry((Element[])((HistoryViewer)view).getSelectionRHS());
        }
        return null;
    }

    private CVSLogEntry getHistoryLogEntry(Element[] historyElements) {
        if (historyElements != null && historyElements.length > 0 && ((HistoryElement)historyElements[0]).getEntry() instanceof CVSLogEntry) {
            return (CVSLogEntry)((HistoryElement)historyElements[0]).getEntry();
        }
        return null;
    }

    private GeneratePatchUI createUI(Locatable[] contextLocatables) {
        URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])contextLocatables);
        CVSGeneratePatchUI patchOptionsUI = new CVSGeneratePatchUI();
        CVSResourcePicker.get().start((Container)patchOptionsUI);
        this.initializeFileChooserPanel(patchOptionsUI.getFileChooserPanel(), urls);
        patchOptionsUI.getClipboardRadioButton().setSelected(true);
        patchOptionsUI.getUnifiedRadioButton().setSelected(true);
        patchOptionsUI.getOpenInEditorCheckBox().setSelected(true);
        patchOptionsUI.getFileRadioButton().addChangeListener(new 2(this, patchOptionsUI));
        this.updateFileOptionsEnabledState(patchOptionsUI);
        this.initializePreferredSizeOfUI(patchOptionsUI);
        return new GeneratePatchUI(patchOptionsUI, this.createOptionsCustomizer(contextLocatables));
    }

    private void updateFileOptionsEnabledState(CVSGeneratePatchUI ui) {
        boolean fileOptionsEnabled = ui.getFileRadioButton().isSelected();
        ui.getFileChooserPanel().setEnabled(fileOptionsEnabled);
        ui.getOpenInEditorCheckBox().setEnabled(fileOptionsEnabled);
    }

    private int doOperation(URL[] urls, GeneratePatchUI ui) throws Exception {
        Ide.getWaitCursor().show();
        3 r = new 3(this, urls, ui);
        new Thread((Runnable)r, "CVS Generate Patch").start();
        return 0;
    }

    private int doOperationImpl(URL[] urls, GeneratePatchUI ui) throws Exception {
        IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), CVSArb.getString(345), (Object)CVSArb.getString(119), "");
        monitor.setCancellable(false);
        monitor.start();
        try {
            int n = this.doOperationImpl2(urls, ui, monitor);
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            monitor.close();
        }
    }

    private int doOperationImpl2(URL[] urls, GeneratePatchUI ui, IndeterminateProgressMonitor monitor) throws Exception {
        Map optionsMap = ui.getCustomizer().getOptions();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        if (runner instanceof CVSInternalClientRunner) {
            ((CVSInternalClientRunner)runner).setEncodeStandardOut(true);
        }
        ArrayList<String> opts = new ArrayList<String>();
        URL directoryUrl = this.getOperationWorkingDirectoryURL(urls);
        runner.getParameters().setFiles(Arrays.asList(VCSFileSystemUtils.getURLFileNames((URL[])this.getOperationURLs(urls))));
        runner.setDirURL(directoryUrl);
        runner.setBufferOutputBinary(true);
        if (CVSDirectoryInvokable.isProgressDelayable(new URL[]{directoryUrl})) {
            monitor.setMillisToPopup(2000);
        } else {
            monitor.setMillisToPopup(0);
        }
        runner.setCommand("diff");
        if (ui.getPatchOptionsUI().getUnifiedRadioButton().isSelected()) {
            opts.add("-u");
        }
        if (ui.getPatchOptionsUI().getContextRadioButton().isSelected()) {
            opts.add("-c");
        }
        opts.add("-kk");
        opts.add("-N");
        CompareOptions compareOptions = CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        if (compareOptions.getIgnoreWhitespace()) {
            opts.add("-w");
        }
        runner.getParameters().setOptions(opts);
        if (optionsMap != null) {
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        CVSLogEntry logEntryLhs = this.getHistoryLogEntryLHS();
        CVSLogEntry logEntryRhs = this.getHistoryLogEntryRHS();
        if (logEntryLhs != null) {
            this.addRevisionNameOption(opts, logEntryLhs);
        }
        if (logEntryRhs != null) {
            this.addRevisionNameOption(opts, logEntryRhs);
        }
        runner.getParameters().setQuiet(true);
        runner.exec();
        if (runner.getExitCode() == null) {
            throw new CVSProcessException(CVSArb.getString(675), null);
        }
        monitor.close();
        byte[] patchSourceBytes = runner.getOutputBytes();
        String charsetName = StreamDecoder.getDefaultEncoding((URL)directoryUrl);
        String patchSource = new String(patchSourceBytes, charsetName);
        if (ui.getPatchOptionsUI().getClipboardRadioButton().isSelected()) {
            this.savePatchToClipboard(patchSource);
        } else {
            this.savePatchToURL(patchSource, charsetName, ui.getPatchOptionsUI().getFileChooserPanel().getURL(), ui.getPatchOptionsUI().getOpenInEditorCheckBox().isSelected());
        }
        return 0;
    }

    private void addRevisionNameOption(Collection opts, CVSLogEntry logEntry) {
        opts.add("-" + CVSOptionCommandLine.lookupOptionChar(CVSOptionArgument.REVISION_NAME).charValue() + this.getRevisionName(logEntry));
    }

    private String getRevisionName(CVSLogEntry logEntry) {
        return ((RevisionIdentifier)logEntry.getValue(SharedProperties.getRevisionProperty())).getLabel();
    }

    static int mav$doOperationImpl(CVSOperationGeneratePatch cVSOperationGeneratePatch, URL[] uRLArray, GeneratePatchUI generatePatchUI) {
        return cVSOperationGeneratePatch.doOperationImpl(uRLArray, generatePatchUI);
    }

    static VCSExceptionHandler mav$getExceptionHandler(CVSOperationGeneratePatch cVSOperationGeneratePatch) {
        return cVSOperationGeneratePatch.getExceptionHandler();
    }

    static void mav$updateFileOptionsEnabledState(CVSOperationGeneratePatch cVSOperationGeneratePatch, CVSGeneratePatchUI cVSGeneratePatchUI) {
        cVSOperationGeneratePatch.updateFileOptionsEnabledState(cVSGeneratePatchUI);
    }

    final class 1
    extends CreatePatchDialogVetoer {
        private final /* synthetic */ GeneratePatchUI v$ui;
        final /* synthetic */ CVSOperationGeneratePatch this$0;

        protected boolean isFileTargetSelected() {
            return this.v$ui.getPatchOptionsUI().getFileRadioButton().isSelected();
        }

        protected URL getFileTargetURL() {
            return this.v$ui.getPatchOptionsUI().getFileChooserPanel().getURL();
        }

        protected void validateCustomOptions() throws VCSException {
            this.v$ui.getCustomizer().validateOptions();
        }

        protected void handleException(String message) {
            CVSOperationGeneratePatch.mav$getExceptionHandler(this.this$0).handleException((Exception)((Object)new CVSValidationException(message)));
        }

        public 1(CVSOperationGeneratePatch cVSOperationGeneratePatch, Component component, GeneratePatchUI generatePatchUI) {
            this.v$ui = generatePatchUI;
            this.this$0 = cVSOperationGeneratePatch;
            super(component);
        }
    }

    final class 2
    implements ChangeListener {
        private final /* synthetic */ CVSGeneratePatchUI v$patchOptionsUI;
        final /* synthetic */ CVSOperationGeneratePatch this$0;

        public final void stateChanged(ChangeEvent e) {
            CVSOperationGeneratePatch.mav$updateFileOptionsEnabledState(this.this$0, this.v$patchOptionsUI);
        }

        public 2(CVSOperationGeneratePatch cVSOperationGeneratePatch, CVSGeneratePatchUI cVSGeneratePatchUI) {
            this.v$patchOptionsUI = cVSGeneratePatchUI;
            this.this$0 = cVSOperationGeneratePatch;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ URL[] v$urls;
        private final /* synthetic */ GeneratePatchUI v$ui;
        final /* synthetic */ CVSOperationGeneratePatch this$0;

        public final void run() {
            try {
                try {
                    CVSOperationGeneratePatch.mav$doOperationImpl(this.this$0, this.v$urls, this.v$ui);
                }
                catch (Exception e) {
                    CVSOperationGeneratePatch.mav$getExceptionHandler(this.this$0).handleException(e);
                }
            }
            finally {
                EventQueue.invokeLater(new 1());
            }
        }

        public 3(CVSOperationGeneratePatch cVSOperationGeneratePatch, URL[] uRLArray, GeneratePatchUI generatePatchUI) {
            this.v$ui = generatePatchUI;
            this.v$urls = uRLArray;
            this.this$0 = cVSOperationGeneratePatch;
        }

        final class 1
        implements Runnable {
            public final void run() {
                Ide.getWaitCursor().hide();
            }
        }
    }

    private class GeneratePatchUI
    extends JPanel {
        private final CVSGeneratePatchUI _patchOptionsUI;
        private final CVSOptionsCustomizer _customizer;

        GeneratePatchUI(CVSGeneratePatchUI patchOptionsUI, CVSOptionsCustomizer customizer) {
            this._patchOptionsUI = patchOptionsUI;
            this._customizer = customizer;
            this.setLayout(new BorderLayout());
            if (this._customizer.getComponent().isVisible()) {
                JPanel container2 = null;
                container2 = new JPanel(new BorderLayout());
                container2.add(Box.createVerticalStrut(10), "North");
                container2.add(this._customizer.getComponent(), "Center");
                if (container2 != null) {
                    this.add((Component)container2, "South");
                }
            }
            this.add((Component)this._patchOptionsUI, "Center");
        }

        public Component getComponent() {
            return this;
        }

        public CVSGeneratePatchUI getPatchOptionsUI() {
            return this._patchOptionsUI;
        }

        public CVSOptionsCustomizer getCustomizer() {
            return this._customizer;
        }
    }
}

