/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSImportBackupHelper;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSFileURLFileSystemHelper;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.wiz.checkout.CVSCheckoutCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.checkout.CVSCheckoutModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardAbortException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCancelException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardRunner;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportWizard;

public class CVSOperationImport
extends CVSAbstractCommand
implements CVSImportModelKey,
CVSCheckoutModelKey,
CVSCommandConstants {
    public CVSOperationImport() {
        super(CVSCommandConstants.OPERATION_IMPORT_CMD_ID);
    }

    protected boolean isThreaded() {
        return true;
    }

    protected boolean isAvailableImpl() throws Exception {
        if (this.isContextConnectionAndNotSupported()) {
            return false;
        }
        if (CVSClient.getInstance() == null) {
            return false;
        }
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedCommand("import");
    }

    protected int doitImpl() throws Exception {
        URL backupDirectoryUrl;
        CVSUtil.checkCreateConnection(this.getContext());
        CVSImportWizard wizard = new CVSImportWizard();
        wizard.setContext(this.getContext());
        Map importModel = null;
        try {
            importModel = CVSWizardRunner.runWizard(wizard, this.getContext());
        }
        catch (CVSWizardCancelException wce) {
            throw new VCSCancelException();
        }
        if (importModel == null || !((Boolean)importModel.get(CVSImportModelKey.KEY_IMPORT_DO_CHECKOUT)).booleanValue()) {
            return 0;
        }
        URL importDirectoryUrl = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)importModel.get(CVSImportModelKey.KEY_IMPORT_SOURCES).toString()), (String)"");
        try {
            CVSFileURLFileSystemHelper.arrestCommands(this, importDirectoryUrl);
            1 backupHelper = new 1(importDirectoryUrl);
            backupDirectoryUrl = backupHelper.backupDirectoryFiles();
            CVSRootCache.getInstance().clear();
        }
        finally {
            CVSFileURLFileSystemHelper.resumeCommands(this, importDirectoryUrl);
        }
        if (backupDirectoryUrl == null) {
            return 1;
        }
        URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{backupDirectoryUrl});
        CVSClient.getInstance().getStatusCache().clear(filter);
        Map checkoutModel = this.createCheckoutModel(importModel);
        try {
            CVSWizardRunner.commitWizard(checkoutModel, new CVSCheckoutCommitter(), this.getContext());
        }
        catch (CVSWizardAbortException wae) {
            throw new VCSCancelException();
        }
        catch (CVSWizardException we) {
            throw new CVSOperationException(we.getMessage());
        }
        return 0;
    }

    private Map createCheckoutModel(Map importModel) {
        HashMap checkoutModel = new HashMap();
        checkoutModel.put(CVSCheckoutModelKey.KEY_CHECKOUT_MODULE_NAME, importModel.get(CVSImportModelKey.KEY_IMPORT_MODULE_NAME));
        checkoutModel.put(CVSCheckoutModelKey.KEY_CHECKOUT_CONNECTION_NAME, importModel.get(CVSImportModelKey.KEY_IMPORT_CONNECTION_NAME));
        checkoutModel.put(CVSCheckoutModelKey.KEY_CHECKOUT_TARGET, importModel.get(CVSImportModelKey.KEY_IMPORT_SOURCES));
        checkoutModel.put(CVSCheckoutModelKey.KEY_CHECKOUT_CHECKOUT_TO_DIR, Boolean.TRUE);
        return checkoutModel;
    }

    final class 1
    extends VCSImportBackupHelper {
        protected void createBackupDirectory(URL backupDirectoryUrl) throws Exception {
            if (!URLFileSystem.mkdirs((URL)backupDirectoryUrl)) {
                throw new CVSOperationException(CVSArb.format(414, URLFileSystem.getPlatformPathName((URL)backupDirectoryUrl)));
            }
        }

        protected boolean confirmRetryBackupAfterFailure(URL url) {
            return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CVSArb.format(671, URLFileSystem.getPlatformPathName((URL)url)), (String)CVSArb.getString(602), null, (boolean)false, (String)CVSArb.getString(167), (String)UIManager.getString("OptionPane.cancelButtonText"));
        }

        protected void preprocessBackup(URL url) {
            CVSFileURLFileSystemHelper.arrestCommands((Object)this, url);
        }

        protected void postprocessBackup(URL url) {
            CVSFileURLFileSystemHelper.resumeCommands((Object)this, url);
        }

        public 1(URL uRL) {
            super(uRL);
        }
    }
}

