/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;

public class CVSOperationLogout
extends CVSAbstractCommand
implements CVSCommandConstants {
    public CVSOperationLogout() {
        super(CVSCommandConstants.OPERATION_LOGOUT_CMD_ID);
    }

    protected boolean isAvailableImpl() throws Exception {
        if (this.isContextConnectionAndNotSupported()) {
            return false;
        }
        CVSRootString rootString = this.getContextRoot();
        if (rootString == null || !CVSUtil.hasRootConnection(rootString)) {
            return false;
        }
        return CVSLogin.hasMethod(rootString) && CVSLogin.getMethod(rootString).isLoggedIn(rootString);
    }

    protected int doitImpl() throws Exception {
        CVSConnectionListAPI list;
        String connectionName;
        CVSRootString rootString = this.getContextRoot();
        if (rootString != null) {
            CVSLogin.getMethod(rootString).doLogout(rootString);
        }
        if ((connectionName = ((CVSConnectionListData)(list = CVSConnectionNodes.getConnectionListAPI())).getRootConnection(rootString.toString())) != null) {
            CVSConnectionNodeUtils.closeConnection(connectionName);
        }
        CVSConnectionNodes.updateOverlays();
        return 0;
    }
}

