/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFileURLFileSystemHelper;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationRemove
extends CVSAbstractCommand {
    public CVSOperationRemove() {
        super(CVSCommandConstants.OPERATION_REMOVE_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (VCSFileSystemUtils.isNonEditable((URL)url)) {
            return false;
        }
        VCSStatus status = CVSClient.getInstance().getStatusCache().get(url);
        if (status == CVSFileStatus.STATUS_SANDBOX) {
            return false;
        }
        return status.isVersioned();
    }

    protected int doitImpl() throws Exception {
        VCSStatus[] statuses = new VCSStatus[]{CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_ADDED, CVSFileStatus.STATUS_UNMODIFIED_READWRITE, CVSFileStatus.STATUS_UNMODIFIED_READONLY};
        Collection nodes = this.getFilteredSelection(statuses);
        VCSCommandUtils.removeNonEditableNodes((Collection)nodes);
        if (nodes.size() <= 0) {
            return 9;
        }
        VCSModelUtils.fireVetoableCanRemoveChildren((Object[])nodes.toArray());
        JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.getString(84), (String)CVSArb.getString(706), (Component)CVSComponents.createFileListerComponent(nodes), null, (String)"f1_cvsremove_html");
        VCSDirectoryInvokableState state = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 1(this, null, dialog, state)));
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        Collection processedUrls = state.getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[0]);
        URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])processedUrlArray);
        CVSClient.getInstance().getStatusCache().clear(filter);
        this.fireSomeFilesDeleted(processedUrlArray);
        EventQueue.invokeLater(new 2(this, processedUrls));
        return !dialogSuccessful ? 1 : 0;
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.getString(551), CVSArb.getString(311));
    }

    private boolean doCommitOperationImpl(Component dialog, Map options, VCSDirectoryInvokableState state) throws Exception {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(dialog, CVSArb.getString(102), (Object)CVSArb.getString(3), "", 0, -1);
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-l");
        runner.setCommand("remove");
        runner.getParameters().setQuiet(false);
        runner.getParameters().setOptions(opts);
        3 invokable = new 3(this, state, runner);
        invokable.setProgressMonitor(monitor);
        if (!invokable.runInvokable()) {
            return false;
        }
        EventQueue.invokeLater(new 4());
        return true;
    }

    private void doInvocationImpl(CVSRunner runner, URL parent, String[] filenames) throws Exception {
        List<String> names = Arrays.asList(filenames);
        this.deleteFilesForRemove(parent, names);
        runner.exec();
        if (runner.getExitCode() != null && runner.getExitCode() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.getString(73), runner.getErrorText());
    }

    private void deleteFilesForRemove(URL dir, List names) throws Exception {
        Iterator itr = names.iterator();
        while (itr.hasNext()) {
            URL url = URLFactory.newURL((URL)dir, (String)itr.next().toString());
            if (URLFileSystem.isDirectoryPath((URL)url)) continue;
            CVSFileURLFileSystemHelper.arrestCommands((Object)this, url);
            Boolean renameOnRemove = (Boolean)CVSClient.getInstance().getProperties().get("rename_on_remove");
            if (renameOnRemove != null && renameOnRemove.booleanValue()) {
                URL renameUrl = URLFactory.newURL((URL)dir, (String)(".#" + URLFileSystem.getFileName((URL)url) + ".removed"));
                if (URLFileSystem.exists((URL)renameUrl)) {
                    URLFileSystem.delete((URL)renameUrl);
                }
                URLFileSystem.renameTo((URL)url, (URL)renameUrl);
            }
            if (URLFileSystem.exists((URL)url)) {
                URLFileSystem.delete((URL)url);
            }
            CVSFileURLFileSystemHelper.resumeCommands((Object)this, url);
        }
    }

    static void mav$doInvocationImpl(CVSOperationRemove cVSOperationRemove, CVSRunner cVSRunner, URL uRL, String[] stringArray) {
        cVSOperationRemove.doInvocationImpl(cVSRunner, uRL, stringArray);
    }

    static boolean mav$doCommitOperationImpl(CVSOperationRemove cVSOperationRemove, Component component, Map map, VCSDirectoryInvokableState vCSDirectoryInvokableState) {
        return cVSOperationRemove.doCommitOperationImpl(component, map, vCSDirectoryInvokableState);
    }

    final class 1
    extends VCSDialogCommitter {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ VCSDirectoryInvokableState v$state;
        final /* synthetic */ CVSOperationRemove this$0;

        protected final boolean doCommitOperation(Map options) throws Exception {
            return CVSOperationRemove.mav$doCommitOperationImpl(this.this$0, (Component)this.v$dialog, options, this.v$state);
        }

        public 1(CVSOperationRemove cVSOperationRemove, VCSOptionsCustomizer vCSOptionsCustomizer, JEWTDialog jEWTDialog, VCSDirectoryInvokableState vCSDirectoryInvokableState) {
            this.v$state = vCSDirectoryInvokableState;
            this.v$dialog = jEWTDialog;
            this.this$0 = cVSOperationRemove;
            super(vCSOptionsCustomizer);
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Collection v$processedUrls;
        final /* synthetic */ CVSOperationRemove this$0;

        public final void run() {
            try {
                Iterator itr = this.v$processedUrls.iterator();
                while (itr.hasNext()) {
                    Node node = NodeFactory.find((URL)((URL)itr.next()));
                    if (node == null) continue;
                    node.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public 2(CVSOperationRemove cVSOperationRemove, Collection collection) {
            this.v$processedUrls = collection;
            this.this$0 = cVSOperationRemove;
        }
    }

    final class 3
    extends CVSDirectoryInvokable {
        private final /* synthetic */ CVSRunner v$runner;
        final /* synthetic */ CVSOperationRemove this$0;

        protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
            String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
            this.v$runner.setDirURL(parent);
            this.v$runner.getParameters().setFiles(Arrays.asList(filenames));
            CVSOperationRemove.mav$doInvocationImpl(this.this$0, this.v$runner, parent, filenames);
            return true;
        }

        public 3(CVSOperationRemove cVSOperationRemove, VCSDirectoryInvokableState vCSDirectoryInvokableState, CVSRunner cVSRunner) {
            this.v$runner = cVSRunner;
            this.this$0 = cVSOperationRemove;
            super(vCSDirectoryInvokableState);
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            CVSClient.invokePendingChanges();
        }
    }
}

