/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.op.CVSAbstractReplaceOperation;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;

public class CVSOperationReplacePrevious
extends CVSAbstractReplaceOperation
implements CVSCommandConstants {
    private static final VCSStatusFilter sVersionFilter = new 1();

    public CVSOperationReplacePrevious() {
        super(CVSCommandConstants.OPERATION_REPLACE_PREVIOUS_CMD_ID, VCSCommandStyle.MULTI);
    }

    public CVSOperationReplacePrevious(int cmdId) {
        super(cmdId, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        return this.isOpenSessionSelection(locatables) && this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        Node[] nodes = VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createSpecificURLFilter((URL[])new URL[]{url}));
        if (nodes != null && nodes.length > 0) {
            return nodes[0].isDirty() || super.isAvailableImpl(url);
        }
        return super.isAvailableImpl(url);
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        ArrayList<Node> dirtyNodes = new ArrayList<Node>(10);
        ArrayList<Node> cleanNodes = new ArrayList<Node>(10);
        int i = 0;
        while (i < affectedNodes.length) {
            if (affectedNodes[i].isDirty()) {
                dirtyNodes.add(affectedNodes[i]);
            } else {
                cleanNodes.add(affectedNodes[i]);
            }
            ++i;
        }
        if (!dirtyNodes.isEmpty() && !MessageDialog.optionalConfirm((String)(this.getClass().getName() + ".dirtyWarning"), (Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.getString(609), (String)CVSArb.getString(100), null)) {
            return 1;
        }
        Collection filteredCleanNodes = this.getFilteredSelection(cleanNodes.toArray(new Locatable[cleanNodes.size()]), new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED});
        ArrayList allAffectedNodes = new ArrayList(dirtyNodes);
        allAffectedNodes.addAll(filteredCleanNodes);
        if (allAffectedNodes.isEmpty()) {
            return 9;
        }
        VCSCommandState cmdState = new VCSCommandState(new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs(allAffectedNodes)), VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes)));
        return this.replace(allAffectedNodes, affectedNodes, cmdState);
    }

    protected VCSStatusFilter getStatusFilter() {
        return sVersionFilter;
    }

    private int replace(Collection nodes, Node[] affectedNodes, VCSCommandState state) throws Exception {
        JEWTDialog dialog = this.createOperationDialog(nodes);
        dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 2(this, null, dialog, state)));
        boolean success = CVSDialogRunner.runDialog((JDialog)dialog);
        this.postReplace(state, affectedNodes);
        return success ? 0 : 1;
    }

    private void postReplace(VCSCommandState state, Node[] affectedNodes) throws Exception {
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[processedUrls.size()]);
        URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])processedUrlArray);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
        this.fireSomeFilesDeleted(processedUrlArray);
        CVSClient.getInstance().getStatusCache().clear(filter);
        if (this.getContext().getView() instanceof CVSChangeListWindow) {
            ((CVSChangeListWindow)this.getContext().getView()).getIncomingChangeList().refresh();
        }
    }

    private boolean doReplaceOperation(Component dialog, Map options, VCSCommandState state) throws Exception {
        HashMap<CVSOptionId, Boolean> opts = new HashMap<CVSOptionId, Boolean>(10);
        opts.put(CVSOptionId.UPDATE_CLEAN_UPDATE, Boolean.TRUE);
        opts.put(CVSOptionId.UPDATE_CREATE_FOLDERS, Boolean.TRUE);
        opts.put(CVSOptionId.UPDATE_PRUNE_FOLDERS, Boolean.TRUE);
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand("update");
        runner.getParameters().setQuiet(false);
        runner.getParameters().setBuilderOptions(opts);
        3 invokable = new 3(this, state.getInvokableState(), opts, runner);
        invokable.setProgressMonitor(this.createProgressMonitor(dialog));
        return invokable.runInvokable();
    }

    private DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.getString(515), (Object)CVSArb.getString(133), "", 0, -1);
    }

    protected JEWTDialog createOperationDialog(Collection nodes) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.getString(104), (String)CVSArb.getString(513), (Component)CVSComponents.createFileListerComponent(nodes, false), null, (String)"f1_cvsreplaceprevious_html");
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.getString(318), CVSArb.getString(49));
    }

    static boolean mav$doReplaceOperation(CVSOperationReplacePrevious cVSOperationReplacePrevious, Component component, Map map, VCSCommandState vCSCommandState) {
        return cVSOperationReplacePrevious.doReplaceOperation(component, map, vCSCommandState);
    }

    static final class 1
    implements VCSStatusFilter {
        public boolean accept(VCSStatus status) {
            return status != null && status == CVSFileStatus.STATUS_LOCALLY_CHANGED && status != CVSFileStatus.STATUS_REMOVED;
        }
    }

    final class 2
    extends VCSDialogCommitter {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ VCSCommandState v$state;
        final /* synthetic */ CVSOperationReplacePrevious this$0;

        protected final boolean doCommitOperation(Map options) throws Exception {
            return CVSOperationReplacePrevious.mav$doReplaceOperation(this.this$0, (Component)this.v$dialog, options, this.v$state);
        }

        public 2(CVSOperationReplacePrevious cVSOperationReplacePrevious, VCSOptionsCustomizer vCSOptionsCustomizer, JEWTDialog jEWTDialog, VCSCommandState vCSCommandState) {
            this.v$state = vCSCommandState;
            this.v$dialog = jEWTDialog;
            this.this$0 = cVSOperationReplacePrevious;
            super(vCSOptionsCustomizer);
        }
    }

    final class 3
    extends CVSDirectoryInvokable {
        private final /* synthetic */ Map v$opts;
        private final /* synthetic */ CVSRunner v$runner;
        final /* synthetic */ CVSOperationReplacePrevious this$0;

        protected boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
            if (invokeUrls == null || invokeUrls.length == 0) {
                List<URL> c = CVSListFilesUtil.listFiles(parent, 1);
                invokeUrls = c.toArray(new URL[c.size()]);
            }
            Collection<CVSEntry> entries = new CVSEntriesFile(parent).getEntries();
            HashMap<String, String> index = new HashMap<String, String>(entries.size() * 2);
            for (CVSEntry entry : entries) {
                index.put(entry.getName(), entry.getRevision());
            }
            int i = 0;
            while (i < invokeUrls.length) {
                String fileName = URLFileSystem.getFileName((URL)invokeUrls[i]);
                String baseRevision = (String)index.get(fileName);
                if (baseRevision == null) {
                    throw new IllegalStateException();
                }
                File f = new File(URLFileSystem.getPlatformPathName((URL)invokeUrls[i]));
                if (!f.delete()) {
                    throw new CVSOperationException(CVSArb.getString(297));
                }
                this.v$opts.put(CVSOptionId.COMMON_USE_REVISION, Boolean.TRUE);
                this.v$opts.put(CVSOptionArgument.REVISION_NAME, baseRevision);
                this.v$runner.setDirURL(parent);
                this.v$runner.getParameters().setFile(fileName);
                this.v$runner.exec();
                if (this.v$runner.getExitCode() != null && this.v$runner.getExitCode() < 0) {
                    throw new CVSProcessException(CVSArb.getString(105), this.v$runner.getErrorText());
                }
                ++i;
            }
            CVSEntriesFile ef = new CVSEntriesFile(parent);
            Collection<CVSEntry> updatedEntries = ef.getEntries();
            int i2 = 0;
            while (i2 < invokeUrls.length) {
                CVSEntry entry = CVSEntriesFile.findEntry(updatedEntries, invokeUrls[i2]);
                if (entry == null) {
                    throw new IllegalStateException();
                }
                CVSEntry newEntry = new CVSEntry(null, entry.isDirectory(), entry.getName(), entry.getStateFlag(), entry.getRevision(), entry.getTimestamp(), entry.getConflictFlag(), entry.getConflict(), entry.getOptions(), null, null);
                updatedEntries.remove(entry);
                updatedEntries.add(newEntry);
                ++i2;
            }
            ef.writeEntries(updatedEntries);
            CVSEntriesCache.getInstance().clear();
            return true;
        }

        public 3(CVSOperationReplacePrevious cVSOperationReplacePrevious, VCSDirectoryInvokableState vCSDirectoryInvokableState, Map map, CVSRunner cVSRunner) {
            this.v$runner = cVSRunner;
            this.v$opts = map;
            this.this$0 = cVSOperationReplacePrevious;
            super(vCSDirectoryInvokableState);
        }
    }
}

