/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionLayoutBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionStructure;

public class CVSOptionsCustomizer
implements VCSOptionsCustomizer {
    private final CVSOptionStructure _structure;
    private Component _component;
    private int _layoutColumns;
    private Map _defaultOptionValues;
    private boolean _layoutToWidth;

    private void $init$() {
        this._layoutColumns = 2;
    }

    public CVSOptionsCustomizer(CVSOptionStructure structure) {
        this.$init$();
        this._structure = structure;
    }

    public void dispose() {
        CVSOptionId[] ids = this._structure.getOptionIds();
        int i = 0;
        while (i < ids.length) {
            this._structure.getBuilder(ids[i]).dispose();
            ++i;
        }
    }

    public void setLayoutToWidth(boolean layoutToWidth) {
        this._layoutToWidth = layoutToWidth;
    }

    public void setLayoutColumns(int layoutColumns) {
        this._layoutColumns = layoutColumns;
    }

    public int getLayoutColumns() {
        return this._layoutColumns;
    }

    public void setDefaultOptionValues(Map defaultOptionValues) {
        this._defaultOptionValues = defaultOptionValues;
    }

    public Map getDefaultOptionValues() {
        return this._defaultOptionValues;
    }

    public void disableUnsupportedComponents(String command, CVSOptionId id) {
        CVSOptionId[] ids = this._structure.getOptionIds();
        int i = 0;
        while (i < ids.length) {
            CVSOptionBuilder builder = this._structure.getBuilder(ids[i]);
            if (id == builder.getId()) {
                builder.disableUnsupportedComponents(command);
            }
            ++i;
        }
    }

    public Component getComponent() {
        if (this._component == null) {
            this._component = this.createComponent();
            if (this._defaultOptionValues != null) {
                this.setOptions(this._defaultOptionValues);
            }
        }
        return this._component;
    }

    public void setOptions(Map options) {
        CVSOptionId[] ids = this._structure.getOptionIds();
        int i = 0;
        while (i < ids.length) {
            this._structure.getBuilder(ids[i]).setValues(options);
            ++i;
        }
    }

    public Map getOptions() {
        HashMap options = this._defaultOptionValues != null ? new HashMap(this._defaultOptionValues) : new HashMap();
        CVSOptionId[] ids = this._structure.getOptionIds();
        int i = 0;
        while (i < ids.length) {
            this._structure.getBuilder(ids[i]).commitValues(options);
            ++i;
        }
        return options;
    }

    public void validateOptions() throws CVSOptionException {
        CVSOptionId[] ids = this._structure.getOptionIds();
        int i = 0;
        while (i < ids.length) {
            this._structure.getBuilder(ids[i]).validateValues();
            ++i;
        }
    }

    public Component getInitialFocusComponent() {
        CVSOptionId[] ids = this._structure.getOptionIds();
        int i = 0;
        while (i < ids.length) {
            CVSOptionBuilder builder = this._structure.getBuilder(ids[i]);
            if (builder.getFocusComponent().isEnabled()) {
                return builder.getFocusComponent();
            }
            ++i;
        }
        return null;
    }

    private Component createComponent() {
        JPanel panel2;
        JPanel panel;
        CVSOptionId[] ids = this._structure.getOptionIds();
        if (ids.length <= 0) {
            Component component = Box.createRigidArea(new Dimension(0, 0));
            component.setVisible(false);
            return component;
        }
        ArrayList<JPanel> columnPanels = new ArrayList<JPanel>();
        int n = 0;
        int i = 0;
        while (i < ids.length) {
            n += this._structure.getBuilder(ids[i]).getLayoutRowCount();
            ++i;
        }
        float wrapRowValue = Math.max(1.0f, (float)n / (float)this._layoutColumns);
        CVSOptionLayoutBuilder layoutBuilder = null;
        Insets insets = new Insets(2, 2, 2, 2);
        n = 0;
        int i2 = 0;
        while (i2 <= ids.length) {
            CVSOptionBuilder builder = null;
            if (i2 < ids.length) {
                builder = this._structure.getBuilder(ids[i2]);
            }
            if (layoutBuilder != null && ((float)n >= wrapRowValue || i2 >= ids.length)) {
                n = 0;
                panel = new JPanel();
                layoutBuilder.addToPanel(panel);
                layoutBuilder = null;
                panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)panel, "North");
                panel2.add(Box.createGlue(), "Center");
                columnPanels.add(panel2);
            }
            if (i2 >= ids.length) break;
            if (layoutBuilder == null) {
                layoutBuilder = new CVSOptionLayoutBuilder();
            }
            builder.buildLayout(layoutBuilder, insets);
            n += builder.getLayoutRowCount();
            ++i2;
        }
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        Iterator itr = columnPanels.iterator();
        while (itr.hasNext()) {
            panel.add((Component)itr.next());
            if (!itr.hasNext()) continue;
            panel.add(Box.createHorizontalStrut(10));
        }
        if (!this._layoutToWidth) {
            panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)panel, "West");
            panel2.add(Box.createGlue(), "Center");
            return panel2;
        }
        return panel;
    }
}

