/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.runner;

import java.util.Map;
import oracle.ide.log.LogManager;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.SimpleProcess;
import oracle.jdeveloper.vcs.migrate.VCSShellRunner;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessListener;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerParameters;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerUtil;

public class CVSExternalClientRunner
extends VCSShellRunner
implements CVSRunner {
    private final CVSRunnerParameters _parameters;
    private CVSProcess _runProcess;

    private void $init$() {
        this._parameters = new CVSRunnerParameters();
    }

    public CVSExternalClientRunner() {
        this.$init$();
        CVSRunnerUtil.constructRunner(this);
        this.getSimpleProcess().setAddToProcessesFolder(false);
        this.getSimpleProcess().setShowStartStatus(false);
    }

    public CVSRunnerParameters getParameters() {
        return this._parameters;
    }

    public void setEnvpMapInternal(Map envpMap) {
        super.setEnvpMap(envpMap);
    }

    public void addOutputMonitor(CVSProcessStreamMonitor monitor) {
        super.addOutputMonitor((VCSStreamMonitor)new StreamMonitorAdapter(monitor));
    }

    public void addErrorMonitor(CVSProcessStreamMonitor monitor) {
        super.addErrorMonitor((VCSStreamMonitor)new StreamMonitorAdapter(monitor));
    }

    public void exec() throws Exception {
        boolean quiet = this._parameters.isQuiet();
        this.getSimpleProcess().setUseLogPage(quiet ^ true);
        this.getSimpleProcess().setLogPage(quiet ? null : LogManager.getLogManager().getMsgPage());
        this.getSimpleProcess().setAddToTerminateMenu(quiet ^ true);
        CVSRunnerUtil.preExecution(this);
        try {
            super.execAndWait();
            CVSRunnerUtil.postExecution(this);
        }
        finally {
            this._runProcess = null;
            CVSRunnerUtil.postExecutionFinal(this);
        }
    }

    public CVSProcess getRunProcess() {
        return this._runProcess;
    }

    public void setRunProcessListener(CVSProcessListener l) {
        RunProcessListenerAdapter rpl = l != null ? new RunProcessListenerAdapter(l) : null;
        this.getSimpleProcess().setRunProcessListener((RunProcessListener)rpl);
    }

    public String getErrorText() {
        return CVSRunnerUtil.getErrorText(this, super.getErrorText());
    }

    protected String[] createCommandSpi(String[] cmdarray) {
        return CVSRunnerUtil.createCommandSpi(this, cmdarray);
    }

    protected void preExecSpi() throws Exception {
        CVSRunnerUtil.preExecSpi(this);
    }

    protected void setSimpleProcess(SimpleProcess simpleProcess) {
        super.setSimpleProcess(simpleProcess);
        this._runProcess = new RunProcessAdapter(simpleProcess.getRunProcess());
    }

    public int execAndWait() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setEnvpArray(String[] envp_array) {
        throw new UnsupportedOperationException();
    }

    public void setEnvpMap(Map envp_map) {
        throw new UnsupportedOperationException();
    }

    static CVSProcess ra$_runProcess(CVSExternalClientRunner cVSExternalClientRunner) {
        return cVSExternalClientRunner._runProcess;
    }

    private class StreamMonitorAdapter
    extends VCSStreamMonitor {
        private final CVSProcessStreamMonitor _monitor;

        StreamMonitorAdapter(CVSProcessStreamMonitor monitor) {
            this._monitor = monitor;
        }

        public String getPattern() {
            return this._monitor.getPattern();
        }

        protected void patternMatched(RunProcess process) throws Exception {
            this._monitor.patternMatched(CVSExternalClientRunner.ra$_runProcess(CVSExternalClientRunner.this));
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            this._monitor.streamLine(line, CVSExternalClientRunner.ra$_runProcess(CVSExternalClientRunner.this));
        }
    }

    private class RunProcessAdapter
    implements CVSProcess {
        private final RunProcess _process;

        RunProcessAdapter(RunProcess process) {
            this._process = process;
        }

        public Process getProcess() {
            return this._process.getStarter().getProcess();
        }

        public void waitForRedirectOutput() {
            this._process.waitForRedirectOutput();
        }

        public void log(String message) {
            this._process.log((Object)message);
        }
    }

    private class RunProcessListenerAdapter
    implements RunProcessListener {
        private final CVSProcessListener _processListener;

        RunProcessListenerAdapter(CVSProcessListener processListener) {
            this._processListener = processListener;
        }

        public void processFinished(int exitCode) {
            this._processListener.processFinished(exitCode);
        }
    }
}

