/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.runner;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSRootContext;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessListener;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerParameters;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerUtil;
import oracle.jdevimpl.vcs.util.RunnerOutputTask;
import oracle.jdevimpl.vcs.util.RunnerTimeoutTask;
import oracle.ocvs.OCVSMain;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSPrompter;
import oracle.ocvs.OCVSResponseRegistry;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSUsageException;

public class CVSInternalClientRunner
implements CVSRunner {
    private final CVSRunnerParameters _parameters;
    private String[] _cmdArray;
    private URL _dirUrl;
    private long _timeoutMillis;
    private boolean _isTimedOut;
    private Map _envpMap;
    private final Collection _outMonitors;
    private final Collection _errMonitors;
    private CVSProcessListener _runProcessListener;
    private RunnerOutputTask _outTask;
    private RunnerOutputTask _errTask;
    private Thread _executionThread;
    private CVSProcess _runProcess;
    private ClientProcess _process;
    private Integer _exitCode;
    private OCVSPrompter _prompter;
    private boolean _encodeStandardOut;
    private String _charsetName;
    private VCSThreadPool _threadPool;
    private boolean _bufferOutputBinary;

    private void $init$() {
        this._parameters = new CVSRunnerParameters();
        this._outMonitors = new ArrayList();
        this._errMonitors = new ArrayList();
    }

    public CVSInternalClientRunner() {
        this.$init$();
        CVSRunnerUtil.constructRunner(this);
        this._prompter = new Ssh2Prompter();
    }

    public void setThreadPool(VCSThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public void setBufferOutputBinary(boolean bufferOutputBinary) {
        this._bufferOutputBinary = bufferOutputBinary;
    }

    public void setPrompter(OCVSPrompter prompter) {
        this._prompter = prompter;
    }

    public void setEncodeStandardOut(boolean encodeStandardOut) {
        this._encodeStandardOut = encodeStandardOut;
    }

    public void setStandardOutEncoding(String charsetName) {
        this._charsetName = charsetName;
        this._encodeStandardOut = true;
    }

    public CVSRunnerParameters getParameters() {
        return this._parameters;
    }

    public void setCmdList(Collection cmdList) {
        this._cmdArray = cmdList.toArray(new String[0]);
    }

    public void setCommand(String command) {
        this._cmdArray = new String[]{command};
    }

    public void setCmdArray(String[] cmdArray) {
        this._cmdArray = cmdArray;
    }

    public Collection getCmdList() {
        return Arrays.asList(this._cmdArray);
    }

    public void setDirURL(URL dirUrl) {
        this._dirUrl = dirUrl;
    }

    public URL getDirURL() {
        return this._dirUrl;
    }

    public void setTimeout(long timeoutMillis) {
        this._timeoutMillis = timeoutMillis;
    }

    public long getTimeout() {
        return this._timeoutMillis;
    }

    public boolean isTimedOut() {
        return this._isTimedOut;
    }

    public void setEnvpMapInternal(Map envpMap) {
        this._envpMap = envpMap;
    }

    public void addOutputMonitor(CVSProcessStreamMonitor monitor) {
        this._outMonitors.add(monitor);
    }

    public void addErrorMonitor(CVSProcessStreamMonitor monitor) {
        this._errMonitors.add(monitor);
    }

    public void exec() throws Exception {
        PrintStream out;
        this._exitCode = null;
        HashMap<String, String> envpMap = this._envpMap != null ? new HashMap<String, String>(this._envpMap) : new HashMap();
        envpMap.put("CVS_SERVER", CVSClient.getInstance().getExecutablePath());
        CVSRunnerUtil.preExecution(this);
        this._isTimedOut = false;
        this._process = new ClientProcess();
        this._runProcess = new 1();
        String charsetName = this._charsetName != null ? this._charsetName : this.determineExecutionContextEncoding();
        PrintStream err = new PrintStream(new PipedOutputStream((PipedInputStream)this._process.getErrorStream()));
        if (this._encodeStandardOut && charsetName != null) {
            Assert.println((String)("CVS: Encoding process standard out stream as " + charsetName));
            out = new PrintStream((OutputStream)new PipedOutputStream((PipedInputStream)this._process.getInputStream()), false, charsetName);
        } else {
            out = new PrintStream(new PipedOutputStream((PipedInputStream)this._process.getInputStream()));
        }
        OCVSProcessIO io = new OCVSProcessIO((InputStream)new PipedInputStream((PipedOutputStream)this._process.getOutputStream()), out, err);
        if (this._prompter != null) {
            io.setPrompter(this._prompter);
        }
        this._process.setIO(io);
        this._outTask = new OutputTask(this._runProcess, this._outMonitors, this._process.getInputStream());
        this._errTask = new OutputTask(this._runProcess, this._errMonitors, this._process.getErrorStream());
        if (this._bufferOutputBinary) {
            this._outTask.setBufferBytes(true);
        }
        2 timeoutTask = null;
        if (this._timeoutMillis > 0L) {
            timeoutTask = new 2((int)this._timeoutMillis);
            this._outTask.setTimeoutTask((RunnerTimeoutTask)timeoutTask);
            this._errTask.setTimeoutTask((RunnerTimeoutTask)timeoutTask);
            if (this._prompter instanceof Ssh2Prompter) {
                Ssh2Prompter.mav$setTimeoutTask((Ssh2Prompter)this._prompter, timeoutTask);
            }
        }
        String[] cmdArray = CVSRunnerUtil.addCommandParts(this, this._cmdArray, null);
        if (charsetName != null) {
            cmdArray = this.addNoConvertEOLOptionForCustomEncoding(cmdArray);
        }
        if (this._encodeStandardOut && charsetName != null) {
            cmdArray = this.addOutputEncodingOptionForCustomEncoding(cmdArray, charsetName);
        }
        CVSRunnerUtil.preExecSpi(this);
        Thread outThread = null;
        Thread errThread = null;
        try {
            try {
                if (this._threadPool != null) {
                    this._threadPool.doTask((Runnable)this._outTask);
                    this._threadPool.doTask((Runnable)this._errTask);
                } else {
                    outThread = new Thread((Runnable)this._outTask);
                    errThread = new Thread((Runnable)this._errTask);
                    outThread.start();
                    errThread.start();
                }
                if (timeoutTask != null) {
                    if (this._threadPool != null) {
                        this._threadPool.doTask((Runnable)((Object)timeoutTask));
                    } else {
                        new Thread((Runnable)((Object)timeoutTask)).start();
                    }
                }
                this.logStartDirectory();
                this.logCommandString(cmdArray);
                this._executionThread = Thread.currentThread();
                this._exitCode = new Integer(OCVSMain.exec((OCVSProcessIO)io, (File)(this._dirUrl != null ? new File(URLFileSystem.getPlatformPathName((URL)this._dirUrl)) : null), (String[])OCVSMain.convertMapToEnvp(envpMap), (OCVSResponseRegistry)OCVSResponseRegistry.getInstance(), (String[])cmdArray));
                this._runProcessListener.processFinished(this._exitCode);
                CVSRunnerUtil.postExecution(this);
            }
            catch (OCVSUsageException ocvsue) {
                throw new CVSProcessException(CVSArb.format(501, this.createCommandStringForLog(cmdArray)), ocvsue.getMessage());
            }
        }
        finally {
            if (this._exitCode == null) {
                this._exitCode = new Integer(-1);
            }
            try {
                io._out.close();
                io._err.close();
                io._in.close();
                if (this._threadPool != null) {
                    this._threadPool.join((Runnable)this._outTask);
                    this._threadPool.join((Runnable)this._errTask);
                } else {
                    outThread.join();
                    errThread.join();
                }
            }
            catch (IOException ioe) {
            }
            catch (InterruptedException ie) {
                Assert.printStackTrace((Throwable)ie);
            }
            this._process = null;
            this._runProcess = null;
            this._executionThread = null;
            CVSRunnerUtil.postExecutionFinal(this);
        }
    }

    public CVSProcess getRunProcess() {
        return this._runProcess;
    }

    public void setRunProcessListener(CVSProcessListener l) {
        this._runProcessListener = l;
    }

    public Integer getExitCode() {
        return this._exitCode;
    }

    public String getOutputText() {
        return this._outTask != null ? this._outTask.getOutput() : null;
    }

    public String getErrorText() {
        return CVSRunnerUtil.getErrorText(this, this._errTask != null ? this._errTask.getOutput() : null);
    }

    public byte[] getOutputBytes() {
        return this._outTask != null ? this._outTask.getOutputBytes() : null;
    }

    private String determineExecutionContextEncoding() {
        CVSRootContext rootContext = CVSRunnerUtil.getExecutionContext(this);
        if (rootContext == null) {
            return null;
        }
        CVSConnectionData connection = rootContext.getConnection();
        return connection != null ? connection.getEncoding() : null;
    }

    private String[] addNoConvertEOLOptionForCustomEncoding(String[] cmdArray) {
        String[] cmdArray0 = new String[cmdArray.length + 1];
        System.arraycopy(cmdArray, 0, cmdArray0, 1, cmdArray.length);
        cmdArray0[0] = "-E";
        return cmdArray0;
    }

    private String[] addOutputEncodingOptionForCustomEncoding(String[] cmdArray, String charsetName) {
        String[] cmdArray0 = new String[cmdArray.length + 2];
        System.arraycopy(cmdArray, 0, cmdArray0, 2, cmdArray.length);
        cmdArray0[0] = "-C";
        cmdArray0[1] = charsetName;
        return cmdArray0;
    }

    private void _doTimeout() {
        this._isTimedOut = true;
        this._outTask.setExitFlag();
        this._errTask.setExitFlag();
        ClientProcess process = this._process;
        if (process != null) {
            ((Process)process).destroy();
        }
    }

    private void _log(String message) {
        if (this._parameters.isQuiet()) {
            return;
        }
        CVSClient.getInstance().getLogWriter().print(message);
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            int sleepTimeMillis = 10;
            while (eventQueue.peekEvent() != null && sleepTimeMillis < 1000) {
                Thread.sleep(sleepTimeMillis);
                sleepTimeMillis *= 2;
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private void logStartDirectory() {
        this._log((this._dirUrl != null ? URLFileSystem.getPlatformPathName((URL)this._dirUrl) : "") + ">\n");
    }

    private void logCommandString(String[] cmdArray) {
        this._log(this.createCommandStringForLog(cmdArray) + '\n');
    }

    private String createCommandStringForLog(String[] cmdArray) {
        StringBuffer commandBuffer = new StringBuffer("$ <" + CVSArb.getString(60) + ">");
        int i = 0;
        while (i < cmdArray.length) {
            if (commandBuffer.length() > 0) {
                commandBuffer.append(' ');
            }
            if (cmdArray[i].equals("") || cmdArray[i].indexOf(32) >= 0) {
                commandBuffer.append('\"');
                commandBuffer.append(cmdArray[i]);
                commandBuffer.append('\"');
            } else {
                commandBuffer.append(cmdArray[i]);
            }
            ++i;
        }
        return commandBuffer.toString();
    }

    static ClientProcess ra$_process(CVSInternalClientRunner cVSInternalClientRunner) {
        return cVSInternalClientRunner._process;
    }

    static Integer ra$_exitCode(CVSInternalClientRunner cVSInternalClientRunner) {
        return cVSInternalClientRunner._exitCode;
    }

    static void mav$_log(CVSInternalClientRunner cVSInternalClientRunner, String string) {
        cVSInternalClientRunner._log(string);
    }

    static Thread ra$_executionThread(CVSInternalClientRunner cVSInternalClientRunner) {
        return cVSInternalClientRunner._executionThread;
    }

    static void mav$_doTimeout(CVSInternalClientRunner cVSInternalClientRunner) {
        cVSInternalClientRunner._doTimeout();
    }

    final class 1
    implements CVSProcess {
        public Process getProcess() {
            return CVSInternalClientRunner.ra$_process(CVSInternalClientRunner.this);
        }

        public void waitForRedirectOutput() {
        }

        public void log(String message) {
            CVSInternalClientRunner.mav$_log(CVSInternalClientRunner.this, message);
        }
    }

    final class 2
    extends RunnerTimeoutTask {
        public final void doTimeout() {
            CVSInternalClientRunner.mav$_doTimeout(CVSInternalClientRunner.this);
        }

        public 2(int n) {
            super((long)n);
        }
    }

    public static class Ssh2Prompter
    extends OCVSPrompter {
        private RunnerTimeoutTask _timeoutTask;

        private void setTimeoutTask(RunnerTimeoutTask timeoutTask) {
            this._timeoutTask = timeoutTask;
        }

        public String promptPassword(OCVSRoot root, String message) {
            return null;
        }

        public boolean promptSsh2YesNo(String message) {
            try {
                this.suspendTimeoutTask();
                boolean bl = MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)message, (String)CVSArb.getString(89), null);
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.resumeTimeoutTask();
            }
        }

        public String promptSsh2Passphrase(String message) {
            return this.promptSsh2PassphraseImpl(message, new 1(this));
        }

        public String promptSsh2Password(String message) {
            return this.promptSsh2PassphraseImpl(message, new SimplePasswordDialog(null));
        }

        protected String promptSsh2PassphraseImpl(String message, SimpleInputDialog inputDialog) {
            try {
                this.suspendTimeoutTask();
                String string = inputDialog.show(CVSArb.getString(89), CVSArb.format(494, message), null) ? inputDialog.getInputValue() : null;
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.resumeTimeoutTask();
            }
        }

        private void suspendTimeoutTask() {
            if (this._timeoutTask != null) {
                this._timeoutTask.suspend();
            }
        }

        private void resumeTimeoutTask() {
            if (this._timeoutTask != null) {
                this._timeoutTask.resume();
            }
        }

        static void mav$setTimeoutTask(Ssh2Prompter ssh2Prompter, RunnerTimeoutTask runnerTimeoutTask) {
            ssh2Prompter.setTimeoutTask(runnerTimeoutTask);
        }

        final class 1
        extends SimplePasswordDialog {
            protected boolean canOk() {
                return true;
            }

            public 1(Ssh2Prompter ssh2Prompter2) {
                super((1)null);
            }
        }

        private class SimplePasswordDialog
        extends SimpleInputDialog {
            protected JTextComponent createInputComponent() {
                return new JPasswordField("", 20);
            }

            private SimplePasswordDialog() {
            }

            SimplePasswordDialog(1 var2_2) {
                this();
            }

            SimplePasswordDialog(oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner$Ssh2Prompter$1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    private class OutputTask
    extends RunnerOutputTask {
        private final CVSProcess _process;

        OutputTask(CVSProcess process, Collection monitors, InputStream in) {
            super(null, monitors, in);
            this._process = process;
        }

        protected void log(String message) {
            CVSInternalClientRunner.mav$_log(CVSInternalClientRunner.this, message);
        }

        protected void doLineUpdate(String s) throws Exception {
            Iterator itr = this.getMonitors().iterator();
            while (itr.hasNext()) {
                ((CVSProcessStreamMonitor)itr.next()).streamLine(s, this._process);
            }
        }

        protected void doPatternCheck(String s) throws Exception {
            for (CVSProcessStreamMonitor monitor : this.getMonitors()) {
                if (monitor.getPattern() == null || s.indexOf(monitor.getPattern()) < 0) continue;
                monitor.patternMatched(this._process);
            }
        }

        protected Integer getExitCode() {
            return CVSInternalClientRunner.ra$_exitCode(CVSInternalClientRunner.this);
        }

        protected void runExiting() {
            ClientProcess process = CVSInternalClientRunner.ra$_process(CVSInternalClientRunner.this);
            if (process != null) {
                ((Process)process).destroy();
            }
        }
    }

    private class ClientProcess
    extends Process {
        private final InputStream _errorStream;
        private final InputStream _inputStream;
        private final OutputStream _outputStream;
        private OCVSProcessIO _io;

        private void $init$() {
            this._errorStream = new PipedInputStream();
            this._inputStream = new PipedInputStream();
            this._outputStream = new PipedOutputStream();
        }

        ClientProcess() {
            this.$init$();
        }

        void setIO(OCVSProcessIO io) {
            this._io = io;
        }

        public void destroy() {
            Thread executionThread = CVSInternalClientRunner.ra$_executionThread(CVSInternalClientRunner.this);
            if (executionThread != null && this._io != null) {
                this._io.setCancelled(true);
            }
            if (executionThread != null) {
                CVSInternalClientRunner.ra$_executionThread(CVSInternalClientRunner.this).interrupt();
            }
        }

        public int exitValue() {
            Integer exitCode = CVSInternalClientRunner.ra$_exitCode(CVSInternalClientRunner.this);
            if (exitCode == null) {
                throw new IllegalThreadStateException();
            }
            return exitCode;
        }

        public InputStream getErrorStream() {
            return this._errorStream;
        }

        public InputStream getInputStream() {
            return this._inputStream;
        }

        public OutputStream getOutputStream() {
            return this._outputStream;
        }

        public int waitFor() throws InterruptedException {
            Integer exitCode;
            while ((exitCode = CVSInternalClientRunner.ra$_exitCode(CVSInternalClientRunner.this)) == null) {
                Thread.sleep(50);
            }
            return exitCode;
        }
    }
}

