/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.runner;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandOptionsTraversable;
import oracle.jdevimpl.vcs.cvs.CVSGlobalOptionId;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSRootContext;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.error.CVSMonitorException;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCommandLine;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessListener;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSEnvironmentVars;

public class CVSRunnerUtil {
    public static final String CVS_ROOT_SWITCH = "-d";
    private static final Pattern RE_ROOT_ERROR = Pattern.compile("aborted\\].*CVSROOT");

    private CVSRunnerUtil() {
    }

    static final void constructRunner(CVSRunner runner) {
        runner.addErrorMonitor(new BlockMonitor(null));
        runner.addErrorMonitor(new SSHHostMonitor1(null));
        runner.addErrorMonitor(new SSHHostMonitor2(null));
        runner.addErrorMonitor(new RSHFailMonitor(null));
        CVSClient client = CVSClient.getInstance();
        if (client == null) {
            return;
        }
        runner.getParameters().setGlobals(CVSCommandOptionsTraversable.createGlobalOptionsMap(client));
        Integer operationTimeout = (Integer)client.getProperties().get("property_operation_timeout");
        if (operationTimeout == null) {
            return;
        }
        runner.setTimeout((int)((double)operationTimeout.intValue() * Math.pow(10.0, 3.0)));
    }

    static final void preExecution(CVSRunner runner) {
        runner.setRunProcessListener(new 1(runner));
    }

    static final void postExecution(CVSRunner runner) throws Exception {
        if (runner.getErrorText() != null) {
            CVSRunnerUtil.checkErrors(runner);
        }
    }

    static final void postExecutionFinal(CVSRunner runner) {
        runner.setRunProcessListener(null);
        if (!runner.getParameters().isKeepCachedFiles()) {
            CVSUtil.clearPerformanceCaches();
        }
    }

    static final String getErrorText(CVSRunner runner, String errorText) {
        if (errorText == null) {
            return errorText;
        }
        long timeout = runner.getTimeout();
        if (!runner.isTimedOut() || timeout <= 0L) {
            return errorText;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(errorText);
        sb.append('\n');
        sb.append(CVSRunnerUtil.getTimeoutErrorMessage(timeout, runner.getParameters().getContext()));
        return sb.toString();
    }

    static final String[] createCommandSpi(CVSRunner runner, String[] cmdarray) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(CVSClient.getInstance().getExecutablePath());
        return CVSRunnerUtil.addCommandParts(runner, cmdarray, cmd);
    }

    static final String[] addCommandParts(CVSRunner runner, String[] cmdarray, Collection cmd) {
        String root;
        if (cmd == null) {
            cmd = new ArrayList<String>();
        }
        if ((root = runner.getParameters().getRoot()) != null) {
            cmd.add(CVS_ROOT_SWITCH);
            cmd.add(root);
        }
        if (runner.getParameters().getGlobals() != null) {
            cmd.addAll(Arrays.asList(CVSRunnerUtil.createGlobalOptionsCommandLine(runner.getParameters().getGlobals())));
        }
        int i = 0;
        while (i < cmdarray.length) {
            cmd.add(cmdarray[i]);
            ++i;
        }
        if (runner.getParameters().getBuilderOptions() != null) {
            cmd.addAll(Arrays.asList(CVSOptionCommandLine.createOptionsCommandLine(runner.getParameters().getBuilderOptions())));
        }
        if (runner.getParameters().getOptions() != null) {
            cmd.addAll(runner.getParameters().getOptions());
        }
        if (runner.getParameters().getFiles() != null) {
            cmd.addAll(runner.getParameters().getFiles());
        }
        return cmd.toArray(new String[0]);
    }

    static final void preExecSpi(CVSRunner runner) {
        CVSRootContext context = CVSRunnerUtil.getExecutionContext(runner);
        Map envpMap = CVSEnvironmentVars.getInstance().getVariables();
        String cvsRsh = null;
        String cvsServer = null;
        if (context != null) {
            cvsRsh = context.getCVSRsh();
            cvsServer = context.getCVSServer();
        }
        if (cvsRsh != null && !cvsRsh.equals("")) {
            cvsRsh = URLFileSystem.getName((URL)URLFactory.newFileURL((String)cvsRsh));
            envpMap.put("CVS_RSH", cvsRsh);
        }
        if (cvsServer != null && !cvsServer.equals("")) {
            envpMap.put("CVS_SERVER", cvsServer);
        }
        runner.setEnvpMapInternal(envpMap);
    }

    static final CVSRootContext getExecutionContext(CVSRunner runner) {
        if (runner.getParameters().getContext() != null) {
            return runner.getParameters().getContext();
        }
        URL dirUrl = runner.getDirURL();
        if (dirUrl == null) {
            return null;
        }
        CVSRootString rootstr = null;
        try {
            rootstr = CVSRootCache.getInstance().getRoot(dirUrl);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (rootstr == null) {
            return null;
        }
        return new CVSRootContext(rootstr);
    }

    private static final void checkErrors(CVSRunner runner) throws Exception {
        if (runner.getErrorText() == null) {
            return;
        }
        if (!RE_ROOT_ERROR.matcher(runner.getErrorText()).find()) {
            return;
        }
        throw new CVSOperationException(CVSArb.format(184, runner.getParameters().getRoot()));
    }

    private static final String getTimeoutErrorMessage(long timeout, CVSRootContext context) {
        String errorMessage = CVSArb.format(290, String.valueOf((int)Math.ceil((float)timeout / 1000.0f)));
        if (context == null || !context.isAccessExternalSSH()) {
            return errorMessage;
        }
        StringBuffer errorMessageBuffer = new StringBuffer();
        if (errorMessage != null && errorMessage.length() > 0) {
            errorMessageBuffer.append(errorMessage);
            errorMessageBuffer.append('\n');
        }
        errorMessageBuffer.append(CVSArb.getString(402));
        return errorMessageBuffer.toString();
    }

    private static final String[] createGlobalOptionsCommandLine(Map globalsMap) {
        Object value = null;
        ArrayList<String> cmd = new ArrayList<String>();
        value = globalsMap.get((Object)CVSGlobalOptionId.L_NO_HISTORY_LOGGING);
        if (value != null && ((Boolean)value).booleanValue() && CVSRunnerUtil.isGlobalSupported(CVSGlobalOptionId.L_NO_HISTORY_LOGGING)) {
            cmd.add("-l");
        }
        if ((value = globalsMap.get((Object)CVSGlobalOptionId.Q_BE_QUIET)) != null && ((Boolean)value).booleanValue() && CVSRunnerUtil.isGlobalSupported(CVSGlobalOptionId.Q_BE_QUIET)) {
            cmd.add("-q");
        }
        if ((value = globalsMap.get((Object)CVSGlobalOptionId.R_MAKE_NEW_FILES_READ_ONLY)) != null && ((Boolean)value).booleanValue() && CVSRunnerUtil.isGlobalSupported(CVSGlobalOptionId.R_MAKE_NEW_FILES_READ_ONLY)) {
            cmd.add("-r");
        }
        if ((value = globalsMap.get((Object)CVSGlobalOptionId.X_ENCRYPT)) != null && ((Boolean)value).booleanValue() && CVSRunnerUtil.isGlobalSupported(CVSGlobalOptionId.X_ENCRYPT)) {
            cmd.add("-x");
        }
        if ((value = globalsMap.get((Object)CVSGlobalOptionId.Z_SET_GZIP_LEVEL)) != null && ((Boolean)value).booleanValue() && CVSRunnerUtil.isGlobalSupported(CVSGlobalOptionId.Z_SET_GZIP_LEVEL) && (value = globalsMap.get((Object)CVSGlobalOptionId.Z_GZIP_LEVEL)) != null) {
            cmd.add("-z");
            cmd.add(Integer.toString((Integer)value));
        }
        return cmd.toArray(new String[0]);
    }

    private static final boolean isGlobalSupported(CVSGlobalOptionId id) {
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedGlobalOption(id);
    }

    static String maS$getTimeoutErrorMessage(long l, CVSRootContext cVSRootContext) {
        return CVSRunnerUtil.getTimeoutErrorMessage(l, cVSRootContext);
    }

    static final class oracle.jdevimpl.vcs.cvs.runner.CVSRunnerUtil$1
    implements CVSProcessListener {
        private final /* synthetic */ CVSRunner v$runner;

        public final void processFinished(int exitCode) {
            long timeout = this.v$runner.getTimeout();
            if (this.v$runner.getParameters().isQuiet() || this.v$runner.getExitCode() != null) {
                return;
            }
            if (!this.v$runner.isTimedOut() || timeout <= 0L) {
                return;
            }
            CVSClient.getInstance().getLogWriter().println("cvs client> " + CVSRunnerUtil.maS$getTimeoutErrorMessage(timeout, this.v$runner.getParameters().getContext()));
            EventQueue.invokeLater(new 1());
        }

        public oracle.jdevimpl.vcs.cvs.runner.CVSRunnerUtil$1(CVSRunner cVSRunner) {
            this.v$runner = cVSRunner;
        }

        final class 1
        implements Runnable {
            public final void run() {
                LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                LogManager.getLogManager().showLog();
            }
        }
    }

    private static abstract class SSHAbstractHostMonitor
    extends CVSProcessStreamMonitor {
        private SSHAbstractHostMonitor(String pattern) {
            super(pattern);
        }

        protected final void patternMatched(RunProcess process) throws Exception {
            throw new CVSMonitorException(CVSArb.getString(10));
        }

        SSHAbstractHostMonitor(String string, 1 var2_2) {
            this(string);
        }

        public final class 1 {
        }
    }

    private static class SSHHostMonitor1
    extends SSHAbstractHostMonitor {
        private SSHHostMonitor1() {
            super("The authenticity of host", null);
        }

        SSHHostMonitor1(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class SSHHostMonitor2
    extends SSHAbstractHostMonitor {
        private SSHHostMonitor2() {
            super("Host key not found", null);
        }

        SSHHostMonitor2(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class RSHFailMonitor
    extends CVSProcessStreamMonitor {
        private RSHFailMonitor() {
            super("warning: unrecognized response");
        }

        protected final void patternMatched(RunProcess process) throws Exception {
            throw new CVSMonitorException(CVSArb.getString(342));
        }

        RSHFailMonitor(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BlockMonitor
    extends CVSProcessStreamMonitor {
        protected final void streamLine(String line, RunProcess process) throws Exception {
            if (line.indexOf("waiting for") >= 0 && line.indexOf("lock in") >= 0) {
                throw new CVSMonitorException(CVSArb.getString(584));
            }
        }

        private BlockMonitor() {
        }

        BlockMonitor(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

