/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.cvs.util.CVSFileConstants;

public final class CVSAdminProperties {
    private final URL m_url;
    private Properties m_props;

    private void $init$() {
        this.m_props = null;
    }

    public CVSAdminProperties(URL dir) {
        this.$init$();
        this.m_url = CVSAdminProperties.determinePropertiesURL(dir);
    }

    public final boolean hasProperty(Object key) {
        return this.getProperty(key) != null;
    }

    public final String getProperty(Object key) {
        return (String)this.getProperties().get(key);
    }

    public final void putProperty(Object key, String value) {
        this.getProperties().put(key, value);
        this.save();
    }

    public final void removeProperty(Object key) {
        this.getProperties().remove(key);
    }

    private final Properties getProperties() {
        if (this.m_props == null) {
            this.m_props = new Properties();
            this.load();
        }
        return this.m_props;
    }

    private final void load() {
        if (!URLFileSystem.exists((URL)this.m_url) || URLFileSystem.isDirectory((URL)this.m_url)) {
            return;
        }
        try {
            this.m_props.load(new BufferedInputStream(URLFileSystem.openInputStream((URL)this.m_url)));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private final void save() {
        if (URLFileSystem.exists((URL)this.m_url) && URLFileSystem.isDirectory((URL)this.m_url)) {
            return;
        }
        try {
            this.m_props.store(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.m_url)), null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static final URL determinePropertiesURL(URL dir) {
        return URLFactory.newURL((URL)dir, (String)("CVS" + CVSFileConstants.separatorChar + "JDev"));
    }
}

