/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;

public abstract class CVSDirectoryInvokable
extends VCSDirectoryInvokable {
    public static final int DEFAULT_MILLIS_TO_DECIDE_TO_POPUP = 500;
    public static final int DEFAULT_MILLIS_TO_POPUP = 2000;
    public static final int MAX_ARGUMENTS = 10;

    public CVSDirectoryInvokable(VCSDirectoryInvokableState state) {
        super((VCSInvokableState)state, 10);
    }

    protected void initializeProgressMonitor(DeterminateProgressMonitor monitor) {
        if (!this.isProgressDelayable(this.getState())) {
            monitor.setMillisToDecideToPopup(0);
            monitor.setMillisToPopup(0);
            return;
        }
        super.initializeProgressMonitor(monitor);
    }

    private boolean isProgressDelayable(VCSInvokableState state) {
        return CVSDirectoryInvokable.isProgressDelayable(state.getURLs());
    }

    public static final boolean isProgressDelayable(URL[] invokeUrls) {
        try {
            int i = 0;
            while (i < invokeUrls.length) {
                URL directoryUrl = URLFileSystem.isDirectoryPath((URL)invokeUrls[i]) ? invokeUrls[i] : URLFileSystem.getParent((URL)invokeUrls[i]);
                CVSRootString rootString = CVSRootCache.getInstance().getRoot(directoryUrl);
                if (!CVSDirectoryInvokable.isProgressDelayable(rootString)) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            boolean bl = false;
            return bl;
        }
    }

    public static final boolean isProgressDelayable(CVSRootString rootString) {
        return rootString == null || !rootString.isAccessSsh2();
    }

    protected final boolean doInvocation(URL parent, URL[] invokeUrls) throws Exception {
        ArrayList<URL> invokeFileUrls = new ArrayList<URL>(Arrays.asList(invokeUrls));
        int i = 0;
        while (i < invokeUrls.length) {
            if (URLFileSystem.isDirectory((URL)invokeUrls[i])) {
                invokeFileUrls.remove(invokeUrls[i]);
                if (!this.doInvocation2(invokeUrls[i], new URL[0])) {
                    return false;
                }
            }
            ++i;
        }
        if (invokeFileUrls.size() <= 0) {
            return true;
        }
        return this.doInvocation2(parent, invokeFileUrls.toArray(new URL[0]));
    }

    protected abstract boolean doInvocation2(URL var1, URL[] var2) throws Exception;
}

