/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSListFilesUtil {
    public static final int OPTION_LIST_FILES = 1;
    public static final int OPTION_LIST_DIRECTORIES = 2;
    public static final int OPTION_RECURSIVE = 4;

    private CVSListFilesUtil() {
    }

    public static final List<URL> listFiles(URL directoryUrl, int options) {
        Assert.precondition((boolean)URLFileSystem.isDirectoryPath((URL)directoryUrl));
        if ((options & 4) <= 0) {
            VirtualFileSystemHelper.invalidateDirectory((URL)directoryUrl);
        } else {
            VirtualFileSystemHelper.invalidateDirectoryTree((URL)directoryUrl);
        }
        ArrayList<URL> c = new ArrayList<URL>();
        CVSListFilesUtil._listFiles(directoryUrl, options, c);
        return c;
    }

    private static final void _listFiles(URL directoryUrl, int options, List<URL> c) {
        Assert.precondition((boolean)URLFileSystem.isDirectoryPath((URL)directoryUrl));
        URL[] urls = URLFileSystem.list((URL)directoryUrl);
        if (urls == null) {
            return;
        }
        int i = 0;
        while (i < urls.length) {
            boolean isDirectoryPath = URLFileSystem.isDirectoryPath((URL)urls[i]);
            if ((options & 2) > 0 && isDirectoryPath) {
                c.add(urls[i]);
            }
            if ((options & 1) > 0 && !isDirectoryPath) {
                c.add(urls[i]);
            }
            if (isDirectoryPath && (options & 4) > 0 && !URLFileSystem.getFileName((URL)urls[i]).equals("CVS")) {
                CVSListFilesUtil._listFiles(urls[i], options, c);
            }
            ++i;
        }
    }
}

