/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util;

import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.cvs.util.date.CVSAsctimeFormat;

public final class CVSUniversalTimestamp {
    private final DateFormat m_formatter;
    private Date m_time;
    private long m_translation;

    private void $init$() {
        this.m_formatter = new CVSAsctimeFormat();
        this.m_time = null;
        this.m_translation = 0L;
    }

    private CVSUniversalTimestamp(long ms) {
        this.$init$();
        this.initializeFormatter();
        this.m_time = new Date(CVSUniversalTimestamp.determinePrecisionMillis(ms));
    }

    public CVSUniversalTimestamp(String timestamp) {
        this.$init$();
        this.initializeFormatter();
        if (timestamp == null) {
            return;
        }
        try {
            this.m_time = this.m_formatter.parse(timestamp);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public final long getTime() {
        if (this.m_time == null) {
            return 0L;
        }
        return this.m_time.getTime() + this.m_translation;
    }

    public final Date getDate() {
        if (this.m_time == null) {
            return null;
        }
        return new Date(this.getTime());
    }

    public final void setTimeTranslation(long ms) {
        this.m_translation = ms;
    }

    public final long getTimeTranslation() {
        return this.m_translation;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof CVSUniversalTimestamp)) {
            return false;
        }
        CVSUniversalTimestamp other = (CVSUniversalTimestamp)o;
        if (this.m_time == null || other.m_time == null) {
            return false;
        }
        return this.getDate().equals(other.getDate());
    }

    public final String toString() {
        return this.m_time != null ? this.m_formatter.format(this.getDate()) : "";
    }

    public final boolean hasInternalTime() {
        return this.m_time != null;
    }

    public final long getInternalTime() {
        return this.m_time != null ? this.m_time.getTime() : 0L;
    }

    public static final CVSUniversalTimestamp createTimestamp(URL url) {
        if (!URLFileSystem.exists((URL)url)) {
            return new CVSUniversalTimestamp(null);
        }
        return new CVSUniversalTimestamp(new File(URLFileSystem.getPlatformPathName((URL)url)).lastModified());
    }

    public static final long determinePrecisionMillis(long ms) {
        ms /= 1000L;
        return ms *= 1000L;
    }

    private final void initializeFormatter() {
        this.m_formatter.getCalendar().setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

