/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util;

import oracle.jdevimpl.vcs.util.DelimitedStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSVersionNumber
implements Comparable {
    private final int[] m_parts;
    private final char m_delimiter;

    private CVSVersionNumber(int[] parts, char delimiter) {
        this.m_parts = parts;
        this.m_delimiter = delimiter;
    }

    public static final CVSVersionNumber createVersionNumber(String number, String delimiters) throws NumberFormatException {
        DelimitedStrings ds = new DelimitedStrings(delimiters, null);
        String[] strings = ds.parse(number);
        int[] parts = new int[strings.length];
        int i = 0;
        while (i < strings.length) {
            parts[i] = Integer.parseInt(strings[i]);
            ++i;
        }
        return new CVSVersionNumber(parts, delimiters.charAt(0));
    }

    public void incrementVersion(int part) {
        if (part < 0 || part >= this.m_parts.length) {
            return;
        }
        int n = part;
        this.m_parts[n] = this.m_parts[n] + 1;
    }

    public void decrementVersion(int part) {
        if (part < 0 || part >= this.m_parts.length) {
            return;
        }
        int n = part;
        this.m_parts[n] = this.m_parts[n] - 1;
    }

    public void setVersionValue(int part, int version) {
        if (part < 0 || part >= this.m_parts.length) {
            return;
        }
        this.m_parts[part] = version;
    }

    public int getVersionValue(int part) {
        if (part < 0 || part >= this.m_parts.length) {
            return 0;
        }
        return this.m_parts[part];
    }

    public int compareTo(Object o) {
        CVSVersionNumber other = (CVSVersionNumber)o;
        int n = Math.min(this.m_parts.length, other.m_parts.length);
        int i = 0;
        while (i < n) {
            int result = this.m_parts[i] - other.m_parts[i];
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return this.m_parts.length - other.m_parts.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CVSVersionNumber)) {
            return false;
        }
        CVSVersionNumber other = (CVSVersionNumber)o;
        if (this.m_parts.length != other.m_parts.length) {
            return false;
        }
        int i = 0;
        while (i < this.m_parts.length) {
            if (this.m_parts[i] != other.m_parts[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.m_parts.length) {
            if (i != 0) {
                sb.append(this.m_delimiter);
            }
            sb.append(Integer.toString(this.m_parts[i]));
            ++i;
        }
        return sb.toString();
    }
}

