/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util.log;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.vhv.rlog.RlogFormat;
import oracle.ide.vhv.rlog.RlogModel;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.util.Version;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.op.CVSOperationOpenRevision;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogEntry;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogModel;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CVSLogParser {
    static final List parse(URL url, String log) {
        RlogModel.Entry[] rlogEntries;
        RlogModel rlogModel = null;
        try {
            rlogModel = new RlogFormat().parse((Reader)new StringReader(log));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            List list = Collections.EMPTY_LIST;
            return list;
        }
        CVSEntry adminEntry = null;
        try {
            List entries = CVSEntriesCache.getInstance().getEntries(URLFileSystem.getParent((URL)url));
            adminEntry = CVSEntriesCache.findEntry(entries, url);
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
        ArrayList<1> entries = new ArrayList<1>();
        RlogModel.Entry[] entryArray = rlogEntries = rlogModel.getEntries();
        int n = 0;
        while (n < entryArray.length) {
            RlogModel.Entry rlogEntry = entryArray[n];
            1 entry = new 1(url);
            RevisionIdentifier revision = new RevisionIdentifier(CVSArb.getIcon(45), rlogEntry.getRevision().toString());
            revision.setCurrent(adminEntry != null && adminEntry.getRevision() != null && adminEntry.getRevision().equals(rlogEntry.getRevision().toString()));
            entry.setValue(CVSLogModel.PROPERTIES[1], revision);
            entry.setValue(CVSLogModel.PROPERTIES[2], CVSLogParser.getTagsForRevision(rlogModel.getSymbolicNames(), rlogEntry.getRevision()));
            entry.setValue(CVSLogModel.PROPERTIES[0], rlogEntry.getDate());
            entry.setValue(CVSLogModel.PROPERTIES[3], rlogEntry.getAuthor());
            entry.setValue(CVSLogModel.PROPERTIES[4], rlogEntry.getState());
            entry.setValue(CVSLogModel.PROPERTIES[5], rlogEntry.getLines() != null ? rlogEntry.getLines() : "");
            entry.setValue(CVSLogModel.PROPERTIES[6], rlogEntry.getMessage());
            entries.add(entry);
            ++n;
        }
        return entries;
    }

    private static final Collection<String> getTagsForRevision(Map symbolicNames, Version revision) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Map.Entry entry : symbolicNames.entrySet()) {
            if (!entry.getValue().equals(revision)) continue;
            tags.add((String)entry.getKey());
        }
        Collections.sort(tags);
        return tags;
    }

    CVSLogParser() {
    }

    static final class 1
    extends CVSLogEntry {
        private SoftReference _compareContributor;
        private final /* synthetic */ URL v$url;

        public CompareContributor getCompareContributor() throws Exception {
            if (this._compareContributor == null || this._compareContributor.get() == null) {
                String revision = ((RevisionIdentifier)this.getValue(SharedProperties.getRevisionProperty())).getLabel();
                CVSRevisionInfo info = CVSRevisionUtils.downloadContents(this.v$url, revision, null, true);
                String path = URLFileSystem.getPlatformPathName((URL)this.v$url);
                String resourceName = CVSArb.format(210, new Object[]{revision, path});
                String charsetName = StreamDecoder.getDefaultEncoding((URL)this.v$url);
                if (Boolean.getBoolean("jdev.cvs.debugencoding")) {
                    Assert.println((String)("CVS: History revision has encoding " + charsetName));
                }
                InputStreamTextContributor compareContributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(info.getContents()), charsetName, resourceName, resourceName, URLFileSystem.getSuffix((URL)this.v$url));
                compareContributor.setPatchDescriptor(new PatchCompareDescriptor(URLFileSystem.getFileName((URL)this.v$url)));
                compareContributor.getPatchDescriptor().setPatchParentURL(URLFileSystem.getParent((URL)this.v$url));
                compareContributor.getPatchDescriptor().setLastModified(((Date)this.getValue(SharedProperties.getDateProperty())).getTime());
                RevisionIdentifier revisionIdentifier = (RevisionIdentifier)this.getValue(SharedProperties.getRevisionProperty());
                if (revisionIdentifier != null) {
                    compareContributor.getPatchDescriptor().setRevision(revisionIdentifier.getLabel());
                }
                this._compareContributor = new SoftReference<InputStreamTextContributor>(compareContributor);
            }
            return (CompareContributor)this._compareContributor.get();
        }

        public void view(Context context) throws Exception {
            CVSOperationOpenRevision.openRevisionViewer(context, ((RevisionIdentifier)this.getValue(SharedProperties.getRevisionProperty())).getLabel());
        }

        public 1(URL uRL) {
            this.v$url = uRL;
        }
    }
}

