/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.checkout;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ideri.util.Product;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSNewFilesHandler;
import oracle.jdevimpl.vcs.cvs.CVSNewFilesWatcher2;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSResourceProxy;
import oracle.jdevimpl.vcs.cvs.wiz.checkout.CVSCheckoutModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardAbortException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitWatcher;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardProcessMonitor;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;

public class CVSCheckoutCommitter
extends CVSWizardCommitter
implements CVSCheckoutModelKey {
    private CVSNewFilesWatcher2 _watcher;

    private void $init$() {
        this._watcher = null;
    }

    public String getCommitText() {
        return CVSResourceProxy.getProxy(this.getClass()).getString(288);
    }

    public String getCommitTitle() {
        return CVSResourceProxy.getProxy(this.getClass()).getString(582);
    }

    public void prepareCommit(Map props, Component modal_c) throws CVSWizardException, CVSWizardAbortException {
        try {
            CVSConnectionNodeUtils.ensureLogin(props.get(CVSCheckoutModelKey.KEY_CHECKOUT_CONNECTION_NAME).toString(), modal_c);
        }
        catch (VCSCancelException cce) {
            throw new CVSWizardAbortException();
        }
        catch (VCSException ce) {
            throw new CVSWizardException(ce.getMessage());
        }
    }

    public void commitWizard(Map props, Component modal_c, CVSWizardCommitWatcher watcher) throws CVSWizardException, CVSWizardAbortException {
        this._watcher = null;
        ArrayList<String> options = new ArrayList<String>();
        Object value = props.get(CVSCheckoutModelKey.KEY_CHECKOUT_PRUNE_FOLDERS);
        if (value != null && ((Boolean)value).booleanValue()) {
            options.add("-P");
        }
        URL checkoutDirectoryUrl = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)props.get(CVSCheckoutModelKey.KEY_CHECKOUT_TARGET).toString()), (String)"");
        boolean checkoutToDirectory = (Boolean)props.get(CVSCheckoutModelKey.KEY_CHECKOUT_CHECKOUT_TO_DIR);
        if (checkoutToDirectory) {
            options.add("-d");
            options.add(URLFileSystem.getFileName((URL)checkoutDirectoryUrl));
        }
        options.add(props.get(CVSCheckoutModelKey.KEY_CHECKOUT_MODULE_NAME).toString());
        String root = this.getConnectionRoot(props.get(CVSCheckoutModelKey.KEY_CHECKOUT_CONNECTION_NAME).toString());
        if (!URLFileSystem.exists((URL)checkoutDirectoryUrl) && !URLFileSystem.mkdirs((URL)checkoutDirectoryUrl)) {
            throw new CVSWizardValidationException(CVSResourceProxy.getProxy(this.getClass()).getString(190));
        }
        CVSRunner runner = null;
        try {
            Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(new URL[]{checkoutDirectoryUrl});
            if (!CVSUtil.saveDirtyNodes(Arrays.asList(affectedNodes))) {
                throw new VCSCancelException();
            }
            runner = CVSRunnerFactory.getInstance().createRunner();
            runner.addOutputMonitor(new CVSWizardProcessMonitor(watcher));
            runner.getParameters().setRoot(root);
            runner.setCommand(this.getCommandString());
            runner.getParameters().setOptions(options);
            runner.getParameters().setBuilderOptions(props);
            runner.setDirURL(checkoutToDirectory ? URLFileSystem.getParent((URL)checkoutDirectoryUrl) : checkoutDirectoryUrl);
            runner.getParameters().setQuiet(false);
            this._watcher = new CVSNewFilesWatcher2(checkoutDirectoryUrl);
            this._watcher.takeSnapshotOne();
            runner.exec();
        }
        catch (VCSCancelException cce) {
            throw new CVSWizardAbortException();
        }
        catch (VCSException ce) {
            throw new CVSWizardException(ce.getMessage());
        }
        catch (Exception e) {
            CVSClient.getInstance().getExceptionHandler().handleException(e);
            URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{checkoutDirectoryUrl});
            CVSClient.getInstance().getStatusCache().clear(filter);
            VCSControlCache.getInstance().fireControlStateChanged(CVSClient.getInstance().getId());
            try {
                return;
            }
            catch (Throwable throwable) {
                filter = VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{checkoutDirectoryUrl});
                CVSClient.getInstance().getStatusCache().clear(filter);
                VCSControlCache.getInstance().fireControlStateChanged(CVSClient.getInstance().getId());
                throw throwable;
            }
        }
        URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{checkoutDirectoryUrl});
        CVSClient.getInstance().getStatusCache().clear(filter);
        VCSControlCache.getInstance().fireControlStateChanged(CVSClient.getInstance().getId());
        if (watcher.isCancelled()) {
            throw new CVSWizardAbortException();
        }
        this._watcher.takeSnapshotTwo();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            String error = CVSResourceProxy.getProxy(this.getClass()).getString(189);
            throw new CVSWizardException(error, runner.getErrorText());
        }
    }

    public void doneCommitting(Map props) {
        if (this._watcher == null) {
            return;
        }
        URL checkoutDirectoryUrl = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)props.get(CVSCheckoutModelKey.KEY_CHECKOUT_TARGET).toString()), (String)"");
        String moduleName = (String)props.get(CVSCheckoutModelKey.KEY_CHECKOUT_MODULE_NAME);
        try {
            if (!Product.isRaptor()) {
                CVSNewFilesHandler.handleNewFiles(this.getContext(), this._watcher, checkoutDirectoryUrl, moduleName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getCommandString() {
        return "checkout";
    }

    private final String getConnectionRoot(String connection) {
        String root = CVSConnectionNodes.getConnectionListAPI().getConnectionRoot(connection);
        Assert.check((root != null ? 1 : 0) != 0);
        return root;
    }

    public CVSCheckoutCommitter() {
        this.$init$();
    }
}

