/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSRootContext;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRoot;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectTestListener;

class CVSConnectTester
implements CVSConnectModelKey {
    private static final Collection _ignorablePrefixes = CVSConnectTester.createIgnorablePrefixes();
    private Writer _writer;
    private CVSConnectTestListener _listener;
    private Component _component;
    private TesterThread _thread;

    private void $init$() {
        this._writer = null;
        this._listener = null;
        this._component = null;
        this._thread = null;
    }

    synchronized void initializeWriter(Writer writer) {
        this._writer = writer;
    }

    synchronized void initializeListener(CVSConnectTestListener listener) {
        this._listener = listener;
    }

    synchronized void initializeComponent(Component component) {
        this._component = component;
    }

    final synchronized void performTest(Map props) {
        if (this._thread != null) {
            return;
        }
        this._listener.testCommenced();
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        if (!client.isClientAvailable()) {
            new TesterResultsWriter(this._writer).writeln(CVSArb.getString(634));
            this.getListener().testTerminated();
            return;
        }
        this.setThread(new 1(this, props));
        this._thread.start();
    }

    final synchronized void destroyThread() {
        if (this._thread != null) {
            TesterThread.mav$kill(this._thread);
        }
    }

    synchronized Writer getWriter() {
        return this._writer;
    }

    synchronized CVSConnectTestListener getListener() {
        return this._listener;
    }

    synchronized Component getComponent() {
        return this._component;
    }

    synchronized TesterThread getThread() {
        return this._thread;
    }

    private synchronized void setThread(TesterThread thread) {
        this._thread = thread;
    }

    private static final Collection createIgnorablePrefixes() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("cvs rtag:");
        c.add("cvs [rtag aborted]:");
        c.add("cvs [server aborted]:");
        return c;
    }

    private static final String formatOutputLine(String line) {
        if (line == null) {
            return null;
        }
        Iterator itr = _ignorablePrefixes.iterator();
        while (itr.hasNext()) {
            String prefix = itr.next().toString();
            int n = prefix.length();
            if (!line.startsWith(prefix) || line.length() <= n) continue;
            line = line.substring(n);
        }
        return (line = line.replaceAll("JSch", "SSH2")).equals("") ? null : line;
    }

    CVSConnectTester() {
        this.$init$();
    }

    static Writer ra$_writer(CVSConnectTester cVSConnectTester) {
        return cVSConnectTester._writer;
    }

    static String maS$formatOutputLine(String string) {
        return CVSConnectTester.formatOutputLine(string);
    }

    static void mav$setThread(CVSConnectTester cVSConnectTester, TesterThread testerThread) {
        cVSConnectTester.setThread(testerThread);
    }

    final class oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectTester$1
    extends TesterThread {
        protected final void testFinished() {
            EventQueue.invokeLater(new 1());
            CVSConnectTester.mav$setThread(CVSConnectTester.this, null);
        }

        public oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectTester$1(CVSConnectTester cVSConnectTester2, Map map) {
            super(map, null);
        }

        final class 1
        implements Runnable {
            public void run() {
                CVSConnectTester.this.getListener().testTerminated();
            }
        }
    }

    private class TesterResultsWriter {
        private final BufferedWriter _bufferedWriter;
        private boolean _lineWritten;

        TesterResultsWriter(Writer writer) {
            this._bufferedWriter = new BufferedWriter(writer);
        }

        void writeln(String line) {
            this.writeln(line, false);
        }

        synchronized void writeln(String line, boolean append) {
            try {
                if (this._lineWritten && !append) {
                    this._bufferedWriter.newLine();
                } else {
                    this._lineWritten = true;
                }
                if (append) {
                    this._bufferedWriter.write(32);
                }
                this._bufferedWriter.write(line);
                this._bufferedWriter.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private abstract class TesterThread
    extends Thread {
        private final int TIMEOUT_DURATION;
        private final Map _props;
        private final CVSRootContext _context;
        private Boolean _success;
        private CVSProcess _process;
        private boolean _killed;

        private void $init$() {
            this.TIMEOUT_DURATION = 10000;
            this._success = null;
            this._process = null;
            this._killed = false;
        }

        private TesterThread(Map props) {
            this.$init$();
            String root = (String)props.get(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT);
            if (CVSActiveClient.isClientCVSNT()) {
                root = CVSConnectRoot.canonicalizeCVSNTRoot(root);
            }
            this._context = new CVSRootContext(root, (String)props.get(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_RSH), (String)props.get(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_SERVER));
            this._props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            block61: {
                resultsWriter = new TesterResultsWriter(CVSConnectTester.ra$_writer(CVSConnectTester.this));
                testerExceptionHandler = new TesterExceptionHandler(resultsWriter);
                resultsWriter.writeln(CVSArb.getString(411));
                runner = null;
                root = this._context.getCVSRoot();
                if (!CVSLogin.getMethod(root).isLoggedIn(root)) {
                    CVSLogin.getMethod(root).doLogin(root, CVSConnectTester.this.getComponent(), this._props, testerExceptionHandler);
                }
                if (CVSLogin.getMethod(root).isLoggedIn(root)) ** GOTO lbl37
                resultsWriter.writeln(CVSArb.getString(384));
                this.setSuccess(Boolean.FALSE);
                successful = false;
                var10_6 = this;
                synchronized (var10_6) {
                    if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                        CVSClient.getInstance().getLogWriter().println("success: " + (this.getSuccess() != null ? String.valueOf(this.getSuccess()) : "null"));
                        if (runner != null && runner.getExitCode() == null) {
                            CVSClient.getInstance().getLogWriter().println("exit code: null");
                        }
                    }
                    if (this.getSuccess() != null) {
                        successful = this.getSuccess();
                    }
                    if (this.getSuccess() == null && runner != null && runner.getExitCode() != null) {
                        v0 = successful = runner.getExitCode() == 0;
                        if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                            CVSClient.getInstance().getLogWriter().println("exit code: " + runner.getExitCode());
                        }
                    }
                }
                if (successful) {
                    resultsWriter.writeln(CVSArb.getString(614), true);
                } else {
                    resultsWriter.writeln(CVSArb.getString(693));
                }
                this.testFinished();
                return;
lbl37:
                // 1 sources

                cmd = new ArrayList<String>();
                cmd.add("-nq");
                cmd.add("rtag");
                cmd.add("-d");
                cmd.add("bogus_tag");
                cmd.add("bogus_module");
                runner = CVSRunnerFactory.getInstance().createRunner();
                runner.getParameters().setKeepCachedFiles(true);
                runner.getParameters().setContext(this._context);
                runner.addOutputMonitor(new TesterOutputMonitor(resultsWriter));
                runner.addErrorMonitor(new TesterErrorMonitor(resultsWriter));
                runner.getParameters().setGlobals(null);
                runner.setCmdList(cmd);
                runner.setTimeout(10000L);
                runner.getParameters().setQuiet(Boolean.getBoolean("jdev.cvs.debugconnectiontest") ^ true);
                if (!this.isKilled()) ** GOTO lbl82
                successful = false;
                var11_8 = this;
                synchronized (var11_8) {
                    if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                        CVSClient.getInstance().getLogWriter().println("success: " + (this.getSuccess() != null ? String.valueOf(this.getSuccess()) : "null"));
                        if (runner != null && runner.getExitCode() == null) {
                            CVSClient.getInstance().getLogWriter().println("exit code: null");
                        }
                    }
                    if (this.getSuccess() != null) {
                        successful = this.getSuccess();
                    }
                    if (this.getSuccess() == null && runner != null && runner.getExitCode() != null) {
                        v2 = successful = runner.getExitCode() == 0;
                        if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                            CVSClient.getInstance().getLogWriter().println("exit code: " + runner.getExitCode());
                        }
                    }
                }
                if (successful) {
                    resultsWriter.writeln(CVSArb.getString(614), true);
                } else {
                    resultsWriter.writeln(CVSArb.getString(693));
                }
                this.testFinished();
                return;
lbl82:
                // 1 sources

                this.setProcess(runner.getRunProcess());
                runner.exec();
                if (!this.isKilled()) break block61;
                successful = false;
                var12_9 = this;
                synchronized (var12_9) {
                    if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                        CVSClient.getInstance().getLogWriter().println("success: " + (this.getSuccess() != null ? String.valueOf(this.getSuccess()) : "null"));
                        if (runner != null && runner.getExitCode() == null) {
                            CVSClient.getInstance().getLogWriter().println("exit code: null");
                        }
                    }
                    if (this.getSuccess() != null) {
                        successful = this.getSuccess();
                    }
                    if (this.getSuccess() == null && runner != null && runner.getExitCode() != null) {
                        v4 = successful = runner.getExitCode() == 0;
                        if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                            CVSClient.getInstance().getLogWriter().println("exit code: " + runner.getExitCode());
                        }
                    }
                }
                if (successful) {
                    resultsWriter.writeln(CVSArb.getString(614), true);
                } else {
                    resultsWriter.writeln(CVSArb.getString(693));
                }
                this.testFinished();
                try {
                    return;
                }
                catch (VCSCancelException cce) {
                    try {
                        resultsWriter.writeln(CVSArb.getString(748));
                        this.setSuccess(Boolean.FALSE);
                        break block61;
                        catch (VCSException ce) {
                            testerExceptionHandler.reportException((Exception)ce);
                            this.setSuccess(Boolean.FALSE);
                            break block61;
                        }
                        catch (Exception e) {
                            Assert.printStackTrace((Throwable)e);
                            testerExceptionHandler.reportException(e);
                            this.setSuccess(Boolean.FALSE);
                        }
                    }
                    catch (Throwable var13_13) {
                        successful = false;
                        var14_14 = this;
                        synchronized (var14_14) {
                            if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                                CVSClient.getInstance().getLogWriter().println("success: " + (this.getSuccess() != null ? String.valueOf(this.getSuccess()) : "null"));
                                if (runner != null && runner.getExitCode() == null) {
                                    CVSClient.getInstance().getLogWriter().println("exit code: null");
                                }
                            }
                            if (this.getSuccess() != null) {
                                successful = this.getSuccess();
                            }
                            if (this.getSuccess() == null && runner != null && runner.getExitCode() != null) {
                                v6 = successful = runner.getExitCode() == 0;
                                if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                                    CVSClient.getInstance().getLogWriter().println("exit code: " + runner.getExitCode());
                                }
                            }
                        }
                        if (successful) {
                            resultsWriter.writeln(CVSArb.getString(614), true);
                        } else {
                            resultsWriter.writeln(CVSArb.getString(693));
                        }
                        this.testFinished();
                        throw var13_13;
                    }
                }
            }
            successful = false;
            var15_15 = this;
            synchronized (var15_15) {
                if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                    CVSClient.getInstance().getLogWriter().println("success: " + (this.getSuccess() != null ? String.valueOf(this.getSuccess()) : "null"));
                    if (runner != null && runner.getExitCode() == null) {
                        CVSClient.getInstance().getLogWriter().println("exit code: null");
                    }
                }
                if (this.getSuccess() != null) {
                    successful = this.getSuccess();
                }
                if (this.getSuccess() == null && runner != null && runner.getExitCode() != null) {
                    v8 = successful = runner.getExitCode() == 0;
                    if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                        CVSClient.getInstance().getLogWriter().println("exit code: " + runner.getExitCode());
                    }
                }
            }
            if (successful) {
                resultsWriter.writeln(CVSArb.getString(614), true);
            } else {
                resultsWriter.writeln(CVSArb.getString(693));
            }
            this.testFinished();
        }

        private final synchronized void setProcess(CVSProcess process) {
            this._process = process;
        }

        private final synchronized CVSProcess getProcess() {
            return this._process;
        }

        private final synchronized void setSuccess(Boolean success) {
            this._success = success;
        }

        private final synchronized Boolean getSuccess() {
            return this._success;
        }

        private final synchronized void kill() {
            if (this._process != null) {
                1 r = new 1();
                new Thread(r).start();
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ie) {
                    Assert.printStackTrace((Throwable)ie);
                }
            }
            this._killed = true;
        }

        private final synchronized boolean isKilled() {
            return this._killed;
        }

        protected abstract void testFinished();

        static void mav$kill(TesterThread testerThread) {
            testerThread.kill();
        }

        static Boolean mav$getSuccess(TesterThread testerThread) {
            return testerThread.getSuccess();
        }

        static void mav$setSuccess(TesterThread testerThread, Boolean bl) {
            testerThread.setSuccess(bl);
        }

        TesterThread(Map map, oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectTester$1 var3_3) {
            this(map);
        }

        static CVSProcess ra$_process(TesterThread testerThread) {
            return testerThread._process;
        }

        final class 1
        implements Runnable {
            public final void run() {
                CVSProcess process = TesterThread.ra$_process(TesterThread.this);
                if (process != null && process.getProcess() != null) {
                    process.getProcess().destroy();
                }
            }
        }
    }

    private class TesterExceptionHandler
    extends VCSExceptionHandler {
        private final TesterResultsWriter _resultsWriter;

        TesterExceptionHandler(TesterResultsWriter resultsWriter) {
            this._resultsWriter = resultsWriter;
        }

        protected void handleExceptionImpl(Exception e, Component parent) {
            this.reportException(e);
            super.handleExceptionImpl(e, parent);
        }

        void reportException(Exception e) {
            if (e instanceof RuntimeException) {
                Assert.printStackTrace((Throwable)e);
                return;
            }
            if (e instanceof VCSException) {
                String detail;
                this._resultsWriter.writeln(e.getMessage());
                String string = detail = e instanceof VCSDetailException ? ((VCSDetailException)e).getDetail() : null;
                if (detail != null) {
                    this._resultsWriter.writeln(detail);
                }
            } else {
                this._resultsWriter.writeln(CVSConnectTester.maS$formatOutputLine(e.getMessage()));
            }
        }
    }

    private final class TesterOutputMonitor
    extends CVSProcessStreamMonitor {
        private final TesterResultsWriter _resultsWriter;

        TesterOutputMonitor(TesterResultsWriter resultsWriter) {
            this._resultsWriter = resultsWriter;
        }

        public void streamLine(String line, CVSProcess process) {
            if ((line = CVSConnectTester.maS$formatOutputLine(line)) == null) {
                return;
            }
            this._resultsWriter.writeln(line);
        }
    }

    private final class TesterErrorMonitor
    extends CVSProcessStreamMonitor {
        private final TesterResultsWriter _resultsWriter;

        TesterErrorMonitor(TesterResultsWriter resultsWriter) {
            this._resultsWriter = resultsWriter;
        }

        public void streamLine(String line, CVSProcess process) {
            Boolean success = TesterThread.mav$getSuccess(CVSConnectTester.this.getThread());
            if (success == null && line.indexOf("authorization failed:") >= 0) {
                TesterThread.mav$setSuccess(CVSConnectTester.this.getThread(), Boolean.FALSE);
                return;
            }
            if (success == null && line.indexOf("cannot find module") >= 0) {
                TesterThread.mav$setSuccess(CVSConnectTester.this.getThread(), Boolean.TRUE);
                return;
            }
            if (success == null && line.indexOf("\"rtag\" requires write access to the repository") >= 0) {
                TesterThread.mav$setSuccess(CVSConnectTester.this.getThread(), Boolean.TRUE);
                return;
            }
            if (CVSClient.getInstance().isUsingInternalClient() && line.indexOf("exiting, server error") >= 0) {
                return;
            }
            if ((line = CVSConnectTester.maS$formatOutputLine(line)) == null) {
                return;
            }
            this._resultsWriter.writeln(line);
        }
    }
}

