/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.framework;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizard;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;

public class CVSWizardUtil {
    private CVSWizardUtil() {
    }

    public static final void populateSummaryTree(CVSWizard wizardSpec, DefaultMutableTreeNode root, CVSWizardPage[] pages, Map props) {
        int i = 0;
        while (i < pages.length) {
            Collection children;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(pages[i].getLabel());
            Object[] keys = pages[i].getPropertyKeys();
            if (keys != null && (children = CVSWizardUtil.createSummaryTreeNodes(wizardSpec, props, keys)).size() != 0) {
                Iterator itr = children.iterator();
                while (itr.hasNext()) {
                    node.add((MutableTreeNode)itr.next());
                }
                root.add(node);
            }
            ++i;
        }
    }

    public static final MutableTreeNode createPropertySummaryNode(String template, Object value) {
        if (value == null || value.toString().equals("")) {
            return new DefaultMutableTreeNode(template);
        }
        Object[] args = new Object[6];
        int i = 0;
        args[i++] = value.toString();
        args[i++] = value.toString().toLowerCase();
        args[i++] = value.toString().toUpperCase();
        args[i++] = Integer.toString(value.toString().length());
        if (value instanceof Collection) {
            args[i] = Integer.toString(((Collection)value).size());
        }
        ++i;
        if (value instanceof Long) {
            value = new Date((Long)value);
        }
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy, hh:mm aa");
            args[i++] = formatter.format((Date)value);
        }
        return new DefaultMutableTreeNode(MessageFormat.format(template, args));
    }

    private static final Collection createSummaryTreeNodes(CVSWizard wizardSpec, Map props, Object[] keys) {
        ArrayList<MutableTreeNode> children = new ArrayList<MutableTreeNode>();
        int j = 0;
        while (j < keys.length) {
            Object value;
            String template = wizardSpec.getSummaryTemplate(keys[j]);
            if (!(template == null || (value = props.get(keys[j])) == null || value.toString().equals("") || value instanceof Boolean && !((Boolean)value).booleanValue())) {
                children.add(CVSWizardUtil.createPropertySummaryNode(template, value));
            }
            ++j;
        }
        return children;
    }
}

