/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.import_;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportCreateFilterPanel;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;
import oracle.jdevimpl.vcs.util.FilterPanel;

public class CVSImportFiltersPage
extends CVSWizardPage {
    private static final String[] DEFAULT_IGNORE_PATTERNS = new String[]{"classes", "*.class"};
    private FilterPanel _filterPanel;
    private JPanel _panel;
    private Collection _defaultFilters;

    CVSImportFiltersPage() {
        this.createPanel();
    }

    private void createPanel() {
        JPanel ui = new JPanel(new BorderLayout());
        this._filterPanel = new FilterPanel();
        this._filterPanel.setFilterPanelClass(CVSImportCreateFilterPanel.class);
        this._filterPanel.setNewFilterButtonText(CVSArb.getString(755));
        LinkedHashSet<String> importFilterPatterns = new LinkedHashSet<String>();
        Collection filters = VCSIgnoreFilters.getAllIgnoreFilters();
        Pattern pattern = Pattern.compile("/?\\*?(\\*/)?([^/]+)/?\\*?\\*?");
        for (String filter : filters) {
            if (filter.indexOf(47) < 0) {
                importFilterPatterns.add(filter);
                continue;
            }
            Matcher matcher = pattern.matcher(filter);
            if (matcher.matches()) {
                importFilterPatterns.add(matcher.group(2));
                continue;
            }
            Assert.println((String)("warning: CVS import wizard can't handle complex ignore pattern " + filter));
        }
        this._defaultFilters = this._filterPanel.createFileOrFolderFilters(importFilterPatterns, true);
        ui.add((Component)this._filterPanel, "Center");
        String hint = CVSArb.getString(272);
        this._panel = new CVSHintContainer(hint, ui);
    }

    public String getAccessibleDescription() {
        return CVSArb.getString(272);
    }

    public String getHelpTopic() {
        return "f1_cvsimpwfilters_html";
    }

    public JComponent getPanel() {
        return this._panel;
    }

    public Component getFocusComponent() {
        return this._filterPanel;
    }

    public String getLabel() {
        return CVSArb.getString(215);
    }

    public Object[] getPropertyKeys() {
        return new Object[]{CVSImportModelKey.KEY_IMPORT_FILTER_PATTERNS};
    }

    public void populatePage(Map props) {
        Collection importFilterPatterns = (Collection)props.get(CVSImportModelKey.KEY_IMPORT_FILTER_PATTERNS);
        if (importFilterPatterns == null) {
            this._filterPanel.setAvailableFilters((Collection)Collections.EMPTY_SET);
            this._filterPanel.setSelectedFilters(this._defaultFilters);
            return;
        }
        ArrayList availableFilters = new ArrayList(this._defaultFilters);
        Collection selectedFilters = this._filterPanel.createFileOrFolderFilters(importFilterPatterns, true);
        availableFilters.removeAll(selectedFilters);
        this._filterPanel.setAvailableFilters(availableFilters);
        this._filterPanel.setSelectedFilters(selectedFilters);
    }

    public void validatePage() throws CVSWizardException {
    }

    public void applyPage(Map props) {
        props.put(CVSImportModelKey.KEY_IMPORT_FILTER_PATTERNS, this._filterPanel.getFilterPatterns());
    }
}

