/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.import_;

import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSImportSourcesPageUI;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;

public final class CVSImportSourcesPage
extends CVSWizardPage
implements CVSImportModelKey {
    private JComponent _panel;
    private CVSImportSourcesPageUI _ui;

    private void $init$() {
        this._panel = null;
        this._ui = new CVSImportSourcesPageUI();
    }

    CVSImportSourcesPage() {
        this.$init$();
        this.createPanel();
    }

    private void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        this._ui.getChooserPanel().setChooseFolders(true);
        this._ui.getSourcesLabel().setLabelFor(this._ui.getChooserPanel().getFocusComponent());
        String hint = CVSArb.getString(156);
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    public String getAccessibleDescription() {
        return CVSArb.getString(156);
    }

    public String getHelpTopic() {
        return "f1_cvsimpwsources_html";
    }

    public JComponent getPanel() {
        return this._panel;
    }

    public Component getFocusComponent() {
        return this._ui.getChooserPanel().getFocusComponent();
    }

    public String getLabel() {
        return CVSArb.getString(134);
    }

    public Object[] getPropertyKeys() {
        return new Object[]{CVSImportModelKey.KEY_IMPORT_SOURCES};
    }

    public void populatePage(Map props) {
        Object value = props.get(CVSImportModelKey.KEY_IMPORT_SOURCES);
        if (value != null) {
            this._ui.getChooserPanel().setURL(URLFactory.newFileURL((String)value.toString()));
            return;
        }
        URL url = this.getDefaultChooserURL();
        if (url != null) {
            this._ui.getChooserPanel().setURL(url);
        }
    }

    public void validatePage() throws CVSWizardException {
        URL folder = this._ui.getChooserPanel().getURL();
        if (folder == null || !URLFileSystem.exists((URL)folder) || !URLFileSystem.isDirectory((URL)folder)) {
            throw new CVSWizardValidationException(CVSArb.getString(505));
        }
        if (URLFileSystem.isRoot((URL)folder)) {
            throw new CVSWizardValidationException(CVSArb.getString(504));
        }
    }

    public void applyPage(Map props) {
        URL url = this._ui.getChooserPanel().getURL();
        url = URLFileSystem.canonicalize((URL)url);
        props.put(CVSImportModelKey.KEY_IMPORT_SOURCES, VCSFileSystemUtils.getPlatformPathName((URL)url));
    }

    private URL getDefaultChooserURL() {
        URL url = !Product.isRaptor() ? CVSUtil.getContextDirectoryURL(this.getContext()) : Ide.getWorkspaces().getWorkDirectory();
        return URLFileSystem.exists((URL)url) ? url : URLFactory.newFileURL((String)System.getProperty("user.home"));
    }
}

