/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 13;
    TimestampTzConverter tstzConverter = null;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:45_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    TimestamptzAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 181, 181, s2, bl);
        this.initForDataAccess(n3, n2, null);
        this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
    }

    TimestamptzAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 181, 181, s2, false);
        this.initForDescribe(181, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
        this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 13;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int n2) throws SQLException {
        boolean bl;
        int n3;
        int n4;
        int n5;
        String string;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        int n6 = this.columnIndex + this.byteLength * n2;
        int n7 = 0;
        if ((this.oracleTZ1(n6) & REGIONIDBIT) != 0) {
            n7 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n6));
            if (TIMEZONETAB.checkID(n7 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n6)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n7);
            }
            string = new String(ZONEIDMAP.getRegion(n7));
        } else {
            int n8 = this.oracleTZ1(n6) - OFFSET_HOUR;
            int n9 = this.oracleTZ2(n6) - OFFSET_MINUTE;
            string = new String("GMT" + (n8 < 0 ? "-" : "+") + Math.abs(n8) + ":" + (n9 < 10 ? "0" : "") + n9);
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar = Calendar.getInstance(timeZone);
        int n10 = ((this.rowSpaceByte[0 + n6] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n6] & 0xFF) - 100;
        calendar.set(1, n10);
        calendar.set(2, this.oracleMonth(n6));
        calendar.set(5, this.oracleDay(n6));
        calendar.set(11, this.oracleHour(n6));
        calendar.set(12, this.oracleMin(n6));
        calendar.set(13, this.oracleSec(n6));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n6) & REGIONIDBIT) != 0) {
            n5 = TIMEZONETAB.getOffset(calendar, n7);
            n4 = timeZone.inDaylightTime(calendar.getTime());
            n3 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n5));
            if (n4 == 0 && n3 != 0) {
                calendar.add(14, -1 * timeZone.getDSTSavings());
            } else if (n4 != 0 && n3 == 0) {
                calendar.add(14, timeZone.getDSTSavings());
            }
            calendar.add(14, n5);
        } else {
            calendar.add(10, this.oracleTZ1(n6) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n6) - OFFSET_MINUTE);
        }
        n10 = calendar.get(1);
        n5 = calendar.get(2) + 1;
        n4 = calendar.get(5);
        n3 = calendar.get(11);
        int n11 = calendar.get(12);
        int n12 = calendar.get(13);
        boolean bl2 = bl = n3 < 12;
        if (string.length() > 3 && string.startsWith("GMT")) {
            string = string.substring(3);
        }
        int n13 = this.oracleNanos(n6);
        return this.toText(n10, n5, n4, n3, n11, n12, n13, bl, string);
    }

    String toText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string) throws SQLException {
        return n2 + "-" + n3 + "-" + n4 + " " + n5 + "." + n6 + "." + n7 + "." + n8 + " " + string;
    }

    java.sql.Date getDate(int n2) throws SQLException {
        return this.tstzConverter.getDate(n2);
    }

    Time getTime(int n2) throws SQLException {
        return this.tstzConverter.getTime(n2);
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        return this.tstzConverter.getTimestamp(n2);
    }

    Object getObject(int n2) throws SQLException {
        return this.tstzConverter.getObject(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.tstzConverter.getOracleObject(n2);
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        return this.tstzConverter.getTIMESTAMPTZ(n2);
    }

    static int setHighOrderbits(int n2) {
        return (n2 & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int n2) {
        return (n2 & 0x3F) << 2;
    }

    static int getHighOrderbits(int n2) {
        return (n2 & 0x7F) << 6;
    }

    static int getLowOrderbits(int n2) {
        return (n2 & 0xFC) >> 2;
    }

    abstract class TimestampTzConverter {
        TimestampTzConverter() {
        }

        abstract java.sql.Date getDate(int var1) throws SQLException;

        abstract Time getTime(int var1) throws SQLException;

        abstract Timestamp getTimestamp(int var1) throws SQLException;

        Object getObject(int n2) throws SQLException {
            return this.getTIMESTAMPTZ(n2);
        }

        Datum getOracleObject(int n2) throws SQLException {
            return this.getTIMESTAMPTZ(n2);
        }

        Object getObject(int n2, Map map) throws SQLException {
            return this.getTIMESTAMPTZ(n2);
        }

        abstract TIMESTAMPTZ getTIMESTAMPTZ(int var1) throws SQLException;
    }

    class GmtTimestampTzConverter
    extends TimestampTzConverter {
        GmtTimestampTzConverter() {
        }

        java.sql.Date getDate(int n2) throws SQLException {
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] == -1) {
                return null;
            }
            int n3 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
            int n4 = TimestamptzAccessor.this.oracleTZ1(n3) - OFFSET_HOUR;
            int n5 = TimestamptzAccessor.this.oracleTZ2(n3) - OFFSET_MINUTE;
            Calendar calendar = TimestamptzAccessor.this.statement.getGMTCalendar();
            int n6 = ((TimestamptzAccessor.this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, n6);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(n3));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(n3));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(n3));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(n3));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(n3));
            calendar.set(14, 0);
            long l2 = calendar.getTimeInMillis();
            return new java.sql.Date(l2);
        }

        Time getTime(int n2) throws SQLException {
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] == -1) {
                return null;
            }
            int n3 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
            int n4 = TimestamptzAccessor.this.oracleTZ1(n3) - OFFSET_HOUR;
            int n5 = TimestamptzAccessor.this.oracleTZ2(n3) - OFFSET_MINUTE;
            Calendar calendar = TimestamptzAccessor.this.statement.getGMTCalendar();
            int n6 = ((TimestamptzAccessor.this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, n6);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(n3));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(n3));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(n3));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(n3));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(n3));
            calendar.set(14, 0);
            return new Time(calendar.getTimeInMillis());
        }

        Timestamp getTimestamp(int n2) throws SQLException {
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] == -1) {
                return null;
            }
            int n3 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
            int n4 = TimestamptzAccessor.this.oracleTZ1(n3) - OFFSET_HOUR;
            int n5 = TimestamptzAccessor.this.oracleTZ2(n3) - OFFSET_MINUTE;
            Calendar calendar = TimestamptzAccessor.this.statement.getGMTCalendar();
            int n6 = ((TimestamptzAccessor.this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, n6);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(n3));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(n3));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(n3));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(n3));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(n3));
            calendar.set(14, 0);
            long l2 = calendar.getTimeInMillis();
            Timestamp timestamp = new Timestamp(l2);
            int n7 = TimestamptzAccessor.this.oracleNanos(n3);
            timestamp.setNanos(n7);
            return timestamp;
        }

        TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
            TIMESTAMPTZ tIMESTAMPTZ = null;
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] != -1) {
                int n3 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
                byte[] byArray = new byte[13];
                System.arraycopy(TimestamptzAccessor.this.rowSpaceByte, n3, byArray, 0, 13);
                tIMESTAMPTZ = new TIMESTAMPTZ(byArray);
            }
            return tIMESTAMPTZ;
        }
    }

    class OldTimestampTzConverter
    extends TimestampTzConverter {
        OldTimestampTzConverter() {
        }

        java.sql.Date getDate(int n2) throws SQLException {
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] == -1) {
                return null;
            }
            int n3 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
            TimeZone timeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar calendar = Calendar.getInstance(timeZone);
            int n4 = ((TimestamptzAccessor.this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, n4);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(n3));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(n3));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(n3));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(n3));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(n3));
            calendar.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(n3) & REGIONIDBIT) != 0) {
                int n5 = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(n3));
                if (TIMEZONETAB.checkID(n5 += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(n3)))) {
                    TIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, n5);
                }
                int n6 = TIMEZONETAB.getOffset(calendar, n5);
                boolean bl = timeZone.inDaylightTime(calendar.getTime());
                boolean bl2 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n6));
                if (!bl && bl2) {
                    calendar.add(14, -1 * timeZone.getDSTSavings());
                } else if (bl && !bl2) {
                    calendar.add(14, timeZone.getDSTSavings());
                }
                calendar.add(10, n6 / 3600000);
                calendar.add(12, n6 % 3600000 / 60000);
            } else {
                calendar.add(10, TimestamptzAccessor.this.oracleTZ1(n3) - OFFSET_HOUR);
                calendar.add(12, TimestamptzAccessor.this.oracleTZ2(n3) - OFFSET_MINUTE);
            }
            long l2 = calendar.getTimeInMillis();
            return new java.sql.Date(l2);
        }

        Time getTime(int n2) throws SQLException {
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] == -1) {
                return null;
            }
            int n3 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
            TimeZone timeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar calendar = Calendar.getInstance(timeZone);
            int n4 = ((TimestamptzAccessor.this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, n4);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(n3));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(n3));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(n3));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(n3));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(n3));
            calendar.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(n3) & REGIONIDBIT) != 0) {
                int n5 = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(n3));
                if (TIMEZONETAB.checkID(n5 += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(n3)))) {
                    TIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, n5);
                }
                int n6 = TIMEZONETAB.getOffset(calendar, n5);
                boolean bl = timeZone.inDaylightTime(calendar.getTime());
                boolean bl2 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n6));
                if (!bl && bl2) {
                    calendar.add(14, -1 * timeZone.getDSTSavings());
                } else if (bl && !bl2) {
                    calendar.add(14, timeZone.getDSTSavings());
                }
                calendar.add(10, n6 / 3600000);
                calendar.add(12, n6 % 3600000 / 60000);
            } else {
                calendar.add(10, TimestamptzAccessor.this.oracleTZ1(n3) - OFFSET_HOUR);
                calendar.add(12, TimestamptzAccessor.this.oracleTZ2(n3) - OFFSET_MINUTE);
            }
            long l2 = calendar.getTimeInMillis();
            return new Time(l2);
        }

        Timestamp getTimestamp(int n2) throws SQLException {
            int n3;
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] == -1) {
                return null;
            }
            int n4 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
            TimeZone timeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar calendar = Calendar.getInstance(timeZone);
            int n5 = ((TimestamptzAccessor.this.rowSpaceByte[0 + n4] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + n4] & 0xFF) - 100;
            calendar.set(1, n5);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(n4));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(n4));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(n4));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(n4));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(n4));
            calendar.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(n4) & REGIONIDBIT) != 0) {
                int n6 = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(n4));
                if (TIMEZONETAB.checkID(n6 += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(n4)))) {
                    TIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, n6);
                }
                int n7 = TIMEZONETAB.getOffset(calendar, n6);
                boolean bl = timeZone.inDaylightTime(calendar.getTime());
                n3 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n7)) ? 1 : 0;
                if (!bl && n3 != 0) {
                    calendar.add(14, -1 * timeZone.getDSTSavings());
                } else if (bl && n3 == 0) {
                    calendar.add(14, timeZone.getDSTSavings());
                }
                calendar.add(10, n7 / 3600000);
                calendar.add(12, n7 % 3600000 / 60000);
            } else {
                calendar.add(10, TimestamptzAccessor.this.oracleTZ1(n4) - OFFSET_HOUR);
                calendar.add(12, TimestamptzAccessor.this.oracleTZ2(n4) - OFFSET_MINUTE);
            }
            long l2 = calendar.getTimeInMillis();
            Timestamp timestamp = new Timestamp(l2);
            n3 = TimestamptzAccessor.this.oracleNanos(n4);
            timestamp.setNanos(n3);
            return timestamp;
        }

        TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
            TIMESTAMPTZ tIMESTAMPTZ = null;
            if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
            }
            if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + n2] != -1) {
                int n3 = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * n2;
                byte[] byArray = new byte[13];
                System.arraycopy(TimestamptzAccessor.this.rowSpaceByte, n3, byArray, 0, 13);
                tIMESTAMPTZ = new TIMESTAMPTZ(byArray);
            }
            return tIMESTAMPTZ;
        }
    }
}

