/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL16UTF16
extends CharacterSet
implements CharacterRepConstants {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:16_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    CharacterSetAL16UTF16(int n2) {
        super(n2);
        this.rep = 4;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return !characterSet.isUnicode();
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[n3 >>> 1];
            int n4 = CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, n2, cArray, 0, n3, true);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[n3 >>> 1];
            int n4 = CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, n2, cArray, 0, n3, false);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            CharacterSetAL16UTF16.failUTFConversion();
            return "";
        }
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 4) {
            byArray2 = CharacterSetAL16UTF16.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
        }
        return byArray2;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        if (n2 + 2 >= n3) {
            CharacterSetAL16UTF16.failUTFConversion();
        }
        byte by = byArray[n2++];
        byte by2 = byArray[n2++];
        int n4 = by << 8 & 0xFF00 | by2;
        characterWalker.next = n2;
        return n4;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        if (n2 > 65535) {
            CharacterSetAL16UTF16.failUTFConversion();
        } else {
            CharacterSetAL16UTF16.need(characterBuffer, 2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 & 0xFF);
        }
    }
}

