/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeStarter;
import oracle.ide.Version;

public class IndexStarter
extends IdeStarter {
    private String[] arguments;
    private String index_usage_message;
    String index_copyright_message;

    public void startIde(String command, String[] arguments, IdeCore core) {
        System.setProperty("display.logger.mode", "headless");
        if (arguments.length == 0 || arguments.length == 1 && "-help".equals(arguments[0])) {
            this.printUsage();
            System.exit(0);
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(arguments));
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            if (!"-stats".equals(iterator.next())) continue;
            Logger logger = Logger.getLogger("oracle.ideimpl.index.IndexerStatistics");
            logger.setLevel(Level.FINE);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(Level.FINE);
            logger.addHandler(handler);
            logger.setUseParentHandlers(false);
            iterator.remove();
            break;
        }
        this.arguments = args.toArray(new String[args.size()]);
        IdeArgs ideArgs = core.getIdeArgs();
        ideArgs.setCreateUI(false);
        core.useInvokeLaterForAddinsLoadedEvenThoughHeadless();
        Ide.startup((IdeCore)core);
    }

    public String[] getArguments() {
        return this.arguments;
    }

    private void printUsage() {
        this.printCopyright();
        System.out.println(this.index_usage_message);
        System.out.println();
    }

    private void printCopyright() {
        System.out.println(this.index_copyright_message);
        System.out.println();
    }

    private void $init$() {
        this.index_usage_message = "Index workspaces and or projects.\n\nUsage\n    ojindex file...\n\nParameters\n    file                 Workspace or project to index.\n\nNotes\n    Ojindex indexes files (e.g., java files) within the workspaces or projects.\n\nExamples\n    ojindex application.jws\n      Indexes files in the entire workspace application.jws.\n    ojindex project1.jpr project2.jpr\n      Indexes files in projects project1.jpr and project2.jpr.\n    ojindex application.jws project.jpr\n      Indexes files in application.jws and project.jpr.\n";
        this.index_copyright_message = "Oracle " + Version.NAME_SHORT + " Index " + Version.VER + "." + Version.BUILD_NUM + "\n" + "Copyright (c) 2003-2007 Oracle. All Rights Reserved.";
    }

    public IndexStarter() {
        this.$init$();
    }
}

