/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFContextManager;
import oracle.adf.share.ADFSettings;
import oracle.adf.share.ContextInfo;
import oracle.adf.share.DefaultContext;
import oracle.adf.share.DefaultNamedContext;
import oracle.adf.share.Environment;
import oracle.adf.share.HashMapScopeAdapter;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.ADFContextMDSConfigHelper;
import oracle.adf.share.config.ConfigContainerFactory;
import oracle.adf.share.el.ADFContextVariableResolverImpl;
import oracle.adf.share.el.ADFExpressionEvaluator;
import oracle.adf.share.el.OracleExpressionEvaluatorImpl;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.statemanager.StateManagerScopeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ADFContext {
    public static final int TYPE_GENERIC = 1;
    public static final int TYPE_HTTP = 2;
    public static final int TYPE_PORTLET = 3;
    public static final int TYPE_NAMED = 4;
    public static final String MDS_SESSION_OPTIONS_FACTORY = "oracle.adf.share.mds.SessionOptionsFactory";
    public static final String SESSION_SCOPE = "sessionScope";
    public static final String REQUEST_SCOPE = "requestScope";
    public static final String APPLICATION_SCOPE = "applicationScope";
    public static final String VIEW_SCOPE = "viewScope";
    public static String SESSIONDEF_BASE_PACKAGE = "sessiondef";
    public static String PERSDEF_BASE_PACKAGE = "persdef";
    private static final String SKIP_LEVEL_ID = "#$skip$#";
    public static final String NAMED_CONTEXT_ENV = "named.adf.context";
    public static final String USE_ROLE_BASED_CUST_CLASS = "useRoleBasedCustClass";
    private SecurityContext securityContext;
    private String mLoginStr;
    private Object mdsSession;
    private Locale mLocale;
    private boolean mIsAuthChecked;
    private boolean mIsAuthEnabled;
    private transient Map scopeMap;
    private static Map<Object, Map> mApplicationScopeMap = new WeakHashMap<Object, Map>(4);
    private transient ADFExpressionEvaluator mExpressionEvaluator;
    private transient VariableResolver mVariableResolver;
    private static ThreadLocal contextStore = new InheritableThreadLocal();
    private static transient Map<String, ContextInfo> contextInfos = new HashMap<String, ContextInfo>();
    private static transient Map<String, ADFContext> namedContextMap = new HashMap<String, ADFContext>();
    private static transient Object namedContextLock = new Object();
    private static ADFLogger logger = ADFLogger.createADFLogger(ADFContext.class);
    private static String className = "oracle.adf.share.ADFContext";
    private static ADFContextMDSConfigHelper _mdsConfigHelper = null;
    public static final String CONNECTIONS_RESOURCE = "META-INF/connections.xml";

    private void $init$() {
        this.mLoginStr = null;
        this.mdsSession = null;
        this.mLocale = null;
        this.mIsAuthChecked = false;
        this.mIsAuthEnabled = false;
        this.scopeMap = new HashMap(4);
        this.mExpressionEvaluator = new OracleExpressionEvaluatorImpl();
        this.mVariableResolver = null;
    }

    protected ADFContext() {
        this.$init$();
        ADFContextManager.manageADFContext(this);
    }

    protected abstract Environment loadEnvironment();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScope(String name, Map scope) {
        if (APPLICATION_SCOPE.equals(name)) {
            Object key = this.getApplication().getId();
            Map<Object, Map> map = mApplicationScopeMap;
            synchronized (map) {
                mApplicationScopeMap.put(key, scope);
            }
        }
        Map map = this.scopeMap;
        synchronized (map) {
            this.scopeMap.put(name, scope);
        }
    }

    void connectionsChanged(String filePath) {
        URL url = ClassUtils.getClassLoader().getResource(CONNECTIONS_RESOURCE);
        if (url != null && url.getPath().equals(filePath)) {
            this.getApplicationScope().remove("_cache_application_scope_");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getScope(String name) {
        Map scope = null;
        if (APPLICATION_SCOPE.equals(name)) {
            scope = this.findScope(APPLICATION_SCOPE);
            if (scope == null) {
                scope = this.createScope(name, true);
                Object key = this.getApplication().getId();
                Map<Object, Map> map = mApplicationScopeMap;
                synchronized (map) {
                    mApplicationScopeMap.put(key, scope);
                }
            }
            return scope;
        }
        scope = this.findScope(name);
        if (scope == null) {
            scope = this.createScope(name);
            this.putScope(name, scope);
        }
        return scope;
    }

    public Map findScope(String name) {
        if (APPLICATION_SCOPE.equals(name)) {
            return mApplicationScopeMap.get(this.getApplication().getId());
        }
        return (Map)this.scopeMap.get(name);
    }

    public Map<String, Object> getViewScope() {
        Map scope = (Map)this.scopeMap.get(VIEW_SCOPE);
        if (scope == null) {
            throw new RuntimeException("viewScope implementation has not been provided.");
        }
        return scope;
    }

    public Map createScope(String name) {
        return this.createScope(name, false);
    }

    private Map createScope(String name, boolean concurrent) {
        if (concurrent) {
            return new HashMapScopeAdapter(name, new ConcurrentHashMap(4));
        }
        return new HashMapScopeAdapter(name, new HashMap(4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map removeScope(String name) {
        if (APPLICATION_SCOPE.equals(name)) {
            Object key = this.getApplication().getId();
            Map<Object, Map> map = mApplicationScopeMap;
            synchronized (map) {
                Map map2 = mApplicationScopeMap.remove(key);
                return map2;
            }
        }
        Map map = this.scopeMap;
        synchronized (map) {
            Map map3 = (Map)this.scopeMap.remove(name);
            return map3;
        }
    }

    public Set getScopeNames() {
        Set set = this.scopeMap.keySet();
        if (this.findScope(APPLICATION_SCOPE) != null) {
            HashSet aSet = new HashSet(set);
            aSet.add(APPLICATION_SCOPE);
            return Collections.unmodifiableSet(aSet);
        }
        return set;
    }

    public Map getApplicationScope() {
        return this.getScope(APPLICATION_SCOPE);
    }

    public Map getSessionScope() {
        return this.getScope(SESSION_SCOPE);
    }

    public Map getRequestScope() {
        return this.getScope(REQUEST_SCOPE);
    }

    public ADFConfig getApplication() {
        return this.getADFConfig();
    }

    public ADFConfig getADFConfig() {
        return ADFConfigFactory.findOrCreateADFConfig();
    }

    public ADFSettings getADFSettings() {
        return ConfigContainerFactory.findOrCreateConfig("oracle.adf.share.ADFSettings");
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            try {
                this.securityContext = (SecurityContext)this.getADFConfig().getSecurityContext();
                this.setSecurityContext(this.securityContext);
            }
            catch (NamingException ne) {
                ne.printStackTrace();
            }
        }
        return this.securityContext;
    }

    public boolean hasSecurityContext() {
        if (!this.mIsAuthChecked) {
            this.mIsAuthEnabled = ADFSecurityUtil.isAuthorizationEnabled();
            this.mIsAuthChecked = true;
        }
        if (this.mIsAuthEnabled) {
            return true;
        }
        return this.securityContext != null;
    }

    public Context getConnectionsContext() throws NamingException {
        return this.getADFConfig().getConnectionsContext();
    }

    public static ADFContext getCurrent() {
        ADFContext ctx = (ADFContext)ADFContext.getContextStore().get();
        if (ctx == null) {
            ctx = new DefaultContext();
            ctx.setAsCurrent();
            logger.fine(className, "getCurrent", "DefaultContext is set as current");
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNamedContext(String name, URL url, Class implClass) throws NameAlreadyBoundException {
        if (contextInfos.containsKey(name)) {
            throw new NameAlreadyBoundException("NamedContext for this name alreadyexists " + contextInfos);
        }
        ContextInfo info = new ContextInfo(name, url, implClass);
        Object object = namedContextLock;
        synchronized (object) {
            contextInfos.put(name, info);
        }
    }

    public static void registerNamedContext(String name, URL url) throws NameAlreadyBoundException {
        ADFContext.registerNamedContext(name, url, DefaultNamedContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterNamedContext(String name) {
        if (!contextInfos.containsKey(name)) {
            logger.fine(className, "unregisterNamedContext", "Name not found " + name);
            return;
        }
        Object object = namedContextLock;
        synchronized (object) {
            contextInfos.remove(name);
            namedContextMap.remove(name);
        }
        ADFConfigFactory.unregisterNamedConfig(name);
    }

    public static boolean isNamedContextRegistered(String name) {
        return contextInfos.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFContext get(String name) throws Exception {
        if (name == null || name.length() == 0) {
            return ADFContext.getCurrent();
        }
        if (!contextInfos.containsKey(name)) {
            throw new RuntimeException("Named ADFContext for " + name + " has not been created");
        }
        ADFContext ctx = namedContextMap.get(name);
        if (ctx == null) {
            ContextInfo info = contextInfos.get(name);
            ctx = info.createContext();
            Object object = namedContextLock;
            synchronized (object) {
                if (ctx != null) {
                    namedContextMap.put(name, ctx);
                }
            }
        }
        return ctx;
    }

    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    public String getApplicationName() {
        logger.fine(className, "getApplicationName", "Returns null");
        return null;
    }

    public void setAsCurrent() {
        ADFContext oldContext = (ADFContext)ADFContext.getContextStore().get();
        if (oldContext != null) {
            ADFContextManager.removeADFContext(oldContext);
        }
        ADFContext.getContextStore().set(this);
    }

    public void removeAsCurrent() {
        ADFContextManager.removeADFContext(this);
        ADFContext.getContextStore().set(null);
    }

    public void setSecurityContext(SecurityContext ctx) {
        this.securityContext = ctx;
    }

    public String getMDSLogin() {
        return this.mLoginStr;
    }

    public void setMDSLogin(String loginStr) {
        this.mLoginStr = loginStr;
    }

    protected SecurityContext loadSecurityContext() {
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        SecurityContext secCtx = null;
        try {
            secCtx = (SecurityContext)factory.getInitialContext((Hashtable)null);
            this.setSecurityContext(secCtx);
        }
        catch (NamingException ne) {
            this.getLogger().fine((Throwable)ne);
        }
        return secCtx;
    }

    public Context getConfigSecurityContext() throws NamingException {
        return this.getADFConfig().getSecurityContext();
    }

    public Locale getLocale() {
        if (this.hasEnvironment()) {
            return this.getEnvironment().getRequestLocale();
        }
        return this.mLocale;
    }

    public void setLocale(Locale locale) {
        if (this.mLocale == null) {
            this.mLocale = locale;
        }
    }

    public final Environment getEnvironment() {
        return this.loadEnvironment();
    }

    public boolean hasEnvironment() {
        return false;
    }

    public VariableResolver getVariableResolver() {
        if (this.mVariableResolver == null) {
            this.mVariableResolver = new ADFContextVariableResolverImpl();
        }
        return this.mVariableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        if (variableResolver != null) {
            this.mVariableResolver = variableResolver;
        }
    }

    public ADFExpressionEvaluator getExpressionEvaluator() {
        return this.mExpressionEvaluator;
    }

    public void setExpressionEvaluator(ADFExpressionEvaluator expressionEvaluator) {
        if (expressionEvaluator != null) {
            this.mExpressionEvaluator = expressionEvaluator;
        }
    }

    public Map getStateManager(String scopeName, Hashtable env) {
        return new StateManagerScopeAdapter(scopeName, env);
    }

    public abstract int getContextType();

    public boolean isHttpContext() {
        return false;
    }

    public boolean hasSession() {
        return false;
    }

    public Object getMDSInstanceAsObject() {
        return this.getADFConfig().getMDSInstance();
    }

    public synchronized Object getMDSSessionAsObject() {
        if (this.mdsSession == null) {
            this.mdsSession = this.getMDSConfigHelper().createMDSSession(this);
        }
        return this.mdsSession;
    }

    public boolean hasMDSSession() {
        return this.mdsSession != null;
    }

    public Object getSkipLevelIdentifier() {
        return SKIP_LEVEL_ID;
    }

    private static ThreadLocal getContextStore() {
        return contextStore;
    }

    protected ADFContextMDSConfigHelper getMDSConfigHelper() {
        try {
            if (_mdsConfigHelper != null) {
                ADFContextMDSConfigHelper aDFContextMDSConfigHelper = _mdsConfigHelper;
                return aDFContextMDSConfigHelper;
            }
            Class MDSHelperClass = ClassUtils.forName((String)"oracle.adf.share.config.ADFContextMDSConfigHelperImpl", this.getClass());
            ADFContextMDSConfigHelper aDFContextMDSConfigHelper = _mdsConfigHelper = (ADFContextMDSConfigHelper)MDSHelperClass.newInstance();
            return aDFContextMDSConfigHelper;
        }
        catch (Exception e) {
            this.getLogger().fine((Throwable)e);
            return null;
        }
    }

    private ADFLogger getLogger() {
        return logger;
    }
}

