/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.lang.reflect.Constructor;
import java.net.URL;
import oracle.adf.share.ADFContext;
import oracle.adf.share.logging.ADFLogger;

public final class ContextInfo {
    private String _name;
    private URL _url;
    private Class _class;
    private static Class[] _parameterTypes = new Class[]{String.class, URL.class};
    private Constructor _constructor;
    private static ADFLogger logger = ADFLogger.createADFLogger(ContextInfo.class);

    public ContextInfo(String name, URL url, Class implClass) {
        this._name = name;
        this._url = url;
        this._class = implClass;
        try {
            this._constructor = this._class.getConstructor(_parameterTypes);
        }
        catch (NoSuchMethodException e) {
            logger.info((Throwable)e);
        }
    }

    public String getName() {
        return this._name;
    }

    public URL getUrl() {
        return this._url;
    }

    public ADFContext createContext() {
        try {
            Object[] parameters = new Object[]{this._name, this._url};
            ADFContext aDFContext = (ADFContext)this._constructor.newInstance(parameters);
            return aDFContext;
        }
        catch (Exception e) {
            logger.info((Throwable)e);
            return null;
        }
    }
}

